/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMElement;
import jadex.runtime.impl.IEncodable;
import jadex.runtime.impl.IRElement;
import jadex.runtime.impl.RCapability;
import jadex.util.SReflect;
import jadex.util.WeakObject;
import jadex.util.collection.SCollection;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class RElement
implements IRElement,
Serializable,
IEncodable {
    protected String name;
    private IMElement modelelement;
    private transient WeakObject owner;
    private RCapability scope;
    protected Map exparams;
    protected boolean cleanedup;
    protected Object serialized_owner;

    protected RElement(IMElement modelelement, RElement owner) {
        this(null, modelelement, owner);
    }

    protected RElement(String name, IMElement modelelement, RElement owner) {
        this(name, modelelement, owner, null);
    }

    protected RElement(String name, IMElement modelelement, RElement owner, Map exparams) {
        this.modelelement = modelelement;
        this.owner = owner == null ? null : new WeakObject(owner);
        this.scope = this.findScope();
        String string = this.name = name != null ? name : modelelement.getName() + "#" + this.scope.instanceCount(modelelement);
        if (exparams != null) {
            this.setExpressionParameters(exparams);
        }
    }

    public void cleanup() {
        if (this.cleanedup) {
            return;
        }
        this.cleanedup = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.cleanedup) {
            this.scope.getAgent().scheduleGarbageCollection(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDetailName() {
        return this.getOwner() != null ? this.getOwner().getDetailName() + "." + this.name : this.name;
    }

    public IMElement getModelElement() {
        return this.modelelement;
    }

    public String getType() {
        return this.getModelElement().getName();
    }

    public RElement getOwner() {
        return this.owner == null ? null : (RElement)this.owner.get();
    }

    public RCapability getScope() {
        return this.scope;
    }

    protected Map createLocalExpressionParameters() {
        return this.getOwner() == null ? SCollection.createHashMap() : SCollection.createNestedMap(this.getOwner().getExpressionParameters());
    }

    public Map getExpressionParameters() {
        return this.exparams != null ? this.exparams : (this.getOwner() != null ? this.getOwner().getExpressionParameters() : null);
    }

    protected void setExpressionParameters(Map parameters) {
        if (this.exparams == null) {
            this.exparams = this.createLocalExpressionParameters();
        }
        this.exparams.putAll(parameters);
    }

    public Object getExpressionParameter(String name) {
        Map map = this.getExpressionParameters();
        return map != null ? map.get(name) : null;
    }

    public void setExpressionParameter(String name, Object value) {
        if (this.exparams == null) {
            this.exparams = this.createLocalExpressionParameters();
        }
        this.exparams.put(name, value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(name=");
        sb.append(this.getName());
        sb.append(")");
        return sb.toString();
    }

    public Map getEncodableRepresentation() {
        HashMap rep = SCollection.createHashMap();
        rep.put("isencodeablepresentation", "true");
        rep.put("type", this.getType());
        rep.put("name", this.getName());
        rep.put("id", this.getClass().getName() + "@" + this.hashCode());
        rep.put("class", SReflect.getInnerClassName(this.getClass()));
        rep.put("owner", this.getOwner() == null ? "null" : this.getOwner().getDetailName());
        return rep;
    }

    public RCapability findScope() {
        RElement tmp;
        for (tmp = this; tmp != null && !(tmp instanceof RCapability); tmp = tmp.getOwner()) {
        }
        if (tmp == null) {
            throw new RuntimeException("No scope found for: " + this);
        }
        return (RCapability)tmp;
    }

    public boolean isCleanedup() {
        return this.cleanedup;
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.serialized_owner = this.owner != null ? this.owner.get() : null;
        return this;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.owner = this.serialized_owner != null ? new WeakObject(this.serialized_owner) : null;
        this.serialized_owner = null;
        return this;
    }
}

