/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMCondition;
import jadex.model.IMExpressionbase;
import jadex.model.IMReferenceableElement;
import jadex.runtime.IFilter;
import jadex.runtime.InternalEventFilter;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IInterpreterCondition;
import jadex.runtime.impl.IRCondition;
import jadex.runtime.impl.InterpreterCondition;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RExpression;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.agenda.IAgendaAction;
import jadex.runtime.impl.agenda.conditions.ConditionDefaultAction;
import jadex.util.SReflect;
import java.util.Iterator;

public class RCondition
extends RExpression
implements IRCondition,
IInterpreterCondition {
    protected Boolean lastvalue;
    protected String trigger;
    protected InterpreterCondition condel;

    protected RCondition(IMCondition model, RElement owner, RReferenceableElement creator, IAgendaAction action) {
        super(model, owner, creator, null);
        this.condel = this.getDelegate(action);
    }

    protected InterpreterCondition getDelegate(IAgendaAction action) {
        return new InterpreterCondition(action == null ? new ConditionDefaultAction(this) : action, this.getScope()){

            public boolean isAffected(SystemEvent event) {
                return RCondition.this.isAffected(event);
            }

            public boolean isTriggered() {
                return RCondition.this.isTriggered();
            }
        };
    }

    public void cleanup() {
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        this.setTraceMode("never");
        if (this.isTemporary()) {
            IMReferenceableElement elem = (IMReferenceableElement)this.getModelElement();
            ((IMExpressionbase)this.getScope().getExpressionbase().getModelElement()).deleteReferenceableElement(elem);
        }
    }

    public String getTraceMode() {
        return this.condel.getTraceMode();
    }

    public void setTraceMode(String trace) {
        this.condel.setTraceMode(trace);
    }

    public void traceOnce() {
        this.condel.traceOnce();
    }

    public void traceAlways() {
        this.condel.traceAlways();
    }

    public Boolean evaluate() {
        Boolean value = null;
        try {
            value = (Boolean)this.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Expression could not be evaluated: " + this);
        }
        return value;
    }

    public boolean isTriggered() {
        Boolean value = this.evaluate();
        boolean triggered = false;
        Object triggertype = this.getTrigger();
        if (triggertype.equals("always") || triggertype.equals("is_true") && value != null && value != false || triggertype.equals("is_false") && value != null && value == false || triggertype.equals("changes_to_true") && value != null && value != false && (this.lastvalue == null || this.lastvalue == false) || triggertype.equals("changes_to_false") && value != null && value == false && (this.lastvalue == null || this.lastvalue != false) || triggertype.equals("changes") && (value != null && !value.equals(this.lastvalue) || this.lastvalue != null && !this.lastvalue.equals(value))) {
            triggered = true;
            if ("once".equals(this.condel.getTraceMode())) {
                this.condel.trace = "never";
                this.getScope().getExpressionbase().removeCondition(this.condel);
            }
        }
        this.lastvalue = value;
        if (triggered) {
            this.throwSystemEvent("condition_triggered");
        }
        return triggered;
    }

    public Boolean getLastValue() {
        return this.lastvalue;
    }

    public Object getTrigger() {
        return this.trigger != null ? this.trigger : ((IMCondition)this.getModelElement()).getTrigger();
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    public IFilter getFilter() {
        InternalEventFilter confi = new InternalEventFilter("InternalEvent_condition_triggered");
        confi.addValue("condition", this);
        return confi;
    }

    public void systemEventsOccurred(Iterator events) {
        this.condel.systemEventsOccurred(events);
    }

    protected void doTrace(SystemEvent cause) {
        this.condel.doTrace(cause);
    }

    public void setAction(IAgendaAction action) {
        this.condel.setAction(action);
    }

    public IAgendaAction getAction() {
        return this.condel.getAction();
    }

    public boolean isDisabled() {
        return this.condel.isDisabled();
    }

    public void reset() {
        this.lastvalue = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(name=");
        sb.append(this.name);
        sb.append(", trace=");
        sb.append(this.getTraceMode());
        sb.append(")");
        return sb.toString();
    }
}

