/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.adapter.IAgentAdapter;
import jadex.model.IMCapability;
import jadex.model.IMCapabilityReference;
import jadex.model.IMConfigCapability;
import jadex.model.IMConfigCapabilitybase;
import jadex.model.IMConfiguration;
import jadex.model.IMElement;
import jadex.model.ISystemEventTypes;
import jadex.model.SXML;
import jadex.runtime.IContentCodec;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IFilter;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.SystemEvent;
import jadex.runtime.externalaccesswrapper.ExternalAccess;
import jadex.runtime.impl.IInterpreterCondition;
import jadex.runtime.impl.IRBeliefSet;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRParameterSet;
import jadex.runtime.impl.IRReferenceableElement;
import jadex.runtime.impl.InterpreterCondition;
import jadex.runtime.impl.RBDIAgent;
import jadex.runtime.impl.RBeliefbase;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RElementReference;
import jadex.runtime.impl.REventbase;
import jadex.runtime.impl.RExpression;
import jadex.runtime.impl.RExpressionbase;
import jadex.runtime.impl.RGoalbase;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RPlanbase;
import jadex.runtime.impl.RPropertybase;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.agenda.IAgendaAction;
import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.runtime.impl.agenda.agent.CleanupAgentAction;
import jadex.runtime.impl.agenda.eventprocessing.ProcessEventAction;
import jadex.util.SReflect;
import jadex.util.collection.IndexMap;
import jadex.util.collection.SCollection;
import jadex.util.concurrent.ThreadPoolFactory;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RCapability
extends RElement {
    public static int INIT_LEVELS;
    protected IMConfiguration state;
    protected RBDIAgent agent;
    protected RBeliefbase beliefbase;
    protected RGoalbase goalbase;
    protected RPlanbase planbase;
    protected RExpressionbase expressionbase;
    protected REventbase eventbase;
    protected RPropertybase propertybase;
    protected ExternalAccess extaccess;
    protected IndexMap children;
    protected transient Logger logger;
    protected IndexMap listenerinfos;
    protected InterpreterCondition killcond;
    protected int nested;
    protected HashSet changeevents = SCollection.createHashSet();
    protected Set infoevents = SCollection.createLinkedHashSet();
    protected transient Map counters;
    protected transient Map active;
    protected Map serialized_counters;
    protected Map serialized_active;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RCapability(String name, IMCapability capability, String statename, RElement owner, Map exparams) {
        super(name, capability, owner, exparams);
        if (!$assertionsDisabled && capability == null) {
            throw new AssertionError((Object)name);
        }
        if (capability.isAbstract()) {
            throw new RuntimeException("Abstract capability " + capability + " can't be instantiated (problem in platform properties).");
        }
        this.state = statename == null || statename.length() == 0 ? capability.getConfigurationbase().getDefaultConfiguration() : capability.getConfigurationbase().getConfiguration(statename);
        this.children = SCollection.createIndexMap();
        this.listenerinfos = SCollection.createIndexMap();
        RCapability tmp = this;
        while (tmp.getParent() != null) {
            tmp = tmp.getParent();
        }
        this.agent = (RBDIAgent)tmp;
        this.setExpressionParameter("$agent", this.getAgent());
        this.agent.addCapabilityMapping(capability, this);
        IMCapabilityReference[] subcaps = capability.getCapabilityReferences();
        for (int i = 0; i < subcaps.length; ++i) {
            IMConfigCapability inicap = this.getConfiguration() == null ? null : this.getConfiguration().getInitialCapability(subcaps[i]);
            this.children.add(subcaps[i].getName(), (Object)new RCapability(subcaps[i].getName(), subcaps[i].getCapability(), inicap != null ? inicap.getConfiguration() : null, this, null));
        }
        this.beliefbase = new RBeliefbase(capability.getBeliefbase(), (RElement)this);
        this.goalbase = new RGoalbase(capability.getGoalbase(), (RElement)this);
        this.planbase = new RPlanbase(capability.getPlanbase(), (RElement)this);
        this.eventbase = new REventbase(capability.getEventbase(), (RElement)this);
        this.expressionbase = new RExpressionbase(capability.getExpressionbase(), (RElement)this);
        this.propertybase = new RPropertybase(capability.getPropertybase(), (RElement)this);
        this.setExpressionParameter("$scope", this);
        this.setExpressionParameter("$beliefbase", this.beliefbase);
        this.setExpressionParameter("$goalbase", this.goalbase);
        this.setExpressionParameter("$planbase", this.planbase);
        this.setExpressionParameter("$expressionbase", this.expressionbase);
        this.setExpressionParameter("$eventbase", this.eventbase);
        this.setExpressionParameter("$propertybase", this.propertybase);
        this.propertybase.constructorInit();
    }

    protected void init(int level) {
        RCapability[] caps = this.getChildren();
        for (int i = 0; i < caps.length; ++i) {
            caps[i].init(level);
        }
        this.beliefbase.init(level);
        this.goalbase.init(level);
        this.planbase.init(level);
        this.eventbase.init(level);
        this.expressionbase.init(level);
        this.propertybase.init(level);
    }

    protected IMConfiguration getConfiguration() {
        return this.state;
    }

    public IExternalAccess getExternalAccess() {
        if (this.extaccess == null) {
            this.extaccess = new ExternalAccess(this);
        }
        return this.extaccess;
    }

    public String getDetailName() {
        return this.getParent() == null ? this.getName() : this.getParent().getDetailName() + "." + this.getName();
    }

    public RBeliefbase getBeliefbase() {
        return this.beliefbase;
    }

    public RPlanbase getPlanbase() {
        return this.planbase;
    }

    public RGoalbase getGoalbase() {
        return this.goalbase;
    }

    public RExpressionbase getExpressionbase() {
        return this.expressionbase;
    }

    public REventbase getEventbase() {
        return this.eventbase;
    }

    public RPropertybase getPropertybase() {
        return this.propertybase;
    }

    public void addSubcapability(String name, String capafile) {
        try {
            IMCapability mcap = SXML.loadCapabilityModel(capafile, ((IMCapability)this.getModelElement()).getFullImports(), this.getModelElement());
            RCapability capa = new RCapability(name, mcap, null, this, null);
            this.addChild(capa);
            for (int i = 0; i < INIT_LEVELS; ++i) {
                capa.init(i);
            }
        }
        catch (Exception e) {
            System.out.println("Could not dynamically add subcapability: " + capafile);
            e.printStackTrace();
        }
    }

    public void removeSubcapability(String name) {
        this.removeChild(this.getChild(name));
    }

    public void registerSubcapability(IMCapabilityReference subcap) {
        IMConfigCapabilitybase initialbase = this.getScope().getConfiguration() != null ? this.getScope().getConfiguration().getCapabilitybase() : null;
        IMConfigCapability inicap = initialbase != null ? initialbase.getInitialCapability(subcap) : null;
        RCapability capa = new RCapability(subcap.getName(), subcap.getCapability(), inicap != null ? inicap.getConfiguration() : null, this, null);
        this.addChild(capa);
        for (int i = 0; i < INIT_LEVELS; ++i) {
            capa.init(i);
        }
    }

    public void deregisterSubcapability(IMCapabilityReference subcap) {
        this.removeChild(this.getChild(subcap.getName()));
    }

    protected RCapability getParent() {
        return (RCapability)this.getOwner();
    }

    protected int getNestingLevel() {
        int ret = 0;
        RCapability cap = this;
        while (cap != null) {
            if ((cap = cap.getParent()) == null) continue;
            ++ret;
        }
        return ret;
    }

    public RBDIAgent getAgent() {
        if (!$assertionsDisabled && this.agent == null) {
            throw new AssertionError();
        }
        return this.agent;
    }

    public Object getPlatformAgent() {
        return this.agent.getAgentAdapter();
    }

    public Logger getLogger() {
        block8: {
            if (this.logger == null) {
                String name = this.getAgentAdapter().getAgentIdentifier().getName();
                try {
                    Object consolelevel;
                    Boolean useParentHandlers;
                    this.logger = Logger.getLogger(name);
                    Object level = this.getPropertybase().getProperty("logging.level");
                    if (level != null) {
                        this.logger.setLevel(Level.parse(level.toString()));
                    }
                    if ((useParentHandlers = (Boolean)this.getPropertybase().getProperty("logging.useParentHandlers")) != null) {
                        this.logger.setUseParentHandlers(useParentHandlers);
                    }
                    if ((consolelevel = this.getPropertybase().getProperty("logging.addConsoleHandler")) != null) {
                        ConsoleHandler console = new ConsoleHandler();
                        console.setLevel(Level.parse(consolelevel.toString()));
                        this.logger.addHandler(console);
                    }
                }
                catch (SecurityException e) {
                    Object consolelevel;
                    Boolean useParentHandlers;
                    this.logger = Logger.getAnonymousLogger();
                    Object level = this.getPropertybase().getProperty("logging.level");
                    if (level != null) {
                        this.logger.setLevel(Level.parse(level.toString()));
                    }
                    if ((useParentHandlers = (Boolean)this.getPropertybase().getProperty("logging.useParentHandlers")) != null) {
                        this.logger.setUseParentHandlers(useParentHandlers);
                    }
                    if ((consolelevel = this.getPropertybase().getProperty("logging.addConsoleHandler")) == null) break block8;
                    ConsoleHandler console = new ConsoleHandler();
                    console.setLevel(Level.parse(consolelevel.toString()));
                    this.logger.addHandler(console);
                }
            }
        }
        return this.logger;
    }

    protected void addChild(RCapability child) {
        this.children.add(child.getName(), (Object)child);
        this.throwSystemEvent(new SystemEvent("BDI_capabilityAdded", child));
    }

    protected void removeChild(RCapability child) {
        this.children.removeKey(child.getName());
        child.cleanup();
        this.throwSystemEvent(new SystemEvent("BDI_capabilityRemoved", child));
    }

    public RCapability[] getChildren() {
        return (RCapability[])this.children.getObjects(RCapability.class);
    }

    protected RCapability getChild(String name) {
        return (RCapability)this.children.get(name);
    }

    public void dispatchEvent(IREvent event, IAgendaActionPrecondition precond) {
        event.dispatched();
        this.agent.getInterpreter().addAgendaEntry(new ProcessEventAction(precond, this.agent, event), null);
    }

    public String getAgentName() {
        return this.getAgent().getName();
    }

    public String getInitialStateName() {
        return this.state == null ? null : this.state.getName();
    }

    protected IAgentAdapter getAgentAdapter() {
        return this.getAgent().getAgentAdapter();
    }

    public void addSystemEventListener(ISystemEventListener listener, IFilter filter) {
        this.addSystemEventListener(listener, filter, true, false);
    }

    public void addSystemEventListener(ISystemEventListener listener, IFilter filter, boolean delayed, boolean async) {
        this.listenerinfos.add(listener, (Object)new ListenerInfo(filter, delayed, async));
    }

    public void removeSystemEventListener(ISystemEventListener listener) {
        this.listenerinfos.removeKey(listener);
    }

    public ISystemEventListener[] getSystemEventListeners() {
        return this.listenerinfos.keySet().toArray(new ISystemEventListener[this.listenerinfos.size()]);
    }

    public List getAgentState(String[] types) {
        return this.getAgent().getState(types);
    }

    public List getState(String[] types) {
        ArrayList ret = SCollection.createArrayList();
        ret.addAll(this.beliefbase.getState(types));
        ret.addAll(this.goalbase.getState(types));
        ret.addAll(this.planbase.getState(types));
        RCapability[] subcaps = this.getChildren();
        for (int i = 0; i < subcaps.length; ++i) {
            if (ISystemEventTypes.Subtypes.isSubtype("BDI_capabilityAdded", types)) {
                ret.add(new SystemEvent("BDI_capabilityAdded", subcaps[i]));
            }
            ret.addAll(subcaps[i].getState(types));
        }
        return ret;
    }

    protected Map createLocalExpressionParameters() {
        return SCollection.createHashMap();
    }

    public Map getExpressionParameters() {
        return this.exparams;
    }

    public RCapability getCapability(String name) {
        RCapability cap = this.getAgent();
        if (name != null) {
            StringTokenizer stok = new StringTokenizer(name, ".");
            stok.nextToken();
            while (stok.hasMoreTokens()) {
                if ((cap = cap.getChild(stok.nextToken())) != null) continue;
                throw new RuntimeException("No such capability: " + name);
            }
        }
        return cap;
    }

    public RCapability[] getSubCapabilities() {
        return this.getChildren();
    }

    public void exitRunningState() {
        this.planbase.exitRunningState();
        this.goalbase.exitRunningState();
        this.beliefbase.exitRunningState();
        this.eventbase.exitRunningState();
        this.expressionbase.exitRunningState();
        this.propertybase.exitRunningState();
        RCapability[] subcaps = this.getChildren();
        for (int i = 0; i < subcaps.length; ++i) {
            subcaps[i].exitRunningState();
        }
    }

    public void activateEndState() {
        this.planbase.activateEndState();
        this.goalbase.activateEndState();
        this.beliefbase.activateEndState();
        this.eventbase.activateEndState();
        this.expressionbase.activateEndState();
        this.propertybase.activateEndState();
        RCapability[] subcaps = this.getChildren();
        for (int i = 0; i < subcaps.length; ++i) {
            subcaps[i].activateEndState();
        }
        this.killcond = new InterpreterCondition(new CleanupAgentAction(this.getAgent(), new IAgendaActionPrecondition(){

            public boolean check() {
                return "terminating".equals(RCapability.this.getAgent().getLifecycleState());
            }
        }), this){

            public boolean isAffected(SystemEvent event) {
                return true;
            }

            public boolean isTriggered() {
                boolean triggered = RCapability.this.getAgent().isEndStateTerminated();
                if (triggered && "once".equals(this.getTraceMode())) {
                    this.trace = "never";
                    this.getScope().getExpressionbase().removeCondition(this);
                }
                return triggered;
            }
        };
        this.killcond.traceOnce();
    }

    public boolean isEndStateTerminated() {
        boolean terminated;
        boolean bl = terminated = this.planbase.isEndStateTerminated() && this.goalbase.isEndStateTerminated() && this.beliefbase.isEndStateTerminated() && this.eventbase.isEndStateTerminated() && this.expressionbase.isEndStateTerminated() && this.propertybase.isEndStateTerminated();
        if (terminated) {
            RCapability[] subcaps = this.getChildren();
            for (int i = 0; terminated && i < subcaps.length; ++i) {
                terminated = terminated && subcaps[i].isEndStateTerminated();
            }
        }
        return terminated;
    }

    public void cleanup() {
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        if (this.killcond != null) {
            this.killcond.cleanup();
        }
        this.planbase.cleanup();
        this.goalbase.cleanup();
        this.beliefbase.cleanup();
        this.eventbase.cleanup();
        this.expressionbase.cleanup();
        this.propertybase.cleanup();
        RCapability[] subcaps = this.getChildren();
        for (int i = 0; i < subcaps.length; ++i) {
            subcaps[i].cleanup();
        }
        this.agent.removeCapabilityMapping(this);
        this.throwSystemEvent(new SystemEvent("BDI_capabilityRemoved", this));
    }

    public IContentCodec getContentCodec(Properties props) {
        IContentCodec ret = null;
        String[] codecnames = this.getPropertybase().getPropertyNames("contentcodec.");
        for (int i = 0; ret == null && i < codecnames.length; ++i) {
            IContentCodec tmp = (IContentCodec)this.getPropertybase().getProperty(codecnames[i]);
            if (!tmp.match(props)) continue;
            ret = tmp;
        }
        return ret;
    }

    public void throwSystemEvent(SystemEvent event) {
        boolean change = event.isChangeRelevant();
        if (!change && this.listenerinfos.isEmpty()) {
            return;
        }
        if (this.agent.isTransactionStarted() && !change) {
            this.addInfoEvent(event);
        } else {
            this.agent.startSystemEventTransaction();
            this.collectSystemEvents(event);
            this.agent.commitSystemEventTransaction();
        }
    }

    protected void collectSystemEvents(SystemEvent event) {
        if (!$assertionsDisabled && !this.agent.isTransactionStarted()) {
            throw new AssertionError();
        }
        if (!this.infoevents.add(event)) {
            return;
        }
        RPlan pl = this.agent.getCurrentPlan();
        if (pl != null) {
            event.setCause(pl.getName());
        }
        if (event.isChangeRelevant()) {
            this.changeevents.add(event);
            RExpression[] exps = this.expressionbase.getExpressions().toArray(new RExpression[0]);
            for (int i = 0; i < exps.length; ++i) {
                RExpression exp = exps[i];
                SystemEvent causedevent = exp.getSystemEvent(event);
                if (causedevent == null) continue;
                if (causedevent.getSource() instanceof RReferenceableElement) {
                    RReferenceableElement source = (RReferenceableElement)causedevent.getSource();
                    if (source instanceof RElementReference) {
                        while (source instanceof RElementReference) {
                            source = source.getOriginalElement();
                        }
                    }
                    source.createSystemEvents(causedevent);
                    continue;
                }
                this.collectSystemEvents(causedevent);
            }
        }
    }

    public void addInfoEvent(SystemEvent event) {
        if (!($assertionsDisabled || this.agent.isTransactionStarted() && !event.isChangeRelevant())) {
            throw new AssertionError(event);
        }
        if (this.infoevents.contains(event)) {
            return;
        }
        RPlan pl = this.agent.getCurrentPlan();
        if (pl != null) {
            event.setCause(pl.getName());
        }
        this.infoevents.add(event);
    }

    public void notifySystemEventListeners() {
        ArrayList tonotify = SCollection.createArrayList();
        for (int i = 0; i < this.listenerinfos.size(); ++i) {
            final ISystemEventListener listener = (ISystemEventListener)this.listenerinfos.getKey(i);
            ListenerInfo li = (ListenerInfo)this.listenerinfos.get(listener);
            IFilter filter = li.getFilter();
            boolean delayed = li.isDelayed();
            boolean async = li.isAsync();
            SystemEvent[] ses = this.infoevents.toArray(new SystemEvent[this.infoevents.size()]);
            final ArrayList matched = SCollection.createArrayList();
            for (int e = 0; e < ses.length; ++e) {
                IRReferenceableElement set;
                if (!this.getAgent().applyFilter(filter, ses[e])) continue;
                matched.add(ses[e]);
                if (ses[e].getType().equals("BDI_esValuesChanged")) {
                    try {
                        set = (IRParameterSet)ses[e].getSource();
                        ses[e].setValue(Arrays.asList(set.getValues()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                if (!ses[e].getType().equals("BDI_bsfactsChanged")) continue;
                try {
                    set = (IRBeliefSet)ses[e].getSource();
                    ses[e].setValue(Arrays.asList(set.getFacts()));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (matched.size() <= 0) continue;
            if (!delayed) {
                if (async) {
                    ThreadPoolFactory.getThreadPool().execute(new Runnable(){

                        public void run() {
                            listener.systemEventsOccurred(matched.toArray(new SystemEvent[matched.size()]));
                        }
                    });
                    continue;
                }
                listener.systemEventsOccurred(matched.toArray(new SystemEvent[matched.size()]));
                continue;
            }
            tonotify.add(new Object[]{listener, matched.toArray(new SystemEvent[matched.size()])});
        }
        if (tonotify.size() > 0) {
            final Object[] todo = tonotify.toArray();
            this.getAgent().getInterpreter().addAgendaEntry(new IAgendaAction(){

                public void execute() {
                    for (int i = 0; i < todo.length; ++i) {
                        Object[] tmp = (Object[])todo[i];
                        ISystemEventListener listener = (ISystemEventListener)tmp[0];
                        SystemEvent[] events = (SystemEvent[])tmp[1];
                        ListenerInfo li = (ListenerInfo)RCapability.this.listenerinfos.get(listener);
                        if (li == null) continue;
                        boolean async = li.isAsync();
                        if (async) {
                            ThreadPoolFactory.getThreadPool().execute(new Runnable(this, listener, events){
                                private final /* synthetic */ ISystemEventListener val$listener;
                                private final /* synthetic */ SystemEvent[] val$events;
                                private final /* synthetic */ 4 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$listener = val$listener;
                                    this.val$events = val$events;
                                }

                                public void run() {
                                    try {
                                        this.val$listener.systemEventsOccurred(this.val$events);
                                    }
                                    catch (RuntimeException e) {
                                        StringWriter sw = new StringWriter();
                                        e.printStackTrace(new PrintWriter(sw));
                                        Level level = (Level)4.access$000(this.this$1).getPropertybase().getProperty("logging.level.exceptions");
                                        4.access$000(this.this$1).getLogger().log(level, 4.access$000(this.this$1).getAgent().getName() + ": Exception while executing: " + this.val$listener + "\n" + sw);
                                    }
                                }
                            });
                            continue;
                        }
                        try {
                            listener.systemEventsOccurred(events);
                            continue;
                        }
                        catch (RuntimeException e) {
                            StringWriter sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            Level level = (Level)RCapability.this.getPropertybase().getProperty("logging.level.exceptions");
                            RCapability.this.getLogger().log(level, RCapability.this.getAgent().getName() + ": Exception while executing: " + tmp[0] + "\n" + sw);
                        }
                    }
                }

                public boolean isValid() {
                    return true;
                }

                static /* synthetic */ RCapability access$000(4 x0) {
                    return x0.RCapability.this;
                }
            }, null);
        }
        this.infoevents.clear();
    }

    protected void executeConditions() {
        if (!this.changeevents.isEmpty()) {
            Collection sconds = this.expressionbase.getConditions();
            IInterpreterCondition[] conds = sconds.toArray(new IInterpreterCondition[0]);
            for (int i = 0; i < conds.length; ++i) {
                conds[i].systemEventsOccurred(this.changeevents.iterator());
            }
            this.changeevents.clear();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(name=");
        sb.append(this.name);
        sb.append(")");
        return sb.toString();
    }

    protected int instanceCount(Object element) {
        if (this.counters == null) {
            this.counters = SCollection.createWeakHashMap();
        }
        int count = 0;
        Integer icount = (Integer)this.counters.get(element);
        if (icount != null) {
            count = icount;
        }
        this.counters.put(element, new Integer(++count));
        return count;
    }

    protected void incActive(IMElement element) {
        if (this.active == null) {
            this.active = SCollection.createWeakHashMap();
        }
        int count = 0;
        Integer icount = (Integer)this.active.get(element);
        if (icount != null) {
            count = icount;
        }
        this.active.put(element, new Integer(++count));
    }

    protected void decActive(IMElement element) {
        if (this.active == null) {
            this.active = SCollection.createWeakHashMap();
        }
        int count = 0;
        Integer icount = (Integer)this.active.get(element);
        if (icount != null) {
            count = icount;
            --count;
        }
        this.active.put(element, new Integer(count));
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.counters != null) {
            this.serialized_counters = SCollection.createHashMap();
            this.serialized_counters.putAll(this.counters);
        }
        if (this.active != null) {
            this.serialized_active = SCollection.createHashMap();
            this.serialized_active.putAll(this.active);
        }
        return super.writeReplace();
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.serialized_counters != null) {
            this.counters = SCollection.createWeakHashMap();
            this.counters.putAll(this.serialized_counters);
            this.serialized_counters = null;
        }
        if (this.serialized_active != null) {
            this.active = SCollection.createWeakHashMap();
            this.active.putAll(this.serialized_active);
            this.serialized_active = null;
        }
        return super.readResolve();
    }

    static {
        $assertionsDisabled = !RCapability.class.desiredAssertionStatus();
        INIT_LEVELS = 2;
    }

    protected static class ListenerInfo {
        protected IFilter filter;
        protected boolean delayed;
        protected boolean async;

        public ListenerInfo(IFilter filter, boolean delayed, boolean async) {
            this.filter = filter;
            this.delayed = delayed;
            this.async = async;
        }

        public boolean isAsync() {
            return this.async;
        }

        public boolean isDelayed() {
            return this.delayed;
        }

        public IFilter getFilter() {
            return this.filter;
        }
    }
}

