/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMBase;
import jadex.model.IMBelief;
import jadex.model.IMBeliefReference;
import jadex.model.IMBeliefSet;
import jadex.model.IMBeliefSetReference;
import jadex.model.IMBeliefbase;
import jadex.model.IMConfigBelief;
import jadex.model.IMConfigBeliefSet;
import jadex.model.IMConfigBeliefbase;
import jadex.model.IMReferenceableElement;
import jadex.model.ISystemEventTypes;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRBelief;
import jadex.runtime.impl.IRBeliefSet;
import jadex.runtime.impl.IRElement;
import jadex.runtime.impl.RBase;
import jadex.runtime.impl.RBelief;
import jadex.runtime.impl.RBeliefReference;
import jadex.runtime.impl.RBeliefSet;
import jadex.runtime.impl.RBeliefSetReference;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RReferenceableElement;
import jadex.util.SReflect;
import jadex.util.collection.IndexMap;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.List;

public class RBeliefbase
extends RBase {
    protected IndexMap beliefs = SCollection.createIndexMap();
    protected IndexMap beliefsets = SCollection.createIndexMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RBeliefbase(IMBeliefbase beliefbase, RElement owner) {
        super(null, beliefbase, owner);
    }

    protected void init(int level) {
        block7: {
            int i;
            block6: {
                if (level != 0) break block6;
                IMBeliefbase model = (IMBeliefbase)this.getModelElement();
                IMConfigBeliefbase initialbase = this.getScope().getConfiguration() != null ? this.getScope().getConfiguration().getBeliefbase() : null;
                IMBelief[] bels = model.getBeliefs();
                for (int i2 = 0; i2 < bels.length; ++i2) {
                    if (this.containsBelief(bels[i2].getName())) continue;
                    this.createBelief(bels[i2], initialbase != null ? initialbase.getInitialBelief(bels[i2]) : null, null);
                }
                IMBeliefSet[] belsets = model.getBeliefSets();
                for (int i3 = 0; i3 < belsets.length; ++i3) {
                    if (this.containsBeliefSet(belsets[i3].getName())) continue;
                    this.createBeliefSet(belsets[i3], initialbase != null ? initialbase.getInitialBeliefSet(belsets[i3]) : null, null);
                }
                IMBeliefbase beliefbase = (IMBeliefbase)this.getModelElement();
                IMBeliefReference[] belrefs = beliefbase.getBeliefReferences();
                for (int i4 = 0; i4 < belrefs.length; ++i4) {
                    if (this.containsBelief(belrefs[i4].getName())) continue;
                    this.createBelief(belrefs[i4], initialbase != null ? initialbase.getInitialBelief(belrefs[i4]) : null, null);
                }
                IMBeliefSetReference[] belsetrefs = beliefbase.getBeliefSetReferences();
                for (int i5 = 0; i5 < belsetrefs.length; ++i5) {
                    if (this.containsBeliefSet(belsetrefs[i5].getName())) continue;
                    this.createBeliefSet(belsetrefs[i5], initialbase != null ? initialbase.getInitialBeliefSet(belsetrefs[i5]) : null, null);
                }
                break block7;
            }
            if (level != 1) break block7;
            for (i = 0; i < this.beliefs.size(); ++i) {
                if (!(this.beliefs.get(i) instanceof RBelief)) continue;
                RBelief bel = (RBelief)this.beliefs.get(i);
                bel.initStructure();
            }
            for (i = 0; i < this.beliefsets.size(); ++i) {
                if (!(this.beliefsets.get(i) instanceof RBeliefSet)) continue;
                RBeliefSet belset = (RBeliefSet)this.beliefsets.get(i);
                belset.initStructure();
            }
        }
    }

    public IRBelief getBelief(String name) {
        if (this.containsBelief(name)) {
            return (IRBelief)this.beliefs.get(name);
        }
        throw new RuntimeException("No such belief: " + name + " in " + this);
    }

    public IRBeliefSet getBeliefSet(String name) {
        if (this.containsBeliefSet(name)) {
            return (IRBeliefSet)this.beliefsets.get(name);
        }
        throw new RuntimeException("No such belief set: " + name + " in " + this);
    }

    public boolean containsBelief(String name) {
        return this.beliefs.containsKey(name);
    }

    public boolean containsBeliefSet(String name) {
        return this.beliefsets.containsKey(name);
    }

    public String[] getBeliefNames() {
        return this.beliefs.keySet().toArray(new String[this.beliefs.size()]);
    }

    public String[] getBeliefSetNames() {
        return this.beliefsets.keySet().toArray(new String[this.beliefsets.size()]);
    }

    public void createBelief(String key, Class clazz, int update) {
        if (this.containsBelief(this.name) || this.containsBeliefSet(this.name)) {
            throw new RuntimeException("Belief " + this.name + " exlready exists in " + this);
        }
        IMBelief mbel = ((IMBeliefbase)this.getModelElement()).createBelief(key, clazz, update, "false");
        RBelief rbel = (RBelief)this.createBelief(mbel, null, null);
        rbel.initStructure();
    }

    public void createBeliefSet(String key, Class clazz, int update) {
        if (this.containsBelief(this.name) || this.containsBeliefSet(this.name)) {
            throw new RuntimeException("Belief set " + this.name + " exlready exists in " + this);
        }
        IMBeliefSet mbelset = ((IMBeliefbase)this.getModelElement()).createBeliefSet(key, clazz, update, "false");
        RBeliefSet rbelset = (RBeliefSet)this.createBeliefSet(mbelset, null, null);
        rbelset.initStructure();
    }

    public void deleteBelief(String key) {
        if (this.beliefs.containsKey(key)) {
            RReferenceableElement belief = (RReferenceableElement)this.beliefs.get(key);
            belief.throwSystemEvent("BDI_beliefRemoved");
            this.beliefs.removeKey(key);
            ((IMBase)this.getModelElement()).deleteReferenceableElement((IMReferenceableElement)belief.getModelElement());
            if (!belief.isCleanedup()) {
                belief.cleanup();
            }
        } else {
            throw new RuntimeException("No such belief: " + key + " in " + this);
        }
    }

    public void deleteBeliefSet(String key) {
        if (this.beliefsets.containsKey(key)) {
            RReferenceableElement beliefset = (RReferenceableElement)this.beliefsets.get(key);
            beliefset.throwSystemEvent("BDI_beliefRemoved");
            this.beliefsets.removeKey(key);
            ((IMBase)this.getModelElement()).deleteReferenceableElement((IMReferenceableElement)beliefset.getModelElement());
            if (!beliefset.isCleanedup()) {
                beliefset.cleanup();
            }
        } else {
            throw new RuntimeException("No such belief set: " + key + " in " + this);
        }
    }

    public void registerBelief(IMBelief mbelief) {
        IMConfigBeliefbase initialbase;
        IMConfigBeliefbase iMConfigBeliefbase = initialbase = this.getScope().getConfiguration() != null ? this.getScope().getConfiguration().getBeliefbase() : null;
        if (this.containsBelief(mbelief.getName()) || this.containsBeliefSet(mbelief.getName())) {
            throw new RuntimeException("Beliefbase already contains a belief(set) with name: " + mbelief.getName());
        }
        RBelief rbel = (RBelief)this.createBelief(mbelief, initialbase != null ? initialbase.getInitialBelief(mbelief) : null, null);
        rbel.initStructure();
    }

    public void registerBeliefSet(IMBeliefSet mbeliefset) {
        IMConfigBeliefbase initialbase;
        IMConfigBeliefbase iMConfigBeliefbase = initialbase = this.getScope().getConfiguration() != null ? this.getScope().getConfiguration().getBeliefbase() : null;
        if (this.containsBelief(mbeliefset.getName()) || this.containsBeliefSet(mbeliefset.getName())) {
            throw new RuntimeException("Beliefbase already contains a belief(set) with name: " + mbeliefset.getName());
        }
        RBeliefSet rbelset = (RBeliefSet)this.createBeliefSet(mbeliefset, initialbase != null ? initialbase.getInitialBeliefSet(mbeliefset) : null, null);
        rbelset.initStructure();
    }

    public void registerBeliefReference(IMBeliefReference mbeliefref) {
        IMConfigBeliefbase initialbase;
        IMConfigBeliefbase iMConfigBeliefbase = initialbase = this.getScope().getConfiguration() != null ? this.getScope().getConfiguration().getBeliefbase() : null;
        if (this.containsBelief(mbeliefref.getName()) || this.containsBeliefSet(mbeliefref.getName())) {
            throw new RuntimeException("Beliefbase already contains a belief(set) with name: " + mbeliefref.getName());
        }
        RBeliefReference rbel = (RBeliefReference)this.createBelief(mbeliefref, initialbase != null ? initialbase.getInitialBelief(mbeliefref) : null, null);
        rbel.initStructure();
    }

    public void registerBeliefSetReference(IMBeliefSetReference mbeliefsetref) {
        IMConfigBeliefbase initialbase;
        IMConfigBeliefbase iMConfigBeliefbase = initialbase = this.getScope().getConfiguration() != null ? this.getScope().getConfiguration().getBeliefbase() : null;
        if (this.containsBelief(mbeliefsetref.getName()) || this.containsBeliefSet(mbeliefsetref.getName())) {
            throw new RuntimeException("Beliefbase already contains a belief(set) with name: " + mbeliefsetref.getName());
        }
        RBeliefSetReference rbelset = (RBeliefSetReference)this.createBeliefSet(mbeliefsetref, initialbase != null ? initialbase.getInitialBeliefSet(mbeliefsetref) : null, null);
        rbelset.initStructure();
    }

    public void deregisterBelief(IMBelief mbelief) {
        if (mbelief == null) {
            throw new RuntimeException("Belief must not null.");
        }
        RReferenceableElement belief = (RReferenceableElement)this.beliefs.get(mbelief.getName());
        belief.throwSystemEvent("BDI_beliefRemoved");
        this.beliefs.removeKey(mbelief.getName());
        if (!belief.isCleanedup()) {
            belief.cleanup();
        }
    }

    public void deregisterBeliefSet(IMBeliefSet mbeliefset) {
        if (mbeliefset == null) {
            throw new RuntimeException("BeliefSet must not null.");
        }
        RReferenceableElement beliefset = (RReferenceableElement)this.beliefsets.get(mbeliefset.getName());
        beliefset.throwSystemEvent("BDI_beliefRemoved");
        this.beliefsets.removeKey(mbeliefset.getName());
        if (!beliefset.isCleanedup()) {
            beliefset.cleanup();
        }
    }

    public void deregisterBeliefReference(IMBeliefReference mbeliefref) {
        if (mbeliefref == null) {
            throw new RuntimeException("BeliefReference must not null.");
        }
        RReferenceableElement belief = (RReferenceableElement)this.beliefs.get(mbeliefref.getName());
        belief.throwSystemEvent("BDI_beliefRemoved");
        this.beliefs.removeKey(mbeliefref.getName());
        if (!belief.isCleanedup()) {
            belief.cleanup();
        }
    }

    public void deregisterBeliefSetReference(IMBeliefSetReference mbeliefsetref) {
        if (mbeliefsetref == null) {
            throw new RuntimeException("BeliefSetReference must not null.");
        }
        RReferenceableElement beliefset = (RReferenceableElement)this.beliefsets.get(mbeliefsetref.getName());
        beliefset.throwSystemEvent("BDI_beliefRemoved");
        this.beliefsets.removeKey(mbeliefsetref.getName());
        if (!beliefset.isCleanedup()) {
            beliefset.cleanup();
        }
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(name=");
        sb.append(this.name);
        sb.append("\nbeliefs=\n");
        for (i = 0; this.beliefs != null && i < this.beliefs.size(); ++i) {
            sb.append("  ");
            sb.append(((RElement)this.beliefs.get(i)).getName());
            sb.append("\n");
        }
        sb.append("\nbeliefsets=\n");
        for (i = 0; this.beliefsets != null && i < this.beliefsets.size(); ++i) {
            sb.append("  ");
            sb.append(((RElement)this.beliefsets.get(i)).getName());
            sb.append("\n");
        }
        sb.append(")");
        return sb.toString();
    }

    public List getState(String[] types) {
        IRElement bel;
        int i;
        ArrayList ret = SCollection.createArrayList();
        if (ISystemEventTypes.Subtypes.isSubtype("BDI_beliefAdded", types)) {
            for (i = 0; i < this.beliefs.size(); ++i) {
                Object value;
                bel = (IRBelief)this.beliefs.get(i);
                try {
                    value = bel.getFact();
                }
                catch (Exception e) {
                    value = "n/a";
                }
                ret.add(new SystemEvent("BDI_beliefAdded", bel, value));
            }
            for (i = 0; i < this.beliefsets.size(); ++i) {
                bel = (RElement)this.beliefsets.get(i);
                ret.add(new SystemEvent("BDI_beliefAdded", bel));
            }
        }
        if (ISystemEventTypes.Subtypes.isSubtype("BDI_bsfactAdded", types)) {
            for (i = 0; i < this.beliefsets.size(); ++i) {
                bel = (IRBeliefSet)this.beliefsets.get(i);
                try {
                    Object[] facts = bel.getFacts();
                    for (int j = 0; j < facts.length; ++j) {
                        ret.add(new SystemEvent("BDI_bsfactAdded", bel, facts[j], j));
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    protected RReferenceableElement getElementInstance(IMReferenceableElement melement, RReferenceableElement creator) {
        if (!$assertionsDisabled && melement == null) {
            throw new AssertionError();
        }
        RCapability scope = this.getScope().getAgent().lookupCapability(melement.getScope());
        if (!$assertionsDisabled && scope == null) {
            throw new AssertionError((Object)("Scope of " + melement.getName() + " nulls, defined in: " + melement.getScope()));
        }
        if (!$assertionsDisabled && scope.getBeliefbase() == null) {
            throw new AssertionError((Object)(scope.getName() + " " + this.getName() + " " + melement.getName()));
        }
        if (!scope.getBeliefbase().containsBelief(melement.getName()) && !scope.getBeliefbase().containsBeliefSet(melement.getName())) {
            IMConfigBeliefbase initialbase;
            IMConfigBeliefbase iMConfigBeliefbase = initialbase = scope.getConfiguration() != null ? scope.getConfiguration().getBeliefbase() : null;
            if (melement instanceof IMBelief) {
                scope.getBeliefbase().createBelief(melement, initialbase != null ? initialbase.getInitialBelief((IMBelief)melement) : null, creator);
            } else if (melement instanceof IMBeliefReference) {
                scope.getBeliefbase().createBelief(melement, initialbase != null ? initialbase.getInitialBelief((IMBeliefReference)melement) : null, creator);
            } else if (melement instanceof IMBeliefSet) {
                scope.getBeliefbase().createBeliefSet(melement, initialbase != null ? initialbase.getInitialBeliefSet((IMBeliefSet)melement) : null, creator);
            } else if (melement instanceof IMBeliefSetReference) {
                scope.getBeliefbase().createBeliefSet(melement, initialbase != null ? initialbase.getInitialBeliefSet((IMBeliefSetReference)melement) : null, creator);
            }
        }
        if (melement instanceof IMBelief || melement instanceof IMBeliefReference) {
            return (RReferenceableElement)((Object)scope.getBeliefbase().getBelief(melement.getName()));
        }
        if (melement instanceof IMBeliefSet || melement instanceof IMBeliefSetReference) {
            return (RReferenceableElement)((Object)scope.getBeliefbase().getBeliefSet(melement.getName()));
        }
        throw new RuntimeException("Cannot lookup element: " + melement);
    }

    protected RBase getCorrespondingBase(RCapability scope) {
        if (!$assertionsDisabled && scope == null) {
            throw new AssertionError(this);
        }
        return scope.getBeliefbase();
    }

    protected IRBelief createBelief(IMReferenceableElement belief, IMConfigBelief state, RReferenceableElement creator) {
        if (!$assertionsDisabled && belief == null) {
            throw new AssertionError((Object)(belief + " " + creator));
        }
        if (!($assertionsDisabled || belief instanceof IMBelief || belief instanceof IMBeliefReference)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && belief.getScope() != this.getScope().getModelElement()) {
            throw new AssertionError((Object)("error+ " + belief.getScope() + " " + this.getScope()));
        }
        if (!$assertionsDisabled && creator != null && !(creator instanceof IRBelief)) {
            throw new AssertionError(creator);
        }
        RReferenceableElement ret = null;
        ret = belief instanceof IMBelief ? new RBelief((IMBelief)belief, state, (RElement)this, creator) : new RBeliefReference((IMBeliefReference)belief, state, (RElement)this, creator);
        this.beliefs.add(belief.getName(), (Object)ret);
        return ret;
    }

    protected IRBeliefSet createBeliefSet(IMReferenceableElement beliefset, IMConfigBeliefSet state, RReferenceableElement creator) {
        if (!$assertionsDisabled && beliefset == null) {
            throw new AssertionError((Object)(beliefset + " " + creator));
        }
        if (!($assertionsDisabled || beliefset instanceof IMBeliefSet || beliefset instanceof IMBeliefSetReference)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && beliefset.getScope() != this.getScope().getModelElement()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && creator != null && !(creator instanceof IRBeliefSet)) {
            throw new AssertionError(creator);
        }
        RReferenceableElement ret = null;
        ret = beliefset instanceof IMBeliefSet ? new RBeliefSet((IMBeliefSet)beliefset, state, (RElement)this, creator) : new RBeliefSetReference((IMBeliefSetReference)beliefset, state, (RElement)this, creator);
        this.beliefsets.add(beliefset.getName(), (Object)ret);
        return ret;
    }

    public void cleanup() {
        int i;
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        for (i = 0; i < this.beliefs.size(); ++i) {
            ((RElement)this.beliefs.get(i)).cleanup();
        }
        for (i = 0; i < this.beliefsets.size(); ++i) {
            ((RElement)this.beliefsets.get(i)).cleanup();
        }
    }

    static {
        $assertionsDisabled = !RBeliefbase.class.desiredAssertionStatus();
    }
}

