/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMBeliefSet;
import jadex.model.IMCapability;
import jadex.model.IMConfigBeliefSet;
import jadex.model.IMExpression;
import jadex.model.IMExpressionReference;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRBeliefSet;
import jadex.runtime.impl.IRExpression;
import jadex.runtime.impl.RBeliefSetReference;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.RTypedElementSet;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public class RBeliefSet
extends RTypedElementSet
implements IRBeliefSet {
    protected RBeliefSet(IMBeliefSet belief, IMConfigBeliefSet state, RElement owner, RReferenceableElement creator) {
        super(belief.getName(), belief, state, owner, creator);
    }

    protected void init() {
        if (this.isInited()) {
            return;
        }
        this.throwSystemEvent("BDI_beliefAdded");
        super.init();
    }

    protected void setInitialValues() {
        boolean found = false;
        ArrayList occs = SCollection.createArrayList();
        occs.addAll(this.getAllOccurrences());
        occs.remove(this);
        Collections.sort(occs, new Comparator(){

            public int compare(Object o, Object o1) {
                return ((RReferenceableElement)o1).getScope().getNestingLevel() - ((RReferenceableElement)o).getScope().getNestingLevel();
            }
        });
        for (int i = 0; i < occs.size(); ++i) {
            RBeliefSetReference ref = (RBeliefSetReference)occs.get(i);
            if (ref.getInitialState() == null) continue;
            found = true;
            Object[] values = ref.getInitialFacts();
            for (int j = 0; values != null && j < values.length; ++j) {
                this.addValue(values[j]);
            }
            Object inivals = ref.getInitialFactsExpression();
            if (inivals instanceof IRExpression) {
                IMExpressionReference mref = ((IMCapability)this.getScope().getModelElement()).getExpressionbase().getExpressionReference("standard_expression_reference");
                inivals = this.getScope().getExpressionbase().createExpression(mref, (RReferenceableElement)inivals);
                this.setInitialValuesExpression((IRExpression)inivals);
                continue;
            }
            if (inivals == null) continue;
            Iterator ivalues = SReflect.getIterator(inivals);
            while (ivalues.hasNext()) {
                this.addValue(ivalues.next());
            }
        }
        if (!found) {
            IMExpression[] mvalues = null;
            IMExpression minivals = null;
            if (this.getInitialState() != null) {
                mvalues = ((IMConfigBeliefSet)this.getInitialState()).getInitialFacts();
                minivals = ((IMConfigBeliefSet)this.getInitialState()).getInitialFactsExpression();
            } else {
                mvalues = ((IMBeliefSet)this.getModelElement()).getDefaultFacts();
                minivals = ((IMBeliefSet)this.getModelElement()).getDefaultFactsExpression();
            }
            for (int i = 0; mvalues != null && i < mvalues.length; ++i) {
                this.addValue(this.getScope().getExpressionbase().evaluateInternalExpression(mvalues[i], this));
            }
            if (minivals != null) {
                if (minivals.getEvaluationMode().equals("static")) {
                    Iterator it = SReflect.getIterator(this.getScope().getExpressionbase().evaluateInternalExpression(minivals, this));
                    while (it.hasNext()) {
                        this.addValue(it.next());
                    }
                } else {
                    this.setInitialValuesExpression(this.getScope().getExpressionbase().createInternalExpression(minivals, this, this.createSystemEvent("BDI_bsfactsChanged", null, -1)));
                }
            }
        }
    }

    public void addFact(Object fact) {
        this.addValue(fact);
    }

    public void removeFact(Object fact) {
        this.removeValue(fact);
    }

    public void addFacts(Object[] values) {
        this.addValues(values);
    }

    public void removeFacts() {
        this.removeValues();
    }

    public Object getFact(Object oldval) {
        Object value = this.getValue(oldval);
        this.throwSystemEvent(new SystemEvent("BDI_bsfactRead", this, value, this.indexOf(oldval)));
        return value;
    }

    public boolean containsFact(Object fact) {
        this.throwSystemEvent(new SystemEvent("BDI_bsfactRead", this, fact, this.indexOf(fact)));
        return this.containsValue(fact);
    }

    public Object[] getFacts() {
        Object[] facts = this.getValues();
        this.throwSystemEvent(new SystemEvent("BDI_bsfactRead", this, facts));
        return facts;
    }

    public void updateFact(Object newfact) {
        this.updateValue(newfact);
    }

    public boolean isAccessible() {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(name=");
        sb.append(this.getName());
        sb.append(")");
        return sb.toString();
    }

    public Map getEncodableRepresentation() {
        Map rep = super.getEncodableRepresentation();
        rep.put("exported", ((IMBeliefSet)this.getModelElement()).getExported());
        return rep;
    }

    public SystemEvent createSystemEvent(String event, Object value, int index) {
        if (event.equals("BDI_esValueAdded")) {
            event = "BDI_bsfactAdded";
        } else if (event.equals("BDI_esValueRemoved")) {
            event = "BDI_bsfactRemoved";
        } else if (event.equals("BDI_esValueChanged")) {
            event = "BDI_bsfactChanged";
        } else if (event.equals("BDI_esValuesChanged")) {
            event = "BDI_bsfactsChanged";
        }
        return super.createSystemEvent(event, value, index);
    }

    public void throwSystemEvent(SystemEvent event) {
        RPlan plan = this.getScope().getAgent().getCurrentPlan();
        if (plan != null) {
            event.setCause(plan.name);
        }
        super.throwSystemEvent(event);
    }
}

