/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMBelief;
import jadex.model.IMBeliefReference;
import jadex.model.IMCapability;
import jadex.model.IMConfigBelief;
import jadex.model.IMExpression;
import jadex.model.IMExpressionReference;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRBelief;
import jadex.runtime.impl.IRExpression;
import jadex.runtime.impl.RBeliefReference;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.RTypedElement;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class RBelief
extends RTypedElement
implements IRBelief {
    protected RBelief(IMBelief belief, IMConfigBelief state, RElement owner, RReferenceableElement creator) {
        super(belief.getName(), belief, state, owner, creator);
    }

    protected void init() {
        if (!this.isInited()) {
            this.throwSystemEvent("BDI_beliefAdded");
            super.init();
        }
    }

    public void setInitialValue() {
        Map args;
        int i;
        boolean found = false;
        String argname = null;
        IMBelief mbel = (IMBelief)this.getModelElement();
        if (this.getScope() == this.getScope().getAgent() && mbel.getExported().equals("true")) {
            argname = mbel.getName();
        }
        ArrayList occs = SCollection.createArrayList();
        occs.addAll(this.getAllOccurrences());
        occs.remove(this);
        if (argname == null) {
            for (i = 0; i < occs.size(); ++i) {
                RBeliefReference tmp = (RBeliefReference)occs.get(i);
                if (!tmp.getScope().equals(this.getScope().getAgent()) || !((IMBeliefReference)tmp.getModelElement()).getExported().equals("true")) continue;
                argname = tmp.getName();
            }
        }
        if (argname != null && (args = this.getScope().getAgent().getArguments()) != null && args.containsKey(argname)) {
            this.setInitialValue(args.get(argname));
            found = true;
        }
        if (!found) {
            Collections.sort(occs, new Comparator(){

                public int compare(Object o, Object o1) {
                    return ((RReferenceableElement)o1).getScope().getNestingLevel() - ((RReferenceableElement)o).getScope().getNestingLevel();
                }
            });
            for (i = 0; i < occs.size(); ++i) {
                RBeliefReference ref = (RBeliefReference)occs.get(i);
                if (ref.getInitialState() == null) continue;
                found = true;
                Object fact = ref.getInitialFact();
                if (fact instanceof IRExpression) {
                    IMExpressionReference mref = ((IMCapability)this.getScope().getModelElement()).getExpressionbase().getExpressionReference("standard_expression_reference");
                    fact = this.getScope().getExpressionbase().createExpression(mref, (RReferenceableElement)fact);
                }
                this.setInitialValue(fact);
            }
        }
        if (!found) {
            IMExpression mvalue = null;
            mvalue = this.getInitialState() != null ? ((IMConfigBelief)this.getInitialState()).getInitialFact() : ((IMBelief)this.getModelElement()).getDefaultFact();
            if (mvalue != null) {
                if (mvalue.getEvaluationMode().equals("static")) {
                    this.setInitialValue(this.getScope().getExpressionbase().evaluateInternalExpression(mvalue, this));
                } else {
                    this.setInitialValue(this.getScope().getExpressionbase().createInternalExpression(mvalue, this, new SystemEvent("BDI_factChanged", this)));
                }
            }
        }
    }

    public void setFact(Object fact) {
        this.setValue(fact);
    }

    public Object getFact() {
        Object fact = this.getValue();
        this.throwSystemEvent(new SystemEvent("_BDI_factRead", this, fact));
        return fact;
    }

    public boolean isAccessible() {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(name=");
        sb.append(this.getName());
        sb.append(")");
        return sb.toString();
    }

    public Map getEncodableRepresentation() {
        Map rep = super.getEncodableRepresentation();
        rep.put("exported", ((IMBelief)this.getModelElement()).getExported());
        return rep;
    }

    public SystemEvent createSystemEvent(String event) {
        if ("BDI_valueChanged".equals(event)) {
            event = "BDI_factChanged";
        }
        return super.createSystemEvent(event);
    }

    public void throwSystemEvent(SystemEvent event) {
        RPlan plan = this.getScope().getAgent().getCurrentPlan();
        if (plan != null) {
            event.setCause(plan.name);
        }
        super.throwSystemEvent(event);
    }
}

