/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMBase;
import jadex.model.IMElementReference;
import jadex.model.IMReferenceableElement;
import jadex.runtime.impl.IRElement;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RElementReference;
import jadex.runtime.impl.RGoal;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RProcessGoal;
import jadex.runtime.impl.RReferenceableElement;
import java.util.HashMap;
import java.util.Map;

public abstract class RBase
extends RElement {
    protected Map assignments = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RBase(String name, IMBase base, RElement owner) {
        super(name, base, owner);
        IMReferenceableElement[] res = base.getReferenceableElements();
        for (int i = 0; res != null && i < res.length; ++i) {
            IMElementReference[] assignments = res[i].getAssignToElements();
            for (int j = 0; j < assignments.length; ++j) {
                RCapability scope = this.getScope().getAgent().lookupCapability(assignments[j].getScope());
                if (!$assertionsDisabled && scope == null) {
                    throw new AssertionError(this);
                }
                this.getCorrespondingBase(scope).setReferencedElement(assignments[j], res[i]);
            }
        }
    }

    protected void init(int level) {
    }

    protected abstract RReferenceableElement getElementInstance(IMReferenceableElement var1, RReferenceableElement var2);

    protected abstract RBase getCorrespondingBase(RCapability var1);

    protected RReferenceableElement getReferencedElement(RElementReference ref, RReferenceableElement creator) {
        IMElementReference mref = (IMElementReference)ref.getModelElement();
        IMReferenceableElement melement = mref.isAbstract() ? (IMReferenceableElement)this.assignments.get(mref) : mref.getReferencedElement();
        RReferenceableElement element = melement == null ? creator : (creator != null && melement == creator.getModelElement() ? creator : this.getElementInstance(melement, ref));
        return element;
    }

    protected void setReferencedElement(IMElementReference mref, IMReferenceableElement melement) {
        this.assignments.put(mref, melement);
    }

    public void exitRunningState() {
    }

    public void activateEndState() {
    }

    public boolean isEndStateTerminated() {
        return true;
    }

    public boolean isProtected(IRElement elem) {
        boolean ret = false;
        if (elem instanceof RPlan) {
            RPlan plan = (RPlan)elem;
            String state = plan.getState();
            ret = state.equals("aborted") || state.equals("passed") || state.equals("failed") || this.isProtected(plan.getRootGoal().getProprietaryGoal());
        } else if (elem instanceof IRGoal) {
            RGoal goal = (RGoal)((IRGoal)elem).getOriginalElement();
            ret = this.isProtected(goal.getRealParent());
        } else if (elem instanceof RProcessGoal) {
            ret = this.isProtected(((RProcessGoal)elem).getPlanInstance());
        }
        return ret;
    }

    static {
        $assertionsDisabled = !RBase.class.desiredAssertionStatus();
    }
}

