/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.adapter.IAgentAdapter;
import jadex.model.IMBDIAgent;
import jadex.model.IMCapability;
import jadex.model.ISystemEventTypes;
import jadex.runtime.BasicAgentIdentifier;
import jadex.runtime.IFilter;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.ICleanable;
import jadex.runtime.impl.JadexInterpreter;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.TimetableData;
import jadex.runtime.impl.agenda.agent.GarbageCollectionAction;
import jadex.util.SReflect;
import jadex.util.collection.IndexMap;
import jadex.util.collection.SCollection;
import jadex.util.collection.SortedList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RBDIAgent
extends RCapability {
    public static final String LIFECYCLESTATE_CREATING = "creating";
    public static final String LIFECYCLESTATE_ALIVE = "alive";
    public static final String LIFECYCLESTATE_TERMINATING = "terminating";
    public static final String LIFECYCLESTATE_TERMINATED = "terminated";
    protected IAgentAdapter adapter;
    protected JadexInterpreter interpreter;
    protected List timetable;
    protected IndexMap capamap;
    protected RPlan currentplan;
    protected String lifecyclestate;
    protected Map arguments;
    protected boolean transaction_running;
    protected boolean atomic;
    protected Set cleanables;
    protected boolean garbagecollection;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RBDIAgent(IAgentAdapter adapter, IMBDIAgent agent, String config, Map arguments, JadexInterpreter interpreter) {
        super(adapter.getAgentIdentifier().getLocalName(), agent, config, null, null);
        this.adapter = adapter;
        this.arguments = arguments;
        this.interpreter = interpreter;
        this.lifecyclestate = LIFECYCLESTATE_CREATING;
        this.timetable = new SortedList();
        this.cleanables = SCollection.createHashSet();
        if (arguments != null) {
            agent.checkArguments(arguments);
        }
    }

    public void init(int level) {
        super.init(level);
    }

    public void cleanup() {
        if (this.cleanedup) {
            return;
        }
        this.throwSystemEvent(new SystemEvent("agentDied", this));
        super.cleanup();
    }

    public String getLifecycleState() {
        return this.lifecyclestate;
    }

    public void setLifecycleState(String lifecyclestate) {
        this.lifecyclestate = lifecyclestate;
    }

    public void addTimetableEntry(TimetableData entry) {
        Object first = null;
        if (this.timetable.size() > 0) {
            first = this.timetable.get(0);
        }
        this.timetable.add(entry);
        if (first == null || first != this.timetable.get(0)) {
            this.adapter.notifyIn(entry.getDuration());
        }
    }

    public boolean removeTimetableEntry(TimetableData entry) {
        if (this.timetable.size() > 0 && this.timetable.get(0) == entry) {
            if (this.timetable.size() > 1) {
                this.adapter.notifyIn(((TimetableData)this.timetable.get(0)).getDuration());
            } else {
                this.adapter.notifyIn(-1L);
            }
        }
        return this.timetable.remove(entry);
    }

    public List getTimetable() {
        return this.timetable;
    }

    public List getState(String[] types) {
        ArrayList ret = SCollection.createArrayList();
        if (ISystemEventTypes.Subtypes.isSubtype("agentBorn", types)) {
            ret.add(new SystemEvent("agentBorn", this));
        }
        ret.addAll(this.interpreter.getState(types));
        ret.addAll(super.getState(types));
        return ret;
    }

    public IAgentAdapter getAgentAdapter() {
        return this.adapter;
    }

    public String getPlatformType() {
        return this.getAgentAdapter().getPlatformType();
    }

    public BasicAgentIdentifier getAgentIdentifier() {
        return this.getAgentAdapter().getAgentIdentifier();
    }

    protected void addCapabilityMapping(IMCapability mcap, RCapability rcap) {
        if (this.capamap == null) {
            this.capamap = SCollection.createIndexMap();
        }
        this.capamap.add(mcap, (Object)rcap);
    }

    protected void removeCapabilityMapping(RCapability rcap) {
        this.capamap.removeKey(rcap.getModelElement());
    }

    public RCapability lookupCapability(IMCapability mcap) {
        return (RCapability)this.capamap.get(mcap);
    }

    public List getAllCapabilities() {
        return this.capamap.getAsList();
    }

    public RPlan getCurrentPlan() {
        RPlan plan = this.currentplan;
        if (plan != null && plan.getThread() == Thread.currentThread()) {
            return plan;
        }
        return null;
    }

    protected void setCurrentPlan(RPlan currentplan) {
        this.currentplan = currentplan;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(name=");
        sb.append(this.name);
        sb.append(")");
        return sb.toString();
    }

    public boolean applyFilter(IFilter filter, Object object) {
        boolean ret = false;
        if (filter != null) {
            try {
                ret = filter.filter(object);
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this.getLogger().warning("Filter threw exception (filter, object): " + filter + ", " + object + "\n" + sw);
            }
        }
        return ret;
    }

    protected void startSystemEventTransaction() {
        if (!$assertionsDisabled && this.transaction_running) {
            throw new AssertionError();
        }
        this.transaction_running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitSystemEventTransaction() {
        if (!$assertionsDisabled && !this.transaction_running) {
            throw new AssertionError();
        }
        try {
            if (!this.atomic) {
                this.processTransactionConsequences();
            }
        }
        finally {
            this.transaction_running = false;
        }
    }

    protected boolean isTransactionStarted() {
        return this.transaction_running;
    }

    public void startAtomic() {
        if (!$assertionsDisabled && this.atomic) {
            throw new AssertionError((Object)"Is already atomic.");
        }
        this.atomic = true;
    }

    public void endAtomic() {
        if (!$assertionsDisabled && !this.atomic) {
            throw new AssertionError();
        }
        this.atomic = false;
        this.startSystemEventTransaction();
        this.commitSystemEventTransaction();
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    protected void processTransactionConsequences() {
        int i;
        if (this.children.isEmpty()) {
            this.executeConditions();
            this.notifySystemEventListeners();
            return;
        }
        List capas = this.getAllCapabilities();
        for (i = 0; i < capas.size(); ++i) {
            ((RCapability)capas.get(i)).executeConditions();
        }
        for (i = 0; i < capas.size(); ++i) {
            ((RCapability)capas.get(i)).notifySystemEventListeners();
        }
    }

    protected Map getArguments() {
        return this.arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleGarbageCollection(ICleanable element) {
        Set set = this.cleanables;
        synchronized (set) {
            if (this.cleanables.add(element)) {
                if (!this.garbagecollection) {
                    this.addTimetableEntry(new TimetableData(500L, new GarbageCollectionAction(this)));
                    this.garbagecollection = true;
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Garbage collection scheduled twice for element: " + element));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performGarbageCollection() {
        if (!$assertionsDisabled && !this.garbagecollection) {
            throw new AssertionError();
        }
        Set set = this.cleanables;
        synchronized (set) {
            Iterator it = this.cleanables.iterator();
            while (it.hasNext()) {
                ((ICleanable)it.next()).cleanup();
            }
            this.cleanables.clear();
            this.garbagecollection = false;
        }
    }

    public JadexInterpreter getInterpreter() {
        return this.interpreter;
    }

    static {
        $assertionsDisabled = !RBDIAgent.class.desiredAssertionStatus();
    }
}

