/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMAchieveGoal;
import jadex.model.IMCondition;
import jadex.model.IMConfigGoal;
import jadex.runtime.impl.RCondition;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RGoal;
import jadex.runtime.impl.RProcessGoal;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.TimetableData;
import jadex.runtime.impl.agenda.IAgendaAction;
import jadex.runtime.impl.agenda.IAgendaActionPrecondition;
import jadex.runtime.impl.agenda.easydeliberation.DeactivateInhibitedGoalsAction;
import jadex.runtime.impl.agenda.easydeliberation.DeliberateInhibitedGoalsReactivationAction;
import jadex.runtime.impl.agenda.goals.GoalFinishedAction;
import jadex.runtime.impl.agenda.goals.GoalProcessingStatePrecondition;
import jadex.runtime.impl.agenda.goals.RetryAction;
import jadex.util.SReflect;
import jadex.util.collection.MultiCollection;
import java.util.List;
import java.util.Map;

public class RAchieveGoal
extends RGoal {
    public static final String ACHIEVE_STATE_START = "start";
    public static final String ACHIEVE_STATE_PROCESSING_PAUSED = "processing_paused";
    public static final String ACHIEVE_STATE_UNKNOWN = "unknown";
    public static final String ACHIEVE_STATE_SUCCEEDED = "succeeded";
    public static final String ACHIEVE_STATE_FAILED = "failed";
    public static final String ACHIEVE_STATE_IN_PROCESS = "in_process";
    protected static final MultiCollection proc_transitions;
    protected RCondition target;
    protected RCondition failure;
    protected String processingstate;
    public IAgendaAction retryaction = new RetryAction(this, (IAgendaActionPrecondition)new GoalProcessingStatePrecondition(this, "processing_paused"));
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RAchieveGoal(String name, IMAchieveGoal goal, IMConfigGoal state, RElement owner, RReferenceableElement creator, Map binding) {
        super(name, goal, state, owner, creator, binding);
        this.setProcessingState(ACHIEVE_STATE_START);
        this.setTargetCondition(goal.getTargetCondition());
        this.setFailureCondition(goal.getFailureCondition());
    }

    public void cleanup() {
        if (this.cleanedup) {
            return;
        }
        super.cleanup();
        if (this.target != null) {
            this.target.cleanup();
        }
        if (this.failure != null) {
            this.failure.cleanup();
        }
    }

    public RCondition getTargetCondition() {
        return this.target;
    }

    public void setTargetCondition(IMCondition mtarget) {
        if (this.target != null) {
            this.target.cleanup();
        }
        if (mtarget != null) {
            this.target = this.getScope().getExpressionbase().createInternalCondition(mtarget, this, new GoalFinishedAction(this, this.prec_notfinished, ACHIEVE_STATE_SUCCEEDED), null);
            if (this.isAdopted()) {
                this.target.traceOnce();
            }
        }
        this.throwSystemEvent("BDI_goalChanged");
    }

    public RCondition getFailureCondition() {
        return this.failure;
    }

    public void setFailureCondition(IMCondition mfail) {
        if (this.failure != null) {
            this.failure.cleanup();
        }
        if (mfail != null) {
            this.failure = this.getScope().getExpressionbase().createInternalCondition(mfail, this, new GoalFinishedAction(this, this.prec_notfinished, ACHIEVE_STATE_FAILED), null);
            if (this.isAdopted()) {
                this.failure.traceOnce();
            }
        }
        this.throwSystemEvent("BDI_goalChanged");
    }

    public boolean isSucceeded() {
        return ACHIEVE_STATE_SUCCEEDED.equals(this.processingstate);
    }

    public boolean isInProcess() {
        return this.isActive() && ACHIEVE_STATE_IN_PROCESS.equals(this.processingstate);
    }

    public void processGoalsCreated(List hists) {
        super.processGoalsCreated(hists);
        if (hists.size() == 0) {
            if (this.isRecur()) {
                if (!ACHIEVE_STATE_PROCESSING_PAUSED.equals(this.getProcessingState())) {
                    this.changeProcessingState(ACHIEVE_STATE_PROCESSING_PAUSED);
                }
                this.scheduleRecur();
            } else {
                this.changeProcessingState(ACHIEVE_STATE_FAILED);
                this.drop();
            }
        } else {
            this.changeProcessingState(ACHIEVE_STATE_IN_PROCESS);
        }
    }

    protected void processGoalFinished(RProcessGoal procgoal) {
        super.processGoalFinished(procgoal);
        if (this.isFinished() || ACHIEVE_STATE_START.equals(this.processingstate)) {
            return;
        }
        if (!$assertionsDisabled && !this.isActive()) {
            throw new AssertionError(this);
        }
        String procstate = procgoal.getProcessingState();
        if (!(this.isPostToAll() || !this.isRetry() || this.getTargetCondition() == null && ACHIEVE_STATE_SUCCEEDED.equals(procstate))) {
            if (this.getRetryDelay() > 0L) {
                this.changeProcessingState(ACHIEVE_STATE_PROCESSING_PAUSED);
                this.setRetryEntry(new TimetableData(this.getRetryDelay(), this.retryaction));
                this.getScope().getAgent().addTimetableEntry(this.getRetryEntry());
            } else {
                this.throwProcessEvent();
            }
        } else if (this.isProcessingFinished() || ACHIEVE_STATE_SUCCEEDED.equals(procstate)) {
            if (!ACHIEVE_STATE_SUCCEEDED.equals(procstate) && this.isRecur()) {
                this.changeProcessingState(ACHIEVE_STATE_PROCESSING_PAUSED);
                this.scheduleRecur();
            } else {
                String newstate = null;
                if (this.getTargetCondition() != null) {
                    newstate = ACHIEVE_STATE_FAILED;
                } else if (ACHIEVE_STATE_SUCCEEDED.equals(procstate)) {
                    newstate = ACHIEVE_STATE_SUCCEEDED;
                } else {
                    if (!($assertionsDisabled || ACHIEVE_STATE_FAILED.equals(procstate) || "aborted_on_failure".equals(procstate))) {
                        throw new AssertionError(this);
                    }
                    newstate = ACHIEVE_STATE_FAILED;
                }
                this.getScope().getAgent().getInterpreter().addAgendaEntry(new GoalFinishedAction(this, new GoalProcessingStatePrecondition(this, ACHIEVE_STATE_IN_PROCESS), newstate), this);
            }
        }
    }

    public boolean isFinished() {
        return ACHIEVE_STATE_SUCCEEDED.equals(this.processingstate) || ACHIEVE_STATE_UNKNOWN.equals(this.processingstate) || ACHIEVE_STATE_FAILED.equals(this.processingstate);
    }

    public String getProcessingState() {
        if (!$assertionsDisabled && this.processingstate == null) {
            throw new AssertionError();
        }
        return this.processingstate;
    }

    protected void setProcessingState(String processingstate) {
        this.processingstate = processingstate;
        this.throwSystemEvent("BDI_goalChanged");
    }

    public void changeProcessingState(String newstate) {
        if (!$assertionsDisabled && !proc_transitions.getCollection(this.getProcessingState()).contains(newstate)) {
            throw new AssertionError((Object)("Cannot change processing state from " + this.getProcessingState() + " to " + newstate + ": " + this.getName()));
        }
        if (newstate.equals(this.getProcessingState())) {
            return;
        }
        String oldstate = this.getProcessingState();
        this.setProcessingState(newstate);
        if (oldstate.equals(ACHIEVE_STATE_IN_PROCESS)) {
            this.getScope().getAgent().getInterpreter().addAgendaEntry(new DeliberateInhibitedGoalsReactivationAction(new GoalProcessingStatePrecondition(this, ACHIEVE_STATE_IN_PROCESS, true), this), this);
        } else if (newstate.equals(ACHIEVE_STATE_IN_PROCESS)) {
            this.getScope().getAgent().getInterpreter().addAgendaEntry(new DeactivateInhibitedGoalsAction(new GoalProcessingStatePrecondition(this, ACHIEVE_STATE_IN_PROCESS), this), this);
        }
    }

    protected void enterAdoptedState() {
        super.enterAdoptedState();
        if (this.isAdopted()) {
            if (this.target != null) {
                if (this.target.isTriggered()) {
                    this.setProcessingState(ACHIEVE_STATE_SUCCEEDED);
                    this.drop();
                } else {
                    this.target.setTraceMode("once");
                }
            }
            if (this.isAdopted() && this.failure != null) {
                if (this.failure.isTriggered()) {
                    this.setProcessingState(ACHIEVE_STATE_FAILED);
                    this.drop();
                } else {
                    this.failure.setTraceMode("once");
                }
            }
        }
    }

    protected void exitAdoptedState() {
        if (this.target != null) {
            this.target.setTraceMode("never");
        }
        if (this.failure != null) {
            this.failure.setTraceMode("never");
        }
        if (!this.isFinished()) {
            this.setProcessingState(ACHIEVE_STATE_UNKNOWN);
        }
        super.exitAdoptedState();
    }

    protected void enterActiveState() {
        this.throwProcessEvent();
        super.enterActiveState();
    }

    protected void exitActiveState() {
        if (ACHIEVE_STATE_IN_PROCESS.equals(this.processingstate) || ACHIEVE_STATE_PROCESSING_PAUSED.equals(this.processingstate)) {
            this.setProcessingState(ACHIEVE_STATE_START);
        }
        super.exitActiveState();
    }

    public Map getEncodableRepresentation() {
        Map representation = super.getEncodableRepresentation();
        representation.put("processingstate", this.processingstate.equals(ACHIEVE_STATE_START) ? "" : this.processingstate);
        representation.put("targetcondition", this.target == null ? "" : ((IMCondition)this.target.getModelElement()).getExpressionText());
        representation.put("failurecondition", this.failure == null ? "" : ((IMCondition)this.failure.getModelElement()).getExpressionText());
        return representation;
    }

    protected String toString(int level) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buf.append("  ");
        }
        buf.append(SReflect.getInnerClassName(this.getClass()));
        buf.append("(name=");
        buf.append(this.getName());
        buf.append(", type=");
        buf.append(this.getType());
        buf.append(", state=");
        buf.append(this.processingstate);
        buf.append(")");
        return buf.toString();
    }

    static {
        $assertionsDisabled = !RAchieveGoal.class.desiredAssertionStatus();
        proc_transitions = new MultiCollection();
        proc_transitions.put(ACHIEVE_STATE_START, ACHIEVE_STATE_IN_PROCESS);
        proc_transitions.put(ACHIEVE_STATE_START, ACHIEVE_STATE_SUCCEEDED);
        proc_transitions.put(ACHIEVE_STATE_START, ACHIEVE_STATE_FAILED);
        proc_transitions.put(ACHIEVE_STATE_START, ACHIEVE_STATE_PROCESSING_PAUSED);
        proc_transitions.put(ACHIEVE_STATE_IN_PROCESS, ACHIEVE_STATE_IN_PROCESS);
        proc_transitions.put(ACHIEVE_STATE_IN_PROCESS, ACHIEVE_STATE_PROCESSING_PAUSED);
        proc_transitions.put(ACHIEVE_STATE_IN_PROCESS, ACHIEVE_STATE_SUCCEEDED);
        proc_transitions.put(ACHIEVE_STATE_IN_PROCESS, ACHIEVE_STATE_UNKNOWN);
        proc_transitions.put(ACHIEVE_STATE_IN_PROCESS, ACHIEVE_STATE_FAILED);
        proc_transitions.put(ACHIEVE_STATE_PROCESSING_PAUSED, ACHIEVE_STATE_IN_PROCESS);
        proc_transitions.put(ACHIEVE_STATE_PROCESSING_PAUSED, ACHIEVE_STATE_SUCCEEDED);
        proc_transitions.put(ACHIEVE_STATE_PROCESSING_PAUSED, ACHIEVE_STATE_FAILED);
    }
}

