/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMConfigPlan;
import jadex.model.IMPlan;
import jadex.runtime.impl.CandidateInfo;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.IRGoalEvent;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RProcessGoal;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.util.HashMap;
import java.util.Map;

public class PlanInfo
extends CandidateInfo {
    protected IMPlan plan;
    protected IMConfigPlan state;
    protected Map binding;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PlanInfo(IMConfigPlan state, IREvent event, IMPlan plan, Map binding) {
        super(event, null);
        this.state = state;
        this.plan = plan;
        this.binding = binding;
    }

    public RPlan getPlanInstance() {
        if (this.rplan == null) {
            RCapability scope = this.revent.getScope();
            IMPlan plan = this.getPlanModel();
            Map bd = this.getBinding();
            bd = bd != null ? new HashMap(bd) : SCollection.createHashMap();
            bd.put("$event", this.revent);
            IRGoal propgoal = null;
            if (this.revent instanceof IRGoalEvent && !((IRGoalEvent)this.revent).isInfo()) {
                propgoal = ((IRGoalEvent)this.revent).getGoal();
            }
            RProcessGoal processgoal = null;
            try {
                processgoal = scope.getGoalbase().createProcessGoal(propgoal, this);
            }
            catch (Exception e) {
                processgoal = scope.getGoalbase().createProcessGoal(propgoal, this);
                e.printStackTrace();
            }
            this.rplan = scope.getPlanbase().createPlan(this.state != null ? this.state.getName() : null, plan, this.getInitialState(), bd, processgoal, this.revent);
            processgoal.setPlanInstance(this.rplan);
            if (!$assertionsDisabled && this.rplan == null) {
                throw new AssertionError();
            }
        }
        return this.rplan;
    }

    public IMPlan getPlanModel() {
        return this.plan;
    }

    public Map getBinding() {
        return this.binding;
    }

    public Map getEncodableRepresentation() {
        Map representation = super.getEncodableRepresentation();
        representation.put("name", "MPlanCandidate_" + this.plan.getName());
        representation.put("plan", this.plan.getName());
        representation.put("binding", "" + this.binding);
        return representation;
    }

    protected void setEvent(IREvent event) {
        this.revent = event;
    }

    protected IMConfigPlan getInitialState() {
        return this.state;
    }

    public boolean equals(Object object) {
        return object instanceof PlanInfo && this.plan.equals(((PlanInfo)object).getPlanModel()) && (this.binding == null && ((PlanInfo)object).getBinding() == null || ((Object)this.binding).equals(((PlanInfo)object).getBinding()));
    }

    public int hashCode() {
        int code = 0;
        if (this.plan != null) {
            code ^= this.plan.hashCode();
        }
        if (this.binding != null) {
            code ^= ((Object)this.binding).hashCode();
        }
        return code;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(plan=");
        sb.append(this.plan.getName());
        sb.append(", binding=");
        sb.append(this.binding);
        sb.append(")");
        return sb.toString();
    }

    static {
        $assertionsDisabled = !PlanInfo.class.desiredAssertionStatus();
    }
}

