/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.adapter.IAgentAdapter;
import jadex.adapter.IJadexAgent;
import jadex.adapter.IMessageAdapter;
import jadex.model.IMBDIAgent;
import jadex.model.IMCapability;
import jadex.model.ISystemEventTypes;
import jadex.runtime.AgentDeathException;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IEncodable;
import jadex.runtime.impl.RBDIAgent;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.agenda.IAgenda;
import jadex.runtime.impl.agenda.IAgendaAction;
import jadex.runtime.impl.agenda.IAgendaEntry;
import jadex.runtime.impl.agenda.agent.InvokeLaterAction;
import jadex.runtime.impl.agenda.agent.MessageArrivalAction;
import jadex.runtime.impl.agenda.agent.NotifyDueAction;
import jadex.runtime.impl.agenda.agent.StartAgentAction;
import jadex.runtime.impl.agenda.agent.TerminateAgentAction;
import jadex.runtime.impl.agenda.treeimpl.TreeAgenda;
import jadex.runtime.impl.agenda.treeimpl.TreeAgendaEntry;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class JadexInterpreter
implements IJadexAgent,
IEncodable,
Serializable {
    public static final String EXECUTION_MODE_NORMAL = "normal";
    public static final String EXECUTION_MODE_STEP = "step";
    public static final String EXECUTION_MODE_CYCLE = "cycle";
    public static final String EXECUTION_MODE_SLOW = "slow";
    public static final String DEBUGGING = "debugging";
    protected RBDIAgent agent;
    protected IAgentAdapter adapter;
    protected IAgenda agenda;
    protected transient Thread agentthread;
    protected String mode;
    protected int stepcnt;
    public boolean agent_executing;
    public boolean plan_executing1;
    public boolean plan_executing2;
    protected SystemEvent event_agenda_changed = new SystemEvent("steppable_agenda_changed", this);
    static final /* synthetic */ boolean $assertionsDisabled;

    public JadexInterpreter(IAgentAdapter adapter, IMBDIAgent agent, String config, Map arguments) {
        this.agent = new RBDIAgent(adapter, agent, config, arguments, this);
        this.agenda = new TreeAgenda(this.agent);
        Boolean debug = (Boolean)this.agent.getPropertybase().getProperty(DEBUGGING);
        if (debug != null && debug.booleanValue()) {
            this.mode = EXECUTION_MODE_CYCLE;
            this.stepcnt = 0;
        } else {
            this.mode = EXECUTION_MODE_NORMAL;
            this.stepcnt = -1;
        }
        this.agenda.add(new StartAgentAction(this.agent, null), null);
    }

    public synchronized boolean executeAction() {
        if (!$assertionsDisabled && this.agent_executing) {
            throw new AssertionError(this);
        }
        if (!$assertionsDisabled && this.plan_executing1) {
            throw new AssertionError(this);
        }
        if (!$assertionsDisabled && this.plan_executing2) {
            throw new AssertionError(this);
        }
        this.agent_executing = true;
        boolean executed = false;
        if (this.stepcnt != 0) {
            this.agentthread = Thread.currentThread();
            IAgendaEntry entry = this.agenda.executeAction();
            if (entry != null) {
                this.stepDone(entry);
                executed = true;
            }
            this.agentthread = null;
        }
        if (!$assertionsDisabled && !this.agent_executing) {
            throw new AssertionError(this);
        }
        if (!$assertionsDisabled && this.plan_executing1) {
            throw new AssertionError(this);
        }
        if (!$assertionsDisabled && this.plan_executing2) {
            throw new AssertionError(this);
        }
        this.agent_executing = false;
        return executed && !"terminated".equals(this.agent.getLifecycleState());
    }

    public void notifyDue() {
        if (this.agent.isCleanedup()) {
            return;
        }
        if (!$assertionsDisabled && this.agent.getLifecycleState().equals("terminated")) {
            throw new AssertionError(this.agent);
        }
        if (!$assertionsDisabled && this.agent.isCleanedup()) {
            throw new AssertionError(this.agent);
        }
        this.agenda.addExternal(new NotifyDueAction(this.agent, null));
    }

    public void messageArrived(IMessageAdapter message) {
        this.agenda.addExternal(new MessageArrivalAction(this.agent, null, message));
    }

    public void killAgent() {
        if (this.isAgentThread() || this.isPlanThread()) {
            this.agenda.add(new TerminateAgentAction(this.agent), null);
        } else {
            this.agenda.addExternal(new TerminateAgentAction(this.agent));
        }
    }

    public Logger getLogger() {
        return this.agent.getLogger();
    }

    public synchronized Object getProperty(String name) {
        if (!$assertionsDisabled && this.agent.isCleanedup()) {
            throw new AssertionError(this.agent);
        }
        Object val = this.agent.getPropertybase().getProperty(name);
        if (val == null) {
            ArrayList cs = SCollection.createArrayList();
            cs.add(this.agent.getChildren());
            for (int i = 0; val == null && i < cs.size(); ++i) {
                RCapability[] children = (RCapability[])cs.get(i);
                for (int j = 0; val == null && j < children.length; ++j) {
                    val = children[j].getPropertybase().getProperty(name);
                    if (val != null) continue;
                    cs.add(children[j].getChildren());
                }
            }
        }
        return val;
    }

    public synchronized String[] getPropertyNames(String name) {
        if (!$assertionsDisabled && this.agent.isCleanedup()) {
            throw new AssertionError(this);
        }
        ArrayList ret = SCollection.createArrayList();
        String[] names = this.agent.getPropertybase().getPropertyNames(name);
        for (int i = 0; i < names.length; ++i) {
            ret.add(names[i]);
        }
        ArrayList cs = SCollection.createArrayList();
        cs.add(this.agent.getChildren());
        for (int i = 0; i < cs.size(); ++i) {
            RCapability[] children = (RCapability[])cs.get(i);
            for (int j = 0; j < children.length; ++j) {
                names = children[j].getPropertybase().getPropertyNames(name);
                for (int k = 0; k < names.length; ++k) {
                    if (ret.contains(names[k])) continue;
                    ret.add(names[k]);
                }
                cs.add(children[j].getChildren());
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public RCapability lookupCapability(IMCapability mcap) {
        return this.agent.lookupCapability(mcap);
    }

    protected Thread getAgentThread() {
        return this.agentthread;
    }

    public synchronized void invokeSynchronized(Runnable code) {
        if ("terminated".equals(this.agent.getLifecycleState()) || this.agent.isCleanedup()) {
            throw new AgentDeathException(this.agent);
        }
        code.run();
    }

    public void invokeLater(Runnable code) {
        this.agenda.addExternal(new InvokeLaterAction(this.agent, null, code));
    }

    public boolean isAgentThread() {
        return this.agentthread == Thread.currentThread();
    }

    public boolean isPlanThread() {
        RPlan rp = this.agent.getCurrentPlan();
        Thread pt = rp != null ? rp.getThread() : null;
        return Thread.currentThread() == pt;
    }

    public boolean isExternalThread() {
        return !this.isAgentThread() && !this.isPlanThread();
    }

    public void addAgendaEntry(IAgendaAction action, Object cause) {
        this.agenda.add(action, cause);
        this.agent.throwSystemEvent(this.event_agenda_changed);
    }

    public IAgendaEntry getCurrentAgendaEntry() {
        return this.agenda.getCurrentEntry();
    }

    public int getAgendaState() {
        return this.agenda.getState();
    }

    public void setExecutionMode(String mode) {
        if (!mode.equals(this.mode)) {
            this.mode = mode;
            if (mode.equals(EXECUTION_MODE_NORMAL)) {
                this.stepcnt = -1;
                this.agent.getAgentAdapter().wakeup();
            } else {
                this.stepcnt = 0;
            }
            this.agent.throwSystemEvent(new SystemEvent("steppable_agenda_mode_changed", this));
        }
    }

    public String getExecutionMode() {
        return this.mode;
    }

    public void setSteps(int steps) {
        if (!this.mode.equals(EXECUTION_MODE_NORMAL)) {
            this.stepcnt = steps;
            this.agent.throwSystemEvent(new SystemEvent("steppable_agenda_steps_changed", this));
            if (this.stepcnt > 0) {
                this.agent.getAgentAdapter().wakeup();
            }
        }
    }

    protected void stepDone(IAgendaEntry ae) {
        if (!this.mode.equals(EXECUTION_MODE_NORMAL) && this.stepcnt > 0) {
            --this.stepcnt;
        }
        SystemEvent event_step_done = new SystemEvent("steppable_agenda_step_done", this);
        event_step_done.setValue(ae);
        this.agent.throwSystemEvent(event_step_done);
    }

    public List getState(String[] types) {
        ArrayList ret = SCollection.createArrayList();
        if (ISystemEventTypes.Subtypes.isSubtype("steppable_", types)) {
            ret.add(new SystemEvent("steppable_", this));
        }
        return ret;
    }

    public Map getEncodableRepresentation() {
        HashMap rep = SCollection.createHashMap();
        rep.put("isencodeablepresentation", "true");
        rep.put("mode", this.mode);
        rep.put("steps", "" + this.stepcnt);
        List entries = this.agenda.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            rep.put("" + i, ((TreeAgendaEntry)entries.get(i)).getEncodableRepresentation());
        }
        rep.put("num", new Integer(entries.size()));
        return rep;
    }

    static {
        $assertionsDisabled = !JadexInterpreter.class.desiredAssertionStatus();
    }
}

