/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IInterpreterCondition;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.agenda.IAgendaAction;
import jadex.util.SReflect;
import java.io.Serializable;
import java.util.Iterator;

public abstract class InterpreterCondition
implements IInterpreterCondition,
Serializable {
    protected String trace;
    protected RCapability scope;
    protected boolean disabled;
    protected IAgendaAction action;

    protected InterpreterCondition(IAgendaAction action, RCapability scope) {
        this.scope = scope;
        this.action = action;
        this.trace = "never";
    }

    public void cleanup() {
        this.setTraceMode("never");
    }

    public String getTraceMode() {
        return this.trace;
    }

    public void setTraceMode(String trace) {
        if (!trace.equals(this.trace)) {
            if (trace.equals("never")) {
                this.scope.getExpressionbase().removeCondition(this);
                this.disabled = true;
            } else if (trace.equals("once") || trace.equals("always")) {
                this.scope.getExpressionbase().addCondition(this);
            } else {
                throw new RuntimeException("Unknown trace mode: " + trace);
            }
            this.trace = trace;
        }
    }

    public void traceOnce() {
        this.setTraceMode("once");
        this.doTrace(null);
    }

    public void traceAlways() {
        this.setTraceMode("always");
        this.doTrace(null);
    }

    public void systemEventsOccurred(Iterator events) {
        if (this.trace.equals("never")) {
            return;
        }
        boolean affected = false;
        int i = 0;
        while (!affected && events.hasNext()) {
            SystemEvent syse = (SystemEvent)events.next();
            if (this.isAffected(syse)) {
                affected = true;
                this.doTrace(syse);
            }
            ++i;
        }
    }

    protected void doTrace(SystemEvent cause) {
        if (this.isTriggered()) {
            if (this.action == null) {
                throw new RuntimeException("Error, condition has no action: " + this);
            }
            this.scope.getAgent().getInterpreter().addAgendaEntry(this.action, cause);
        }
    }

    public void setAction(IAgendaAction action) {
        this.action = action;
    }

    public IAgendaAction getAction() {
        return this.action;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public RCapability getScope() {
        return this.scope;
    }

    protected void throwSystemEvent(String event) {
        this.throwSystemEvent(new SystemEvent(event, this));
    }

    public void throwSystemEvent(SystemEvent event) {
        if (this.getScope().getAgent().isTransactionStarted() && !event.isChangeRelevant()) {
            this.getScope().addInfoEvent(event);
        } else {
            this.getScope().getAgent().startSystemEventTransaction();
            this.getScope().collectSystemEvents(event);
            this.getScope().getAgent().commitSystemEventTransaction();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append(", trace=");
        sb.append(this.getTraceMode());
        sb.append(")");
        return sb.toString();
    }

    public abstract boolean isAffected(SystemEvent var1);

    public abstract boolean isTriggered();
}

