/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMPlan;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.PlanInfo;
import jadex.runtime.impl.PlanInstanceInfo;
import jadex.runtime.impl.WaitqueueInfo;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DefaultMetaLevelReasoner
implements Serializable {
    protected static DefaultMetaLevelReasoner instance;

    public static DefaultMetaLevelReasoner getInstance() {
        if (instance == null) {
            instance = new DefaultMetaLevelReasoner();
        }
        return instance;
    }

    public List reason(IREvent event, List candidatelist) {
        ArrayList selected = SCollection.createArrayList();
        int numcandidates = 1;
        if (event.isPostToAll()) {
            numcandidates = Integer.MAX_VALUE;
        }
        for (int i = 0; i < numcandidates && candidatelist.size() > 0; ++i) {
            selected.add(this.getNextCandidate(candidatelist, event.isRandomSelection()));
        }
        return selected;
    }

    protected Object getNextCandidate(List candidatelist, boolean random) {
        Object cand;
        ArrayList finals = SCollection.createArrayList();
        finals.add(candidatelist.get(0));
        int candprio = this.getPriority(finals.get(0));
        for (int i = 1; i < candidatelist.size(); ++i) {
            Object tmp = candidatelist.get(i);
            int tmpprio = this.getPriority(tmp);
            if (tmpprio > candprio || tmpprio == candprio && this.getRank(tmp) > this.getRank(finals.get(0))) {
                finals.clear();
                finals.add(tmp);
                candprio = tmpprio;
                continue;
            }
            if (tmpprio != candprio || this.getRank(tmp) != this.getRank(finals.get(0))) continue;
            finals.add(tmp);
        }
        if (random) {
            int rand = (int)(Math.random() * (double)finals.size());
            cand = finals.get(rand);
        } else {
            cand = finals.get(0);
        }
        candidatelist.remove(cand);
        return cand;
    }

    protected int getPriority(Object cand) {
        int prio = cand instanceof PlanInstanceInfo ? ((IMPlan)((PlanInstanceInfo)cand).getPlanInstance().getModelElement()).getPriority() : (cand instanceof PlanInfo ? ((PlanInfo)cand).getPlanModel().getPriority() : ((IMPlan)((WaitqueueInfo)cand).getPlanInstance().getModelElement()).getPriority());
        return prio;
    }

    protected int getRank(Object cand) {
        int rank = cand instanceof PlanInfo ? 0 : (cand instanceof WaitqueueInfo ? 1 : 2);
        return rank;
    }
}

