/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMParameter;
import jadex.model.IMParameterElement;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRGoalEvent;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RElement;
import jadex.runtime.impl.RExpression;
import jadex.util.SUtil;
import jadex.util.collection.IndexMap;
import jadex.util.collection.SCollection;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BindingHelper
implements Serializable {
    protected IMParameterElement binding_owner;
    protected IndexMap binding_exps;
    protected RCapability scope;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected BindingHelper(IMParameterElement binding_owner, RElement owner, boolean trace) {
        if (!$assertionsDisabled && binding_owner == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && owner == null) {
            throw new AssertionError();
        }
        this.binding_owner = binding_owner;
        this.binding_exps = SCollection.createIndexMap();
        IMParameter[] mbindings = binding_owner.getBindingParameters();
        this.scope = owner.getScope();
        Object se = null;
        for (int i = 0; i < mbindings.length; ++i) {
            this.binding_exps.add(mbindings[i].getName(), (Object)this.scope.getExpressionbase().createInternalExpression(mbindings[i].getBindingOptions(), owner, trace ? new SystemEvent("BDI_bindingChanged", mbindings[i]) : null));
        }
    }

    public void cleanup() {
        for (int i = 0; i < this.binding_exps.size(); ++i) {
            ((RExpression)this.binding_exps.get(i)).cleanup();
        }
    }

    protected List calculateBindings(IREvent event, String[] names, Object[] values) {
        HashMap params = SCollection.createHashMap();
        params.put("$event", event);
        if (event instanceof IRGoalEvent) {
            params.put("$goal", ((IRGoalEvent)event).getGoal());
        }
        ArrayList ret = SCollection.createArrayList();
        IMParameter[] mbindings = this.binding_owner.getBindingParameters();
        IndexMap binds = SCollection.createIndexMap();
        for (int i = 0; names != null && i < names.length; ++i) {
            binds.put(names[i], values[i]);
        }
        HashMap binding = SCollection.createHashMap();
        for (int i = 0; i < mbindings.length; ++i) {
            try {
                if (binds.containsKey(mbindings[i].getName())) continue;
                binds.put(mbindings[i].getName(), ((RExpression)this.binding_exps.get(mbindings[i].getName())).getValue(params));
                continue;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                System.out.println("Bindings could not be evaluated: " + this.binding_exps.get(mbindings[i].getName()) + "\n" + sw);
                return ret;
            }
        }
        return SUtil.calculateCartesianProduct((String[])binds.getKeys(String.class), binds.values().toArray(new Object[binds.size()]));
    }

    public static void main(String[] args) {
        String[] names = new String[]{"a", "b", "c"};
        Object[] values = new Object[]{new int[]{1, 2}, new int[]{3, 4}, new int[]{5, 6}};
        List ret = SUtil.calculateCartesianProduct(names, values);
        System.out.println(ret);
    }

    static {
        $assertionsDisabled = !BindingHelper.class.desiredAssertionStatus();
    }
}

