/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.ISystemEventTypes;
import jadex.runtime.IFilter;
import jadex.runtime.InternalEventFilter;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRBeliefSet;
import jadex.runtime.impl.InterpreterCondition;
import jadex.runtime.impl.agenda.IAgendaAction;
import jadex.runtime.impl.agenda.conditions.ConditionDefaultAction2;
import jadex.util.SUtil;

public class BeliefSetChangeCondition
extends InterpreterCondition {
    protected IRBeliefSet beliefset;
    protected String[] eventtypes;
    protected boolean initignoring;
    protected Object oldvals;

    public BeliefSetChangeCondition(IRBeliefSet beliefset, Object[] oldvals, String[] eventtypes, IAgendaAction action) {
        super(null, beliefset.getScope());
        this.beliefset = beliefset;
        this.oldvals = oldvals;
        this.eventtypes = eventtypes;
        this.action = action == null ? new ConditionDefaultAction2(this, beliefset.getScope()) : action;
        this.initignoring = true;
    }

    public boolean isInitIgnoring() {
        return this.initignoring;
    }

    public void setInitIgnoring(boolean initignoring) {
        this.initignoring = initignoring;
    }

    public boolean isAffected(SystemEvent event) {
        boolean ret = false;
        if (event.getSource().equals(this.beliefset) && (!this.isInitIgnoring() || !event.isInit()) && ISystemEventTypes.Subtypes.isSubtype(event.getType(), this.eventtypes)) {
            if (event.isDerived() && event.getType().equals("BDI_bsfactsChanged")) {
                Object[] newvals = this.beliefset.getFacts();
                boolean bl = ret = !SUtil.arrayEquals(this.oldvals, newvals);
                if (ret) {
                    this.oldvals = newvals;
                }
            } else {
                ret = true;
            }
        }
        return ret;
    }

    public boolean isTriggered() {
        this.throwSystemEvent("condition_triggered");
        return true;
    }

    public IFilter getFilter() {
        InternalEventFilter confi = new InternalEventFilter("InternalEvent_condition_triggered");
        confi.addValue("condition", this);
        return confi;
    }
}

