/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.runtime.IFilter;
import jadex.runtime.InternalEventFilter;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IRBelief;
import jadex.runtime.impl.InterpreterCondition;
import jadex.runtime.impl.agenda.IAgendaAction;
import jadex.runtime.impl.agenda.conditions.ConditionDefaultAction2;
import jadex.util.SUtil;

public class BeliefChangeCondition
extends InterpreterCondition {
    protected IRBelief belief;
    protected Object oldval;
    protected boolean initignoring;

    public BeliefChangeCondition(IRBelief belief, Object oldval, IAgendaAction action) {
        super(null, belief.getScope());
        this.belief = belief;
        this.oldval = oldval;
        this.action = action == null ? new ConditionDefaultAction2(this, belief.getScope()) : action;
        this.initignoring = true;
    }

    public boolean isInitIgnoring() {
        return this.initignoring;
    }

    public void setInitIgnoring(boolean initignoring) {
        this.initignoring = initignoring;
    }

    public boolean isAffected(SystemEvent event) {
        boolean ret = false;
        if (event.getSource().equals(this.belief) && (!this.isInitIgnoring() || !event.isInit()) && (ret = event.getType().equals("BDI_factChanged")) && event.isDerived()) {
            Object newval = this.belief.getFact();
            boolean bl = ret = !SUtil.equals(this.oldval, newval);
            if (ret) {
                this.oldval = newval;
            }
        }
        return ret;
    }

    public boolean isTriggered() {
        this.throwSystemEvent("condition_triggered");
        return true;
    }

    public IFilter getFilter() {
        InternalEventFilter confi = new InternalEventFilter("InternalEvent_condition_triggered");
        confi.addValue("condition", this);
        return confi;
    }
}

