/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.runtime.AgentEvent;
import jadex.runtime.IAgentListener;
import jadex.runtime.IBeliefListener;
import jadex.runtime.IBeliefSetListener;
import jadex.runtime.IConditionListener;
import jadex.runtime.IGoalListener;
import jadex.runtime.IInternalEventListener;
import jadex.runtime.IMessageEventListener;
import jadex.runtime.IPlanListener;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.SystemEvent;
import jadex.runtime.externalaccesswrapper.BeliefSetWrapper;
import jadex.runtime.externalaccesswrapper.BeliefWrapper;
import jadex.runtime.externalaccesswrapper.ConditionWrapper;
import jadex.runtime.externalaccesswrapper.GoalWrapper;
import jadex.runtime.externalaccesswrapper.InternalEventWrapper;
import jadex.runtime.externalaccesswrapper.MessageEventWrapper;
import jadex.runtime.externalaccesswrapper.PlanWrapper;
import jadex.runtime.impl.IRBelief;
import jadex.runtime.impl.IRBeliefSet;
import jadex.runtime.impl.IRCondition;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.IRInternalEvent;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.RPlan;
import java.io.Serializable;

public class AsynchronousSystemEventListener
implements ISystemEventListener,
Serializable {
    protected Object listener;
    protected Object identifier;

    public AsynchronousSystemEventListener(Object listener, Object identifier) {
        this.listener = listener;
        this.identifier = identifier;
    }

    public void systemEventsOccurred(SystemEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            RPlan plan;
            IRMessageEvent me;
            IRGoal goal;
            if ("BDI_bsfactAdded".equals(events[i].getType())) {
                ((IBeliefSetListener)this.listener).factAdded(new AgentEvent(new BeliefSetWrapper((IRBeliefSet)events[i].getSource()), events[i].getValue()));
                continue;
            }
            if ("BDI_bsfactRemoved".equals(events[i].getType())) {
                ((IBeliefSetListener)this.listener).factRemoved(new AgentEvent(new BeliefSetWrapper((IRBeliefSet)events[i].getSource()), events[i].getValue()));
                continue;
            }
            if ("BDI_bsfactChanged".equals(events[i].getType()) || "BDI_bsfactsChanged".equals(events[i].getType())) {
                ((IBeliefSetListener)this.listener).beliefSetChanged(new AgentEvent(new BeliefSetWrapper((IRBeliefSet)events[i].getSource()), events[i].getValue()));
                continue;
            }
            if ("BDI_factChanged".equals(events[i].getType())) {
                ((IBeliefListener)this.listener).beliefChanged(new AgentEvent(new BeliefWrapper((IRBelief)events[i].getSource()), events[i].getValue()));
                continue;
            }
            if ("BDI_goalAdded".equals(events[i].getType())) {
                goal = (IRGoal)events[i].getSource();
                ((IGoalListener)this.listener).goalAdded(new AgentEvent(new GoalWrapper(goal)));
                continue;
            }
            if ("BDI_goalRemoved".equals(events[i].getType())) {
                goal = (IRGoal)events[i].getSource();
                ((IGoalListener)this.listener).goalFinished(new AgentEvent(new GoalWrapper(goal)));
                continue;
            }
            if ("message_sent".equals(events[i].getType())) {
                me = (IRMessageEvent)events[i].getSource();
                ((IMessageEventListener)this.listener).messageEventSent(new AgentEvent(new MessageEventWrapper(me)));
                continue;
            }
            if ("message_received".equals(events[i].getType())) {
                me = (IRMessageEvent)events[i].getSource();
                ((IMessageEventListener)this.listener).messageEventReceived(new AgentEvent(new MessageEventWrapper(me)));
                continue;
            }
            if ("internalevent_occurred".equals(events[i].getType())) {
                IRInternalEvent ie = (IRInternalEvent)events[i].getSource();
                ((IInternalEventListener)this.listener).internalEventOccurred(new AgentEvent(new InternalEventWrapper(ie)));
                continue;
            }
            if ("condition_triggered".equals(events[i].getType())) {
                IRCondition cond = (IRCondition)events[i].getSource();
                ((IConditionListener)this.listener).conditionTriggered(new AgentEvent(new ConditionWrapper(cond)));
                continue;
            }
            if ("BDI_planAdded".equals(events[i].getType())) {
                plan = (RPlan)events[i].getSource();
                ((IPlanListener)this.listener).planAdded(new AgentEvent(new PlanWrapper(plan)));
                continue;
            }
            if ("BDI_planRemoved".equals(events[i].getType())) {
                plan = (RPlan)events[i].getSource();
                ((IPlanListener)this.listener).planFinished(new AgentEvent(new PlanWrapper(plan)));
                continue;
            }
            if (!"agentTerminating".equals(events[i].getType())) continue;
            ((IAgentListener)this.listener).agentTerminating(new AgentEvent(null));
        }
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return "AsynchronousSystemEventListener(listener=" + this.listener + ")";
    }
}

