/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.impl;

import jadex.model.IMPlan;
import jadex.model.IMPlanbase;
import jadex.runtime.ICandidateInfo;
import jadex.runtime.IFilter;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRGoalEvent;
import jadex.runtime.impl.PlanInstanceInfo;
import jadex.runtime.impl.RBDIAgent;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RPlanbase;
import jadex.runtime.impl.RReferenceableElement;
import jadex.runtime.impl.WaitqueueInfo;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ApplicableCandidateList
implements Serializable {
    protected IREvent event;
    protected List candidates;
    protected Set excludeset;
    protected List result;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ApplicableCandidateList(IREvent event) {
        this.event = event;
    }

    public List getCandidates() {
        if (this.candidates == null || this.isRecalculating()) {
            this.calculateCandidates();
        }
        return this.result;
    }

    public void setEvent(IREvent event) {
        this.event = event;
    }

    public void clearExcludeSet() {
        this.excludeset = null;
    }

    public boolean isRecalculating() {
        boolean ret = false;
        if (this.event instanceof IRGoalEvent) {
            ret = ((IRGoalEvent)this.event).getGoal().isRecalculating();
        }
        return ret;
    }

    public String getExcludeMode() {
        String ret = "when_tried";
        if (this.event instanceof IRGoalEvent) {
            ret = ((IRGoalEvent)this.event).getGoal().getExcludeMode();
        }
        return ret;
    }

    public Set getExecutedCandidates() {
        return Collections.unmodifiableSet(this.getExcludeSet());
    }

    protected void addExcludeCandidate(ICandidateInfo exclude) {
        if (!$assertionsDisabled && exclude == null) {
            throw new AssertionError();
        }
        if (!this.getExcludeMode().equals("never") && !this.getExcludeSet().contains(exclude)) {
            this.getExcludeSet().add(exclude);
        }
        this.recalculateResult();
    }

    protected Set getExcludeSet() {
        if (this.excludeset == null) {
            this.excludeset = !this.getExcludeMode().equals("never") ? SCollection.createHashSet() : Collections.EMPTY_SET;
        }
        return this.excludeset;
    }

    protected void recalculateResult() {
        if (this.candidates == null || this.candidates.size() == 0) {
            this.result = Collections.EMPTY_LIST;
        } else {
            this.result = (List)((ArrayList)this.candidates).clone();
            this.result.removeAll(this.excludeset);
        }
    }

    protected void calculateCandidates() {
        this.candidates = SCollection.createArrayList();
        List occurrences = this.event.getAllOccurrences();
        for (int j = 0; j < occurrences.size(); ++j) {
            RReferenceableElement elm = (RReferenceableElement)occurrences.get(j);
            this.generateCandidateList((IREvent)((Object)elm));
        }
        this.recalculateResult();
    }

    protected void generateCandidateList(IREvent event) {
        IFilter filter;
        RPlanbase planbase = event.getScope().getPlanbase();
        RPlan[] plans = planbase.getPlans();
        RBDIAgent agent = event.getScope().getAgent();
        for (int i = 0; i < plans.length; ++i) {
            PlanInstanceInfo cand = new PlanInstanceInfo(event, plans[i]);
            if (this.getExcludeSet().contains(cand) || plans[i].getContextCondition() != null && !((Boolean)plans[i].getContextCondition().getValue()).booleanValue()) continue;
            IFilter iFilter = filter = plans[i].getWaitAbstraction() != null ? plans[i].getWaitAbstraction().getFilter() : null;
            if (agent.applyFilter(filter, event)) {
                this.candidates.add(cand);
                continue;
            }
            if (!agent.applyFilter(plans[i].getWaitqueue().getFilter(), event)) continue;
            this.candidates.add(new WaitqueueInfo(event, plans[i], plans[i].getWaitqueue().getFilter()));
        }
        IMPlan[] mplans = ((IMPlanbase)planbase.getModelElement()).getPlans();
        for (int i = 0; i < mplans.length; ++i) {
            filter = planbase.getPassivePlanActivationFilter(mplans[i]);
            if (!event.getScope().getAgent().applyFilter(filter, event)) continue;
            this.candidates.addAll(planbase.generateBindingCandidates(null, mplans[i], event, this.getExcludeSet()));
        }
    }

    static {
        $assertionsDisabled = !ApplicableCandidateList.class.desiredAssertionStatus();
    }
}

