/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.externalaccesswrapper;

import jadex.model.IMPlan;
import jadex.runtime.IPlan;
import jadex.runtime.IPlanListener;
import jadex.runtime.IPlanbase;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.externalaccesswrapper.ElementWrapper;
import jadex.runtime.externalaccesswrapper.PlanWrapper;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.RPlanbase;
import jadex.runtime.impl.SystemEventFilter;
import jadex.util.Tuple;

public class PlanbaseWrapper
extends ElementWrapper
implements IPlanbase {
    protected RPlanbase planbase;

    protected PlanbaseWrapper(RPlanbase planbase) {
        super(planbase.getScope().getAgent(), planbase);
        this.planbase = planbase;
    }

    public IPlan[] getPlans() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = PlanbaseWrapper.this.planbase.getPlans();
            }
        };
        RPlan[] rplans = (RPlan[])exe.object;
        IPlan[] plans = new IPlan[rplans.length];
        for (int i = 0; i < plans.length; ++i) {
            plans[i] = new PlanWrapper(rplans[i]);
        }
        return plans;
    }

    public IPlan[] getPlans(final String type) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = PlanbaseWrapper.this.planbase.getPlans(type);
            }
        };
        RPlan[] rplans = (RPlan[])exe.object;
        IPlan[] plans = new IPlan[rplans.length];
        for (int i = 0; i < plans.length; ++i) {
            plans[i] = new PlanWrapper(rplans[i]);
        }
        return plans;
    }

    public IPlan getPlan(final String name) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = PlanbaseWrapper.this.planbase.getPlan(name);
            }
        };
        return exe.object == null ? null : new PlanWrapper((RPlan)exe.object);
    }

    public void registerPlan(final IMPlan mplan) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                PlanbaseWrapper.this.planbase.registerPlan(mplan);
            }
        };
    }

    public void deregisterPlan(final IMPlan mplan) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                PlanbaseWrapper.this.planbase.deregisterPlan(mplan);
            }
        };
    }

    public void addPlanListener(final String type, final IPlanListener userlistener, final boolean async) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_planAdded", "BDI_planRemoved"}, type);
                AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(new Object[]{userlistener, PlanbaseWrapper.this.planbase, type}));
                PlanbaseWrapper.this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
            }
        };
    }

    public void removePlanListener(final String type, final IPlanListener userlistener) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                Tuple identifier = new Tuple(new Object[]{userlistener, PlanbaseWrapper.this.planbase, type});
                ISystemEventListener[] listeners = PlanbaseWrapper.this.getAgent().getSystemEventListeners();
                for (int i = 0; i < listeners.length; ++i) {
                    if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
                    PlanbaseWrapper.this.getAgent().removeSystemEventListener(listeners[i]);
                    break;
                }
            }
        };
    }
}

