/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.externalaccesswrapper;

import jadex.runtime.IPlan;
import jadex.runtime.IPlanListener;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.IWaitqueue;
import jadex.runtime.externalaccesswrapper.ElementWrapper;
import jadex.runtime.externalaccesswrapper.ParameterElementWrapper;
import jadex.runtime.externalaccesswrapper.WaitqueueWrapper;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.SystemEventFilter;
import jadex.util.Tuple;

public class PlanWrapper
extends ParameterElementWrapper
implements IPlan {
    protected RPlan plan;
    protected WaitqueueWrapper waitqueue;

    public PlanWrapper(RPlan plan) {
        super(plan);
        this.plan = plan;
    }

    public IWaitqueue getWaitqueue() {
        if (this.waitqueue == null) {
            this.waitqueue = new WaitqueueWrapper(this.getAgent(), this.plan.getWaitqueue());
        }
        return this.waitqueue;
    }

    public Object getBody() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = PlanWrapper.this.plan.getBody();
            }
        };
        return exe.object;
    }

    public Object createBody() throws Exception {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                try {
                    this.object = PlanWrapper.this.plan.createBody();
                }
                catch (Exception e) {
                    this.exception = e;
                }
            }
        };
        if (exe.exception != null) {
            throw exe.exception;
        }
        return exe.object;
    }

    public void addPlanListener(final IPlanListener userlistener, final boolean async) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_planAdded", "BDI_planRemoved"}, PlanWrapper.this.unwrap());
                AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(userlistener, PlanWrapper.this.plan));
                PlanWrapper.this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
            }
        };
    }

    public void removePlanListener(final IPlanListener userlistener) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                Tuple identifier = new Tuple(userlistener, PlanWrapper.this.plan);
                ISystemEventListener[] listeners = PlanWrapper.this.getAgent().getSystemEventListeners();
                for (int i = 0; i < listeners.length; ++i) {
                    if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
                    PlanWrapper.this.getAgent().removeSystemEventListener(listeners[i]);
                    break;
                }
            }
        };
    }
}

