/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.externalaccesswrapper;

import jadex.model.IMGoal;
import jadex.model.IMGoalReference;
import jadex.runtime.IFilter;
import jadex.runtime.IGoal;
import jadex.runtime.IGoalListener;
import jadex.runtime.IGoalbase;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.externalaccesswrapper.ElementWrapper;
import jadex.runtime.externalaccesswrapper.GoalWrapper;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.RGoalbase;
import jadex.runtime.impl.SystemEventFilter;
import jadex.util.Tuple;

public class GoalbaseWrapper
extends ElementWrapper
implements IGoalbase {
    protected RGoalbase goalbase;

    protected GoalbaseWrapper(RGoalbase goalbase) {
        super(goalbase.getScope().getAgent(), goalbase);
        this.goalbase = goalbase;
    }

    public IGoal getGoal(final String name) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = GoalbaseWrapper.this.goalbase.getGoal(name);
            }
        };
        return exe.object == null ? null : new GoalWrapper((IRGoal)exe.object);
    }

    public boolean containsGoal(final IGoal goal) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.bool = goal == null ? false : GoalbaseWrapper.this.goalbase.containsGoal((IRGoal)((GoalWrapper)goal).unwrap());
            }
        };
        return exe.bool;
    }

    public IGoal[] getGoals(final String type) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = GoalbaseWrapper.this.goalbase.getGoals(type);
            }
        };
        IRGoal[] rgoals = (IRGoal[])exe.object;
        IGoal[] goals = new IGoal[rgoals.length];
        for (int i = 0; i < goals.length; ++i) {
            goals[i] = new GoalWrapper(rgoals[i]);
        }
        return goals;
    }

    public IGoal[] getGoals() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = GoalbaseWrapper.this.goalbase.getGoals();
            }
        };
        IRGoal[] rgoals = (IRGoal[])exe.object;
        IGoal[] goals = new IGoal[rgoals.length];
        for (int i = 0; i < goals.length; ++i) {
            goals[i] = new GoalWrapper(rgoals[i]);
        }
        return goals;
    }

    public IGoal createGoal(final String type) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = GoalbaseWrapper.this.goalbase.createGoal(type);
            }
        };
        return new GoalWrapper((IRGoal)exe.object);
    }

    public IFilter dispatchTopLevelGoal(final IGoal goal) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = GoalbaseWrapper.this.goalbase.dispatchTopLevelGoal((IRGoal)((GoalWrapper)goal).unwrap());
            }
        };
        return (IFilter)exe.object;
    }

    public void registerGoal(final IMGoal mgoal) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                GoalbaseWrapper.this.goalbase.registerGoal(mgoal);
            }
        };
    }

    public void deregisterGoal(final IMGoal mgoal) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                GoalbaseWrapper.this.goalbase.deregisterGoal(mgoal);
            }
        };
    }

    public void registerGoalReference(final IMGoalReference mgoalref) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                GoalbaseWrapper.this.goalbase.registerGoalReference(mgoalref);
            }
        };
    }

    public void deregisterGoalReference(final IMGoalReference mgoalref) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                GoalbaseWrapper.this.goalbase.deregisterGoalReference(mgoalref);
            }
        };
    }

    public void addGoalListener(final String type, final IGoalListener userlistener, final boolean async) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_goalAdded", "BDI_goalRemoved"}, type);
                AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(new Object[]{userlistener, GoalbaseWrapper.this.goalbase, type}));
                GoalbaseWrapper.this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
            }
        };
    }

    public void removeGoalListener(final String type, final IGoalListener userlistener) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                Tuple identifier = new Tuple(new Object[]{userlistener, GoalbaseWrapper.this.goalbase, type});
                ISystemEventListener[] listeners = GoalbaseWrapper.this.getAgent().getSystemEventListeners();
                for (int i = 0; i < listeners.length; ++i) {
                    if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
                    GoalbaseWrapper.this.getAgent().removeSystemEventListener(listeners[i]);
                    break;
                }
            }
        };
    }
}

