/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.externalaccesswrapper;

import jadex.runtime.AgentDeathException;
import jadex.runtime.GoalFailureException;
import jadex.runtime.ICondition;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IFilter;
import jadex.runtime.IGoal;
import jadex.runtime.IInternalEvent;
import jadex.runtime.IMessageEvent;
import jadex.runtime.SystemEvent;
import jadex.runtime.TimeoutException;
import jadex.runtime.externalaccesswrapper.CapabilityWrapper;
import jadex.runtime.externalaccesswrapper.ConditionWrapper;
import jadex.runtime.externalaccesswrapper.ElementWrapper;
import jadex.runtime.externalaccesswrapper.GoalWrapper;
import jadex.runtime.externalaccesswrapper.InternalEventWrapper;
import jadex.runtime.externalaccesswrapper.MessageEventWrapper;
import jadex.runtime.externalaccesswrapper.SynchronousSystemEventListener;
import jadex.runtime.impl.IRCondition;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.IRInternalEvent;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.SystemEventFilter;
import jadex.runtime.impl.SystemEventMessageFilter;
import jadex.runtime.impl.TimetableData;
import jadex.runtime.impl.agenda.IAgendaAction;

public class ExternalAccess
extends CapabilityWrapper
implements IExternalAccess {
    public ExternalAccess(RCapability cap) {
        super(cap);
    }

    public void dispatchTopLevelGoal(IGoal goal) {
        this.getGoalbase().dispatchTopLevelGoal(goal);
    }

    public IGoal createGoal(String type) {
        return this.getGoalbase().createGoal(type);
    }

    public IFilter sendMessage(IMessageEvent me) {
        return this.getEventbase().sendMessage(me);
    }

    public void dispatchInternalEvent(IInternalEvent event) {
        this.getEventbase().dispatchInternalEvent(event);
    }

    public IMessageEvent createMessageEvent(String type) {
        return this.getEventbase().createMessageEvent(type);
    }

    public IInternalEvent createInternalEvent(String type) {
        return this.getEventbase().createInternalEvent(type);
    }

    public IInternalEvent createInternalEvent(String type, Object content) {
        return this.getEventbase().createInternalEvent(type, content);
    }

    public void waitFor(long duration) {
        this.performWait(duration, null);
    }

    public void waitForCondition(ICondition condition) {
        this.waitForCondition(condition, -1L);
    }

    public void waitForCondition(ICondition condition, long timeout) {
        IRCondition cond = (IRCondition)((ConditionWrapper)condition).unwrap();
        SystemEventFilter filter = new SystemEventFilter(new String[]{"condition_triggered", "agentDied"}, cond);
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        boolean changed = false;
        if (cond.getTraceMode().equals("never")) {
            cond.traceOnce();
            changed = true;
        }
        this.performWait(timeout, listener);
        if (changed) {
            cond.setTraceMode("never");
        }
        this.evaluateListenerResult(listener);
    }

    public void waitForCondition(String condition) {
        this.waitForCondition(condition, -1L);
    }

    public void waitForCondition(String condtext, long timeout) {
        IRCondition cond = this.getCapability().getExpressionbase().createCondition(condtext);
        SystemEventFilter filter = new SystemEventFilter(new String[]{"condition_triggered", "agentDied"}, cond);
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        if (cond.getTraceMode().equals("never")) {
            cond.traceOnce();
        }
        this.performWait(timeout, listener);
        cond.cleanup();
        this.evaluateListenerResult(listener);
    }

    public IInternalEvent waitForInternalEvent(String type) {
        return this.waitForInternalEvent(type, -1L);
    }

    public IInternalEvent waitForInternalEvent(String type, long timeout) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"internalevent_occurred", "agentDied"}, type);
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        SystemEvent se = this.eventWaitFor(timeout, listener);
        return new InternalEventWrapper((IRInternalEvent)se.getSource());
    }

    public IMessageEvent sendMessageAndWait(IMessageEvent me) {
        return this.sendMessageAndWait(me, -1L);
    }

    public IMessageEvent sendMessageAndWait(IMessageEvent me, long timeout) {
        SystemEventMessageFilter filter = new SystemEventMessageFilter((IRMessageEvent)((MessageEventWrapper)me).unwrap());
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        this.getEventbase().sendMessage(me);
        SystemEvent se = this.eventWaitFor(timeout, listener);
        return new MessageEventWrapper((IRMessageEvent)se.getSource());
    }

    public IMessageEvent waitForMessageEvent(String type) {
        return this.waitForMessageEvent(type, -1L);
    }

    public IMessageEvent waitForMessageEvent(String type, long timeout) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"message_received", "agentDied"}, type);
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        SystemEvent se = this.eventWaitFor(timeout, listener);
        return new MessageEventWrapper((IRMessageEvent)se.getSource());
    }

    public IMessageEvent waitForReply(IMessageEvent me) {
        return this.waitForReply(me, -1L);
    }

    public IMessageEvent waitForReply(IMessageEvent me, long timeout) {
        SystemEventMessageFilter filter = new SystemEventMessageFilter((IRMessageEvent)((MessageEventWrapper)me).unwrap());
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        SystemEvent se = this.eventWaitFor(timeout, listener);
        return new MessageEventWrapper((IRMessageEvent)se.getSource());
    }

    public void dispatchTopLevelGoalAndWait(IGoal goal) {
        this.dispatchTopLevelGoalAndWait(goal, -1L);
    }

    public void dispatchTopLevelGoalAndWait(IGoal goal, long timeout) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_goalRemoved", "agentDied"}, ((GoalWrapper)goal).unwrap());
        IRGoal rgoal = (IRGoal)((GoalWrapper)goal).unwrap();
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        this.dispatchTopLevelGoal(goal);
        this.eventWaitFor(timeout, listener);
        if (!rgoal.isFinished()) {
            rgoal.drop();
        }
        if (rgoal.isFailed()) {
            throw new GoalFailureException(goal, (Throwable)rgoal.getException());
        }
    }

    public void waitForGoal(String type) {
        this.waitForGoal(type, -1L);
    }

    public void waitForGoal(String type, long timeout) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_goalRemoved", "agentDied"}, type);
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        this.eventWaitFor(timeout, listener);
    }

    public Object waitForBeliefChange(String type) {
        return this.waitForBeliefChange(type, -1L);
    }

    public Object waitForBeliefChange(String type, long timeout) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_factChanged", "agentDied"}, type);
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        SystemEvent se = this.eventWaitFor(timeout, listener);
        return se.getValue();
    }

    public void waitForBeliefSetChange(String type) {
        this.waitForBeliefSetChange(type, -1L);
    }

    public void waitForBeliefSetChange(String type, long timeout) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_bsfactAdded", "BDI_bsfactRemoved", "BDI_bsfactsChanged", "agentDied"}, type);
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        this.eventWaitFor(timeout, listener);
    }

    public Object waitForFactAddedOrRemoved(String type) {
        return this.waitForFactAddedOrRemoved(type, -1L);
    }

    public Object waitForFactAddedOrRemoved(String type, long timeout) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_bsfactAdded", "BDI_bsfactRemoved", "agentDied"}, type);
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        SystemEvent se = this.eventWaitFor(timeout, listener);
        return se.getValue();
    }

    public Object waitForFactAdded(String type) {
        return this.waitForFactAdded(type, -1L);
    }

    public Object waitForFactAdded(String type, long timeout) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_bsfactAdded", "agentDied"}, type);
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        SystemEvent se = this.eventWaitFor(timeout, listener);
        return se.getValue();
    }

    public Object waitForFactRemoved(String type) {
        return this.waitForFactRemoved(type, -1L);
    }

    public Object waitForFactRemoved(String type, long timeout) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_bsfactRemoved", "agentDied"}, type);
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        SystemEvent se = this.eventWaitFor(timeout, listener);
        return se.getValue();
    }

    public void waitForAgentTerminating() {
        this.waitForAgentTerminating(-1L);
    }

    public void waitForAgentTerminating(long timeout) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"agentTerminating", "agentDied"});
        SynchronousSystemEventListener listener = new SynchronousSystemEventListener();
        this.addListener(listener, filter);
        this.eventWaitFor(timeout, listener);
    }

    protected SystemEvent eventWaitFor(long timeout, SynchronousSystemEventListener listener) {
        this.performWait(timeout, listener);
        return this.evaluateListenerResult(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performWait(long timeout, SynchronousSystemEventListener listener) {
        SynchronousSystemEventListener thelistener;
        if (!this.getAgent().getInterpreter().isExternalThread()) {
            if (listener != null) {
                this.removeListener(listener);
            }
            throw new RuntimeException("Calling blocking methods on external access is only allowed from external threads.");
        }
        if (listener == null) {
            listener = new SynchronousSystemEventListener();
        }
        if (timeout != -1L) {
            thelistener = listener;
            final TimetableData entry = new TimetableData(timeout, new IAgendaAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute() {
                    if (!thelistener.isNotified()) {
                        SynchronousSystemEventListener synchronousSystemEventListener = thelistener;
                        synchronized (synchronousSystemEventListener) {
                            thelistener.notify();
                        }
                    }
                }

                public boolean isValid() {
                    return !thelistener.isNotified();
                }
            });
            new ElementWrapper.AgentInvocation(){

                public void run() {
                    ExternalAccess.this.getCapability().getAgent().addTimetableEntry(entry);
                }
            };
        }
        try {
            thelistener = listener;
            synchronized (thelistener) {
                if (!listener.isNotified()) {
                    listener.wait();
                }
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    protected SystemEvent evaluateListenerResult(SynchronousSystemEventListener listener) {
        this.removeListener(listener);
        if (listener.isAgentDied()) {
            throw new AgentDeathException(this.getCapability().getAgent());
        }
        if (listener.getEvent() == null && listener != null) {
            throw new TimeoutException();
        }
        return listener.getEvent();
    }

    protected void addListener(final SynchronousSystemEventListener listener, final IFilter filter) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                ExternalAccess.this.getCapability().getAgent().addSystemEventListener(listener, filter);
            }
        };
    }

    protected void removeListener(final SynchronousSystemEventListener listener) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                ExternalAccess.this.getCapability().getAgent().removeSystemEventListener(listener);
            }
        };
    }
}

