/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.externalaccesswrapper;

import jadex.model.IMCondition;
import jadex.model.IMConditionReference;
import jadex.model.IMExpression;
import jadex.model.IMExpressionReference;
import jadex.runtime.ICondition;
import jadex.runtime.IConditionListener;
import jadex.runtime.IExpression;
import jadex.runtime.IExpressionbase;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.externalaccesswrapper.ConditionWrapper;
import jadex.runtime.externalaccesswrapper.ElementWrapper;
import jadex.runtime.externalaccesswrapper.ExpressionWrapper;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.IRCondition;
import jadex.runtime.impl.IRExpression;
import jadex.runtime.impl.RExpressionbase;
import jadex.runtime.impl.SystemEventFilter;
import jadex.util.Tuple;

public class ExpressionbaseWrapper
extends ElementWrapper
implements IExpressionbase {
    protected RExpressionbase expressionbase;

    protected ExpressionbaseWrapper(RExpressionbase expressionbase) {
        super(expressionbase.getScope().getAgent(), expressionbase);
        this.expressionbase = expressionbase;
    }

    public IExpression getExpression(final String name) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = ExpressionbaseWrapper.this.expressionbase.getExpression(name);
            }
        };
        return new ExpressionWrapper((IRExpression)exe.object);
    }

    public IExpression createExpression(String query) {
        return this.createExpression(query, null, null);
    }

    public IExpression createExpression(final String query, final String[] paramnames, final Class[] paramtypes) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = ExpressionbaseWrapper.this.expressionbase.createExpression(query, paramnames, paramtypes);
            }
        };
        return new ExpressionWrapper((IRExpression)exe.object);
    }

    public ICondition getCondition(final String name) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = ExpressionbaseWrapper.this.expressionbase.getCondition(name);
            }
        };
        return new ConditionWrapper((IRCondition)exe.object);
    }

    public ICondition createCondition(final String expression) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = ExpressionbaseWrapper.this.expressionbase.createCondition(expression);
            }
        };
        return new ConditionWrapper((IRCondition)exe.object);
    }

    public ICondition createCondition(final String expression, final String trigger, final String[] paramnames, final Class[] paramtypes) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = ExpressionbaseWrapper.this.expressionbase.createCondition(expression, trigger, paramnames, paramtypes);
            }
        };
        return new ConditionWrapper((IRCondition)exe.object);
    }

    public void registerExpression(final IMExpression mexpression) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                ExpressionbaseWrapper.this.expressionbase.registerExpression(mexpression);
            }
        };
    }

    public void registerExpressionReference(final IMExpressionReference mexpressionref) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                ExpressionbaseWrapper.this.expressionbase.registerExpressionReference(mexpressionref);
            }
        };
    }

    public void registerCondition(final IMCondition mcondition) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                ExpressionbaseWrapper.this.expressionbase.registerCondition(mcondition);
            }
        };
    }

    public void registerConditionReference(final IMConditionReference mconditionref) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                ExpressionbaseWrapper.this.expressionbase.registerConditionReference(mconditionref);
            }
        };
    }

    public void deregisterExpression(final IMExpression mexpression) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                ExpressionbaseWrapper.this.expressionbase.deregisterExpression(mexpression);
            }
        };
    }

    public void deregisterExpressionReference(final IMExpressionReference mexpressionref) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                ExpressionbaseWrapper.this.expressionbase.deregisterExpressionReference(mexpressionref);
            }
        };
    }

    public void deregisterCondition(final IMCondition mcondition) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                ExpressionbaseWrapper.this.expressionbase.deregisterCondition(mcondition);
            }
        };
    }

    public void deregisterConditionReference(final IMConditionReference mconditionref) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                ExpressionbaseWrapper.this.expressionbase.deregisterConditionReference(mconditionref);
            }
        };
    }

    public void addConditionListener(final String type, final IConditionListener userlistener, final boolean async) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                SystemEventFilter filter = new SystemEventFilter(new String[]{"condition_triggered"}, type);
                AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(new Object[]{userlistener, ExpressionbaseWrapper.this.expressionbase, type}));
                ExpressionbaseWrapper.this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
            }
        };
    }

    public void removeConditionListener(final String type, final IConditionListener userlistener) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                Tuple identifier = new Tuple(new Object[]{userlistener, ExpressionbaseWrapper.this.expressionbase, type});
                ISystemEventListener[] listeners = ExpressionbaseWrapper.this.getAgent().getSystemEventListeners();
                for (int i = 0; i < listeners.length; ++i) {
                    if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
                    ExpressionbaseWrapper.this.getAgent().removeSystemEventListener(listeners[i]);
                    break;
                }
            }
        };
    }
}

