/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.externalaccesswrapper;

import jadex.model.IMCapabilityReference;
import jadex.runtime.BasicAgentIdentifier;
import jadex.runtime.IAgentListener;
import jadex.runtime.IBeliefbase;
import jadex.runtime.ICapability;
import jadex.runtime.IEventbase;
import jadex.runtime.IExpressionbase;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoalbase;
import jadex.runtime.IPlanbase;
import jadex.runtime.IPropertybase;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.externalaccesswrapper.BeliefbaseWrapper;
import jadex.runtime.externalaccesswrapper.ElementWrapper;
import jadex.runtime.externalaccesswrapper.EventbaseWrapper;
import jadex.runtime.externalaccesswrapper.ExpressionbaseWrapper;
import jadex.runtime.externalaccesswrapper.GoalbaseWrapper;
import jadex.runtime.externalaccesswrapper.PlanbaseWrapper;
import jadex.runtime.externalaccesswrapper.PropertybaseWrapper;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.RBeliefbase;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.REventbase;
import jadex.runtime.impl.RExpressionbase;
import jadex.runtime.impl.RGoalbase;
import jadex.runtime.impl.RPlanbase;
import jadex.runtime.impl.RPropertybase;
import jadex.runtime.impl.SystemEventFilter;
import jadex.util.Tuple;
import java.util.logging.Logger;

public abstract class CapabilityWrapper
extends ElementWrapper
implements ICapability {
    private RCapability cap;
    protected BeliefbaseWrapper beliefbase;
    protected GoalbaseWrapper goalbase;
    protected PlanbaseWrapper planbase;
    protected EventbaseWrapper eventbase;
    protected ExpressionbaseWrapper expressionbase;
    protected PropertybaseWrapper propertybase;

    public CapabilityWrapper(RCapability cap) {
        super(cap.getAgent(), cap);
        this.cap = cap;
    }

    public IExternalAccess getExternalAccess() {
        return (IExternalAccess)((Object)this);
    }

    public Logger getLogger() {
        return this.cap.getLogger();
    }

    public IBeliefbase getBeliefbase() {
        if (this.beliefbase == null) {
            ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

                public void run() {
                    this.object = CapabilityWrapper.this.cap.getBeliefbase();
                }
            };
            this.beliefbase = new BeliefbaseWrapper((RBeliefbase)exe.object);
        }
        return this.beliefbase;
    }

    public IGoalbase getGoalbase() {
        if (this.goalbase == null) {
            ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

                public void run() {
                    this.object = CapabilityWrapper.this.cap.getGoalbase();
                }
            };
            this.goalbase = new GoalbaseWrapper((RGoalbase)exe.object);
        }
        return this.goalbase;
    }

    public IPlanbase getPlanbase() {
        if (this.planbase == null) {
            ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

                public void run() {
                    this.object = CapabilityWrapper.this.cap.getPlanbase();
                }
            };
            this.planbase = new PlanbaseWrapper((RPlanbase)exe.object);
        }
        return this.planbase;
    }

    public IEventbase getEventbase() {
        if (this.eventbase == null) {
            ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

                public void run() {
                    this.object = CapabilityWrapper.this.cap.getEventbase();
                }
            };
            this.eventbase = new EventbaseWrapper((REventbase)exe.object);
        }
        return this.eventbase;
    }

    public IExpressionbase getExpressionbase() {
        if (this.expressionbase == null) {
            ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

                public void run() {
                    this.object = CapabilityWrapper.this.cap.getExpressionbase();
                }
            };
            this.expressionbase = new ExpressionbaseWrapper((RExpressionbase)exe.object);
        }
        return this.expressionbase;
    }

    public IPropertybase getPropertybase() {
        if (this.propertybase == null) {
            ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

                public void run() {
                    this.object = CapabilityWrapper.this.cap.getPropertybase();
                }
            };
            this.propertybase = new PropertybaseWrapper((RPropertybase)exe.object);
        }
        return this.propertybase;
    }

    public String getAgentName() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.string = CapabilityWrapper.this.cap.getAgentName();
            }
        };
        return exe.string;
    }

    public String getInitialStateName() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.string = CapabilityWrapper.this.cap.getInitialStateName();
            }
        };
        return exe.string;
    }

    public BasicAgentIdentifier getAgentIdentifier() {
        return this.cap.getAgent().getAgentIdentifier();
    }

    public Object getPlatformAgent() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = CapabilityWrapper.this.cap.getPlatformAgent();
            }
        };
        return exe.object;
    }

    public String getPlatformType() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.string = CapabilityWrapper.this.cap.getAgent().getPlatformType();
            }
        };
        return exe.string;
    }

    public void addSubcapability(final String name, final String capafile) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                CapabilityWrapper.this.cap.addSubcapability(name, capafile);
            }
        };
    }

    public void removeSubcapability(final String name) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                CapabilityWrapper.this.cap.removeSubcapability(name);
            }
        };
    }

    public void registerSubcapability(final IMCapabilityReference subcap) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                CapabilityWrapper.this.cap.registerSubcapability(subcap);
            }
        };
    }

    public void deregisterSubcapability(final IMCapabilityReference subcap) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                CapabilityWrapper.this.cap.deregisterSubcapability(subcap);
            }
        };
    }

    public void killAgent() {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                CapabilityWrapper.this.cap.getAgent().getInterpreter().killAgent();
            }
        };
    }

    public void addAgentListener(final IAgentListener userlistener, final boolean async) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                SystemEventFilter filter = new SystemEventFilter(new String[]{"agentTerminating", "agentDied"}, CapabilityWrapper.this.unwrap());
                AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(userlistener, CapabilityWrapper.this.cap));
                CapabilityWrapper.this.getCapability().getAgent().addSystemEventListener(listener, filter, true, async);
            }
        };
    }

    public void removeAgentListener(final IAgentListener userlistener) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                Tuple identifier = new Tuple(userlistener, CapabilityWrapper.this.cap);
                ISystemEventListener[] listeners = CapabilityWrapper.this.getAgent().getSystemEventListeners();
                for (int i = 0; i < listeners.length; ++i) {
                    if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
                    CapabilityWrapper.this.getAgent().removeSystemEventListener(listeners[i]);
                    break;
                }
            }
        };
    }

    protected RCapability getCapability() {
        return this.cap;
    }
}

