/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.externalaccesswrapper;

import jadex.model.IMTypedElement;
import jadex.runtime.IBelief;
import jadex.runtime.IBeliefListener;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.externalaccesswrapper.ElementWrapper;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.IRBelief;
import jadex.runtime.impl.SystemEventFilter;
import jadex.util.Tuple;

public class BeliefWrapper
extends ElementWrapper
implements IBelief {
    protected IRBelief belief;

    public BeliefWrapper(IRBelief belief) {
        super(belief.getScope().getAgent(), belief);
        this.belief = belief;
    }

    public void setFact(final Object fact) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                BeliefWrapper.this.belief.setFact(fact);
            }
        };
    }

    public Object getFact() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = BeliefWrapper.this.belief.getFact();
            }
        };
        return exe.object;
    }

    public void modified() {
        this.belief.getOriginalElement().throwSystemEvent("BDI_factChanged");
    }

    public Class getClazz() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.clazz = ((IMTypedElement)BeliefWrapper.this.belief.getModelElement()).getClazz();
            }
        };
        return exe.clazz;
    }

    public boolean isAccessible() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.bool = BeliefWrapper.this.belief.isAccessible();
            }
        };
        return exe.bool;
    }

    public void addBeliefListener(final IBeliefListener userlistener, final boolean async) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_factChanged"}, BeliefWrapper.this.unwrap());
                AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(userlistener, BeliefWrapper.this.belief));
                BeliefWrapper.this.getAgent().addSystemEventListener(listener, filter, true, async);
            }
        };
    }

    public void removeBeliefListener(final IBeliefListener userlistener) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                Tuple identifier = new Tuple(userlistener, BeliefWrapper.this.belief);
                ISystemEventListener[] listeners = BeliefWrapper.this.getAgent().getSystemEventListeners();
                for (int i = 0; i < listeners.length; ++i) {
                    if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
                    BeliefWrapper.this.getAgent().removeSystemEventListener(listeners[i]);
                    break;
                }
            }
        };
    }
}

