/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime.externalaccesswrapper;

import jadex.model.IMTypedElementSet;
import jadex.runtime.IBeliefSet;
import jadex.runtime.IBeliefSetListener;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.externalaccesswrapper.ElementWrapper;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.IRBeliefSet;
import jadex.runtime.impl.SystemEventFilter;
import jadex.util.Tuple;

public class BeliefSetWrapper
extends ElementWrapper
implements IBeliefSet {
    protected IRBeliefSet beliefset;

    public BeliefSetWrapper(IRBeliefSet beliefset) {
        super(beliefset.getScope().getAgent(), beliefset);
        this.beliefset = beliefset;
    }

    public void addFact(final Object fact) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                BeliefSetWrapper.this.beliefset.addFact(fact);
            }
        };
    }

    public void removeFact(final Object fact) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                BeliefSetWrapper.this.beliefset.removeFact(fact);
            }
        };
    }

    public void addFacts(final Object[] facts) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                BeliefSetWrapper.this.beliefset.addFacts(facts);
            }
        };
    }

    public void removeFacts() {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                BeliefSetWrapper.this.beliefset.removeFacts();
            }
        };
    }

    public Object getFact(final Object oldval) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.object = BeliefSetWrapper.this.beliefset.getFact(oldval);
            }
        };
        return exe.object;
    }

    public boolean containsFact(final Object fact) {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.bool = BeliefSetWrapper.this.beliefset.containsFact(fact);
            }
        };
        return exe.bool;
    }

    public Object[] getFacts() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.oarray = BeliefSetWrapper.this.beliefset.getFacts();
            }
        };
        return exe.oarray;
    }

    public void updateFact(final Object newfact) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                BeliefSetWrapper.this.beliefset.updateFact(newfact);
            }
        };
    }

    public int size() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.integer = BeliefSetWrapper.this.beliefset.size();
            }
        };
        return exe.integer;
    }

    public void modified() {
        this.beliefset.getOriginalElement().throwSystemEvent("BDI_bsfactsChanged");
    }

    public Class getClazz() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.clazz = ((IMTypedElementSet)BeliefSetWrapper.this.beliefset.getModelElement()).getClazz();
            }
        };
        return exe.clazz;
    }

    public boolean isAccessible() {
        ElementWrapper.AgentInvocation exe = new ElementWrapper.AgentInvocation(){

            public void run() {
                this.bool = BeliefSetWrapper.this.beliefset.isAccessible();
            }
        };
        return exe.bool;
    }

    public void addBeliefSetListener(final IBeliefSetListener userlistener, final boolean async) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_bsfactAdded", "BDI_bsfactRemoved", "BDI_bsfactsChanged", "BDI_bsfactChanged"}, BeliefSetWrapper.this.unwrap());
                AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(userlistener, BeliefSetWrapper.this.beliefset));
                BeliefSetWrapper.this.getAgent().addSystemEventListener(listener, filter, true, async);
            }
        };
    }

    public void removeBeliefSetListener(final IBeliefSetListener userlistener) {
        new ElementWrapper.AgentInvocation(){

            public void run() {
                Tuple identifier = new Tuple(userlistener, BeliefSetWrapper.this.beliefset);
                ISystemEventListener[] listeners = BeliefSetWrapper.this.getAgent().getSystemEventListeners();
                for (int i = 0; i < listeners.length; ++i) {
                    if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
                    BeliefSetWrapper.this.getAgent().removeSystemEventListener(listeners[i]);
                    break;
                }
            }
        };
    }
}

