/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime;

import jadex.model.ISystemEventTypes;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.Set;

public class SystemEvent
implements ISystemEventTypes,
Serializable {
    protected String type;
    protected boolean change;
    protected boolean derived;
    protected Object source;
    protected Object value;
    protected int index;
    protected String cause;
    protected boolean init;
    protected int hashcode;
    protected static Set changetypes = SCollection.createHashSet();

    public SystemEvent() {
    }

    public SystemEvent(String type, Object source) {
        this(type, source, null);
    }

    public SystemEvent(String type, Object source, Object value) {
        this(type, source, value, -1);
    }

    public SystemEvent(String type, Object source, Object value, int index) {
        this.type = type;
        this.source = source;
        this.value = value;
        this.index = index;
        this.change = SystemEvent.isChangeRelevant(type);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.change = SystemEvent.isChangeRelevant(type);
    }

    public boolean isChangeRelevant() {
        return this.change;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public String getCause() {
        return this.cause;
    }

    public boolean isDerived() {
        return this.derived;
    }

    public void setDerived(boolean derived) {
        this.derived = derived;
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public boolean instanceOf(String type) {
        return ISystemEventTypes.Subtypes.getSubtypes(type).contains(this.type);
    }

    public boolean equals(Object o) {
        SystemEvent se;
        boolean ret = false;
        if (o instanceof SystemEvent && (this.type == (se = (SystemEvent)o).getType() || this.type != null && this.type.equals(se.getType())) && (this.source == se.getSource() || this.source != null && this.source.equals(se.getSource())) && (this.value == se.getValue() || this.value != null && this.value.equals(se.getValue())) && this.index == se.getIndex()) {
            ret = true;
        }
        return ret;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = this.type.hashCode();
            if (this.source != null) {
                this.hashcode ^= this.source.hashCode();
            }
            if (this.index != -1) {
                this.hashcode ^= this.index;
            }
        }
        return this.hashcode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(type=");
        sb.append(this.type);
        sb.append(", source=");
        sb.append(this.source);
        if (this.index != -1) {
            sb.append(", index=");
            sb.append(this.index);
            sb.append(", value=");
            sb.append(this.value);
        }
        sb.append(")");
        return sb.toString();
    }

    public Object clone() {
        SystemEvent clone = new SystemEvent();
        clone.cause = this.cause;
        clone.change = this.change;
        clone.hashcode = this.hashcode;
        clone.index = this.index;
        clone.source = this.source;
        clone.type = this.type;
        clone.value = this.value;
        return clone;
    }

    protected static boolean isChangeRelevant(String type) {
        return changetypes.contains(type);
    }

    static {
        changetypes.add("BDI_beliefAdded");
        changetypes.add("BDI_beliefRemoved");
        changetypes.add("BDI_factChanged");
        changetypes.add("BDI_bsfactAdded");
        changetypes.add("BDI_bsfactRemoved");
        changetypes.add("BDI_bsfactChanged");
        changetypes.add("BDI_bsfactsChanged");
        changetypes.add("BDI_valueChanged");
        changetypes.add("BDI_esValueAdded");
        changetypes.add("BDI_esValueRemoved");
        changetypes.add("BDI_esValueChanged");
        changetypes.add("BDI_esValuesChanged");
        changetypes.add("BDI_goalAdded");
        changetypes.add("BDI_goalRemoved");
        changetypes.add("BDI_goalChanged");
        changetypes.add("BDI_bindingChanged");
        changetypes.add("BDI_planAdded");
        changetypes.add("BDI_planRemoved");
        changetypes.add("BDI_planChanged");
    }
}

