/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime;

import jadex.runtime.AbstractPlan;
import jadex.runtime.GoalFailureException;
import jadex.runtime.ICondition;
import jadex.runtime.IEvent;
import jadex.runtime.IFilter;
import jadex.runtime.IGoal;
import jadex.runtime.IGoalEvent;
import jadex.runtime.IInternalEvent;
import jadex.runtime.IMessageEvent;
import jadex.runtime.IPlanExecutor;
import jadex.runtime.SystemEvent;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.WaitAbstraction;
import jadex.runtime.planwrapper.ConditionWrapper;
import jadex.runtime.planwrapper.EventbaseWrapper;
import jadex.runtime.planwrapper.GoalWrapper;
import jadex.runtime.planwrapper.MessageEventWrapper;

public abstract class Plan
extends AbstractPlan {
    protected IEvent initialevent = EventbaseWrapper.wrap(this.getRPlan().getInitialEvent(), this.getRPlan());

    public abstract void body();

    public void passed() {
    }

    public void failed() {
    }

    public void aborted() {
    }

    public IEvent getInitialEvent() {
        this.getCapability().checkThreadAccess();
        return this.initialevent;
    }

    public void waitFor(long duration) {
        this.getCapability().checkThreadAccess();
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.setTimeout(duration, this.getRPlan());
        this.eventWaitFor(wa);
    }

    public void waitForCondition(ICondition condition) {
        this.waitForCondition(condition, -1L);
    }

    public void waitForCondition(ICondition condition, long timeout) {
        this.getCapability().checkThreadAccess();
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addCondition(((ConditionWrapper)condition).getOriginalCondition());
        wa.setTimeout(timeout, this.getRPlan());
        this.eventWaitFor(wa);
    }

    public void waitForCondition(String condition) {
        this.waitForCondition(condition, -1L);
    }

    public void waitForCondition(String condition, long timeout) {
        this.getCapability().checkThreadAccess();
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addCondition(condition);
        wa.setTimeout(timeout, this.getRPlan());
        this.eventWaitFor(wa);
    }

    public void dispatchSubgoalAndWait(IGoal subgoal) throws GoalFailureException {
        this.dispatchSubgoalAndWait(subgoal, -1L);
    }

    public void dispatchSubgoalAndWait(IGoal subgoal, long timeout) {
        this.getCapability().checkThreadAccess();
        this.getRPlan().startMonitorConsequences();
        IRGoal rgoal = (IRGoal)((GoalWrapper)subgoal).unwrap();
        String planstate = this.getRPlan().getState();
        RuntimeException rex = null;
        try {
            this.dispatchSubgoal(subgoal);
            WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
            wa.addGoal(rgoal);
            wa.setTimeout(timeout, this.getRPlan());
            IEvent event = this.eventWaitFor(wa);
        }
        catch (RuntimeException e) {
            rex = e;
        }
        this.getRPlan().endMonitorConsequences();
        if (rex != null) {
            throw rex;
        }
        if (!subgoal.isSucceeded()) {
            throw new GoalFailureException(subgoal, (Throwable)rgoal.getException());
        }
    }

    public IInternalEvent waitForInternalEvent(String type) {
        return this.waitForInternalEvent(type, -1L);
    }

    public IInternalEvent waitForInternalEvent(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addInternalEvent(type, null);
        wa.setTimeout(timeout, this.getRPlan());
        return (IInternalEvent)this.eventWaitFor(wa);
    }

    public IMessageEvent sendMessageAndWait(IMessageEvent me) {
        return this.sendMessageAndWait(me, -1L);
    }

    public IMessageEvent sendMessageAndWait(IMessageEvent me, long timeout) {
        this.sendMessage(me);
        return this.waitForReply(me, timeout);
    }

    public IMessageEvent waitForMessageEvent(String type) {
        return this.waitForMessageEvent(type, -1L);
    }

    public IMessageEvent waitForMessageEvent(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addMessageEvent(type, null);
        wa.setTimeout(timeout, this.getRPlan());
        return (IMessageEvent)this.eventWaitFor(wa);
    }

    public IMessageEvent waitForReply(IMessageEvent msgevent) {
        return this.waitForReply(msgevent, -1L);
    }

    public IMessageEvent waitForReply(IMessageEvent msgevent, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addMessageEvent((IRMessageEvent)((MessageEventWrapper)msgevent).unwrap());
        wa.setTimeout(timeout, this.getRPlan());
        IEvent ev = this.eventWaitFor(wa);
        return (IMessageEvent)ev;
    }

    public IGoal waitForGoal(String type) {
        return this.waitForGoal(type, -1L);
    }

    public IGoal waitForGoal(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addGoal(type, null);
        wa.setTimeout(timeout, this.getRPlan());
        IGoalEvent event = (IGoalEvent)this.eventWaitFor(wa);
        return event.getGoal();
    }

    public void waitForSubgoal(IGoal goal) {
        this.waitForSubgoal(goal, -1L);
    }

    public void waitForSubgoal(IGoal goal, long timeout) {
        IRGoal rgoal = (IRGoal)((GoalWrapper)goal).unwrap();
        if (rgoal.getParent() != this.getRPlan().getRootGoal()) {
            throw new RuntimeException("Goal not a subgoal: " + goal);
        }
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addGoal(rgoal);
        wa.setTimeout(timeout, this.getRPlan());
        this.eventWaitFor(wa);
    }

    public Object waitForBeliefChange(String type) {
        return this.waitForBeliefChange(type, -1L);
    }

    public Object waitForBeliefChange(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addBelief(type);
        wa.setTimeout(timeout, this.getRPlan());
        IInternalEvent ev = (IInternalEvent)this.eventWaitFor(wa);
        SystemEvent se = (SystemEvent)ev.getParameter("cause").getValue();
        return se.getValue();
    }

    public void waitForBeliefSetChange(String type) {
        this.waitForBeliefSetChange(type, -1L);
    }

    public void waitForBeliefSetChange(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addBeliefSet(type, new String[]{"BDI_bsfactAdded", "BDI_bsfactRemoved", "BDI_bsfactsChanged"});
        wa.setTimeout(timeout, this.getRPlan());
        this.eventWaitFor(wa);
    }

    public Object waitForFactAddedOrRemoved(String type) {
        return this.waitForFactAddedOrRemoved(type, -1L);
    }

    public Object waitForFactAddedOrRemoved(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addBeliefSet(type, new String[]{"BDI_bsfactAdded", "BDI_bsfactRemoved"});
        wa.setTimeout(timeout, this.getRPlan());
        IInternalEvent ev = (IInternalEvent)this.eventWaitFor(wa);
        SystemEvent se = (SystemEvent)ev.getParameter("cause").getValue();
        return se.getValue();
    }

    public Object waitForFactAdded(String type) {
        return this.waitForFactAdded(type, -1L);
    }

    public Object waitForFactAdded(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addBeliefSet(type, new String[]{"BDI_bsfactAdded"});
        wa.setTimeout(timeout, this.getRPlan());
        IInternalEvent ev = (IInternalEvent)this.eventWaitFor(wa);
        SystemEvent se = (SystemEvent)ev.getParameter("cause").getValue();
        return se.getValue();
    }

    public Object waitForFactRemoved(String type) {
        return this.waitForFactAdded(type, -1L);
    }

    public Object waitForFactRemoved(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addBeliefSet(type, new String[]{"BDI_bsfactRemoved"});
        wa.setTimeout(timeout, this.getRPlan());
        IInternalEvent ev = (IInternalEvent)this.eventWaitFor(wa);
        SystemEvent se = (SystemEvent)ev.getParameter("cause").getValue();
        return se.getValue();
    }

    protected IEvent eventWaitFor(WaitAbstraction wa) {
        this.getCapability().checkThreadAccess();
        IEvent ret = null;
        IPlanExecutor exe = this.getRPlan().getPlanExecutor();
        IREvent event = exe.eventWaitFor(this.getRPlan(), wa);
        if (event == null) {
            throw new RuntimeException("eventWaitFor failed: " + this);
        }
        ret = EventbaseWrapper.wrap(event, this.getRPlan());
        return ret;
    }

    public IEvent waitFor(IFilter filter) {
        return this.waitFor(filter, -1L);
    }

    public IEvent waitFor(IFilter filter, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addFilter(filter);
        wa.setTimeout(timeout, this.getRPlan());
        return this.eventWaitFor(wa);
    }
}

