/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime;

import jadex.model.IMExpression;
import jadex.runtime.IFilter;
import jadex.runtime.impl.IRParameterElement;
import jadex.runtime.impl.RExpression;
import jadex.util.SReflect;
import jadex.util.collection.MultiCollection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public abstract class ParameterElementFilter
implements IFilter,
Serializable {
    protected MultiCollection values;
    protected IMExpression match;

    public void addValue(String name, Object value) {
        if (this.values == null) {
            this.values = new MultiCollection();
        }
        this.values.put(name, value);
    }

    public void setMatchExpression(IMExpression match) {
        this.match = match;
    }

    public boolean filter(Object object) throws Exception {
        boolean ret;
        if (this.values == null && this.match == null) {
            return true;
        }
        boolean bl = ret = this.values == null;
        if (object instanceof IRParameterElement) {
            IRParameterElement probj = (IRParameterElement)object;
            if (this.values != null) {
                Iterator vkeys = this.values.keySet().iterator();
                ret = true;
                while (vkeys.hasNext() && ret) {
                    String vkey = (String)vkeys.next();
                    if (!probj.hasParameter(vkey)) {
                        ret = false;
                        break;
                    }
                    Object val = probj.getParameter(vkey).getValue();
                    Object[] vals = ((Collection)this.values.get(vkey)).toArray();
                    ret = false;
                    for (int j = 0; val != null && j < vals.length && !ret; ++j) {
                        ret = vals[j].equals(val);
                    }
                }
            }
            if (ret && this.match != null) {
                try {
                    ret = (Boolean)RExpression.evaluateExpression(this.match, probj.getOriginalElement().getExpressionParameters());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ret = false;
                }
            }
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(values=[");
        if (this.values != null) {
            Object[] vkeys = this.values.getKeys();
            for (int i = 0; i < vkeys.length; ++i) {
                sb.append(vkeys[i] + " = " + this.values.get(vkeys[i]));
                if (i >= vkeys.length - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("])");
        return sb.toString();
    }
}

