/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime;

import jadex.runtime.AbstractPlan;
import jadex.runtime.ICondition;
import jadex.runtime.IEvent;
import jadex.runtime.IFilter;
import jadex.runtime.IGoal;
import jadex.runtime.IMessageEvent;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.WaitAbstraction;
import jadex.runtime.planwrapper.ConditionWrapper;
import jadex.runtime.planwrapper.GoalWrapper;
import jadex.runtime.planwrapper.MessageEventWrapper;

public abstract class MobilePlan
extends AbstractPlan {
    public abstract void action(IEvent var1);

    public void exception(Exception exception) throws Exception {
        throw exception;
    }

    public final void passed() {
    }

    public final void failed() {
    }

    public final void aborted() {
    }

    public void passed(IEvent event) {
    }

    public void failed(IEvent event) {
    }

    public void aborted(IEvent event) {
    }

    public IFilter waitFor(long duration) {
        this.getCapability().checkThreadAccess();
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.setTimeout(duration, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter waitForCondition(ICondition condition) {
        return this.waitForCondition(condition, -1L);
    }

    public IFilter waitForCondition(ICondition condition, long timeout) {
        this.getCapability().checkThreadAccess();
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addCondition(((ConditionWrapper)condition).getOriginalCondition());
        wa.setTimeout(timeout, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter waitForCondition(String condition) {
        return this.waitForCondition(condition, -1L);
    }

    public IFilter waitForCondition(String condition, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addCondition(condition);
        wa.setTimeout(timeout, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter dispatchSubgoalAndWait(IGoal subgoal) {
        return this.dispatchSubgoalAndWait(subgoal, -1L);
    }

    public IFilter dispatchSubgoalAndWait(IGoal subgoal, long timeout) {
        this.dispatchSubgoal(subgoal);
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addGoal((IRGoal)((GoalWrapper)subgoal).unwrap());
        wa.setTimeout(timeout, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter waitForInternalEvent(String type) {
        return this.waitForInternalEvent(type, -1L);
    }

    public IFilter waitForInternalEvent(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addInternalEvent(type, null);
        wa.setTimeout(timeout, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter sendMessageAndWait(IMessageEvent me) {
        return this.sendMessageAndWait(me, -1L);
    }

    public IFilter sendMessageAndWait(IMessageEvent me, long timeout) {
        this.sendMessage(me);
        return this.waitForReply(me, timeout);
    }

    public IFilter waitForMessageEvent(String type) {
        return this.waitForMessageEvent(type, -1L);
    }

    public IFilter waitForMessageEvent(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addMessageEvent(type, null);
        wa.setTimeout(timeout, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter waitForReply(IMessageEvent msgevent) {
        return this.waitForReply(msgevent, -1L);
    }

    public IFilter waitForReply(IMessageEvent msgevent, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.setTimeout(timeout, this.getRPlan());
        wa.addMessageEvent((IRMessageEvent)((MessageEventWrapper)msgevent).unwrap());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter waitForGoal(String type) {
        return this.waitForGoal(type, -1L);
    }

    public IFilter waitForGoal(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addGoal(type, null);
        wa.setTimeout(timeout, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter waitForSubgoal(IGoal goal) {
        return this.waitForSubgoal(goal, -1L);
    }

    public IFilter waitForSubgoal(IGoal goal, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addGoal((IRGoal)((GoalWrapper)goal).unwrap());
        wa.setTimeout(timeout, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter waitForBeliefChange(String type) {
        return this.waitForBeliefChange(type, -1L);
    }

    public IFilter waitForBeliefChange(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addBelief(type);
        wa.setTimeout(timeout, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter waitForBeliefSetChange(String type) {
        return this.waitForBeliefSetChange(type, -1L);
    }

    public IFilter waitForBeliefSetChange(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addBeliefSet(type, new String[]{"BDI_bsfactAdded", "BDI_bsfactRemoved", "BDI_bsfactsChanged"});
        wa.setTimeout(timeout, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter waitForFactAddedOrRemoved(String type) {
        return this.waitForFactAddedOrRemoved(type, -1L);
    }

    public IFilter waitForFactAddedOrRemoved(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addBeliefSet(type, new String[]{"BDI_bsfactAdded", "BDI_bsfactRemoved"});
        wa.setTimeout(timeout, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter waitForFactAdded(String type) {
        return this.waitForFactAdded(type, -1L);
    }

    public IFilter waitForFactAdded(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addBeliefSet(type, new String[]{"BDI_bsfactAdded"});
        wa.setTimeout(timeout, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter waitForFactRemoved(String type) {
        return this.waitForFactAdded(type, -1L);
    }

    public IFilter waitForFactRemoved(String type, long timeout) {
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addBeliefSet(type, new String[]{"BDI_bsfactRemoved"});
        wa.setTimeout(timeout, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }

    public IFilter waitFor(IFilter filter) {
        return this.waitFor(filter, -1L);
    }

    public IFilter waitFor(IFilter filter, long timeout) {
        this.getCapability().checkThreadAccess();
        WaitAbstraction wa = new WaitAbstraction(this.getRCapability());
        wa.addFilter(filter);
        wa.setTimeout(timeout, this.getRPlan());
        return this.getRPlan().waitFor(wa);
    }
}

