/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime;

import jadex.model.IMCapability;
import jadex.model.IMPlan;
import jadex.model.IMPlanBody;
import jadex.runtime.AbstractPlan;
import jadex.runtime.IPlanExecutor;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.RBDIAgent;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.WaitAbstraction;
import jadex.util.collection.SCollection;
import jadex.util.concurrent.ThreadPoolFactory;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;

public class JavaStandardPlanExecutor
implements IPlanExecutor,
Serializable {
    public static final String MAX_PLANSTEP_TIME = "max_planstep_time";
    protected RBDIAgent agent;
    protected Number maxexetime;
    protected Map tasks;
    protected transient Map planbodies;
    public static int n;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JavaStandardPlanExecutor(RBDIAgent agent) {
        this.agent = agent;
        this.tasks = SCollection.createHashMap();
    }

    public Object createPlanBody(RPlan plan) throws Exception {
        Class tmp;
        String refname = "" + Thread.currentThread() + "_" + Thread.currentThread().hashCode();
        AbstractPlan.planinit.put(refname, plan);
        IMPlanBody bodyexp = ((IMPlan)plan.getModelElement()).getBody();
        Object body = null;
        Class clazz = tmp = this.planbodies == null ? null : (Class)this.planbodies.get(plan.getModelElement());
        if (tmp != null) {
            body = tmp.newInstance();
        } else if (bodyexp.isInline()) {
            String aborted;
            String failed;
            IMCapability mscope = (IMCapability)plan.getScope().getModelElement();
            StringBuffer sb = new StringBuffer("public void body(){");
            sb.append(bodyexp.getExpressionText());
            sb.append("}");
            String passed = bodyexp.getPassedCode();
            if (passed != null && passed.length() != 0) {
                sb.append("public void passed(){");
                sb.append(passed);
                sb.append("}");
            }
            if ((failed = bodyexp.getFailedCode()) != null && failed.length() != 0) {
                sb.append("public void failed(){");
                sb.append(failed);
                sb.append("}");
            }
            if ((aborted = bodyexp.getAbortedCode()) != null && aborted.length() != 0) {
                sb.append("public void aborted(){");
                sb.append(aborted);
                sb.append("}");
            }
            body = mscope.getParser().parseClass(sb.toString(), Plan.class);
            if (this.planbodies == null) {
                this.planbodies = SCollection.createWeakHashMap();
            }
            this.planbodies.put(plan.getModelElement(), body.getClass());
        } else {
            body = plan.getScope().getExpressionbase().evaluateInternalExpression(bodyexp, plan);
        }
        AbstractPlan.planinit.remove(refname);
        if (body == null) {
            throw new RuntimeException("Plan body could not be created: " + bodyexp.getExpressionText());
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeStep(RPlan plan, String steptype) throws Exception {
        Object monitor;
        boolean newthread = false;
        PlanExecutionTask task = (PlanExecutionTask)this.tasks.get(plan);
        if (task == null) {
            task = new PlanExecutionTask(plan);
            this.tasks.put(plan, task);
            newthread = true;
        }
        Object object = monitor = task.getMonitor();
        synchronized (object) {
            task.setStepType(steptype);
            task.setState("running");
            if (newthread) {
                ThreadPoolFactory.getThreadPool().execute(task);
            } else {
                monitor.notify();
            }
            if (!$assertionsDisabled && !this.agent.getInterpreter().agent_executing) {
                throw new AssertionError(this);
            }
            if (!$assertionsDisabled && this.agent.getInterpreter().plan_executing1) {
                throw new AssertionError(this);
            }
            if (!$assertionsDisabled && this.agent.getInterpreter().plan_executing2) {
                throw new AssertionError(this);
            }
            this.agent.getInterpreter().plan_executing1 = true;
            try {
                if (this.getMaxExecutionTime() == 0L) {
                    monitor.wait();
                } else {
                    monitor.wait(this.getMaxExecutionTime());
                }
            }
            catch (InterruptedException e) {
                System.err.println("Warning, agent thread was interrupted");
                e.printStackTrace(System.err);
            }
            if (!$assertionsDisabled && !this.agent.getInterpreter().agent_executing) {
                throw new AssertionError(this);
            }
            if (!$assertionsDisabled && !this.agent.getInterpreter().plan_executing1) {
                throw new AssertionError(this);
            }
            if (!$assertionsDisabled && this.agent.getInterpreter().plan_executing2) {
                throw new AssertionError(this);
            }
            this.agent.getInterpreter().plan_executing1 = false;
            if ("running".equals(task.getState())) {
                this.agent.getLogger().warning(" plan step is running longer than maximum execution time, plan will be terminated: " + this.agent + " " + task);
                task.getPlan().getRootGoal().fail(null);
            }
            if (task.getThrowable() instanceof Error) {
                throw (Error)task.getThrowable();
            }
            if (task.getThrowable() instanceof Exception) {
                throw (Exception)task.getThrowable();
            }
            if (task.getThrowable() != null) {
                throw new RuntimeException("Unexpected Throwable type: " + task.getThrowable().getClass(), task.getThrowable());
            }
        }
        return task.getState().equals("interrupted");
    }

    public boolean executePlanStep(RPlan plan) throws Exception {
        return this.executeStep(plan, "body");
    }

    public boolean executePassedStep(RPlan plan) throws Exception {
        return this.executeStep(plan, "passed");
    }

    public boolean executeFailedStep(RPlan plan) throws Exception {
        return this.executeStep(plan, "failed");
    }

    public boolean executeAbortedStep(RPlan plan) throws Exception {
        return this.executeStep(plan, "aborted");
    }

    public void interruptPlanStep(RPlan plan) {
        PlanExecutionTask task = (PlanExecutionTask)this.tasks.get(plan);
        if (!$assertionsDisabled && task.getExecutionThread() != Thread.currentThread()) {
            throw new AssertionError((Object)(plan + ", " + Thread.currentThread()));
        }
        task.giveBackControl("interrupted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(RPlan rplan) {
        PlanExecutionTask task = (PlanExecutionTask)this.tasks.get(rplan);
        if (task != null) {
            Object monitor;
            Object object = monitor = task.getMonitor();
            synchronized (object) {
                task.setState("running");
                task.setTerminate(true);
                monitor.notify();
                if (!$assertionsDisabled && !this.agent.getInterpreter().agent_executing) {
                    throw new AssertionError(this);
                }
                if (!$assertionsDisabled && this.agent.getInterpreter().plan_executing1) {
                    throw new AssertionError(this);
                }
                if (!$assertionsDisabled && this.agent.getInterpreter().plan_executing2) {
                    throw new AssertionError(this);
                }
                this.agent.getInterpreter().plan_executing1 = true;
                try {
                    if (this.getMaxExecutionTime() == 0L) {
                        monitor.wait();
                    } else {
                        monitor.wait(this.getMaxExecutionTime());
                    }
                }
                catch (InterruptedException e) {
                    System.err.println("Warning, agent thread was interrupted");
                    e.printStackTrace(System.err);
                }
                if (!$assertionsDisabled && !this.agent.getInterpreter().agent_executing) {
                    throw new AssertionError(this);
                }
                if (!$assertionsDisabled && !this.agent.getInterpreter().plan_executing1) {
                    throw new AssertionError(this);
                }
                if (!$assertionsDisabled && this.agent.getInterpreter().plan_executing2) {
                    throw new AssertionError(this);
                }
                this.agent.getInterpreter().plan_executing1 = false;
                if ("running".equals(task.getState())) {
                    this.agent.getLogger().warning(" plan step is running longer than maximum execution time, plan will be terminated: " + this.agent + " " + task);
                    task.getPlan().getRootGoal().fail(null);
                }
            }
        }
    }

    public Thread getExecutionThread(RPlan rplan) {
        PlanExecutionTask task = (PlanExecutionTask)this.tasks.get(rplan);
        return task == null ? null : task.getExecutionThread();
    }

    public IREvent eventWaitFor(RPlan rplan, WaitAbstraction wa) {
        if (this.agent.isAtomic()) {
            throw new RuntimeException("WaitFor not allowed in atomic block.");
        }
        AbstractPlan body = (AbstractPlan)rplan.getBody();
        if (body == null) {
            throw new RuntimeException("Plan body null. waitFor() calls from plan constructors not allowed.");
        }
        rplan.waitFor(wa);
        IREvent ret = null;
        boolean failure = false;
        PlanExecutionTask task = (PlanExecutionTask)this.tasks.get(rplan);
        if (task.getExecutionThread() == Thread.currentThread()) {
            task.giveBackControl("waiting");
            ret = rplan.getLatestEvent();
            if (ret != null && "InternalEvent_timeout".equals(ret.getType()) && ret.getParameter("exception").getValue() != null) {
                throw (TimeoutException)ret.getParameter("exception").getValue();
            }
        } else {
            failure = true;
        }
        if (failure) {
            this.agent.getLogger().log(Level.SEVERE, "ThreadedWaitFor error, not plan thread: " + Thread.currentThread());
        }
        if (!$assertionsDisabled && ret == null) {
            throw new AssertionError((Object)rplan.getName());
        }
        return ret;
    }

    protected long getMaxExecutionTime() {
        if (this.maxexetime == null) {
            this.maxexetime = (Number)this.agent.getPropertybase().getProperty(MAX_PLANSTEP_TIME);
            if (this.maxexetime == null) {
                this.maxexetime = new Long(0L);
            }
        }
        return this.maxexetime.longValue();
    }

    static {
        $assertionsDisabled = !JavaStandardPlanExecutor.class.desiredAssertionStatus();
    }

    public static class PlanTerminated
    extends ThreadDeath {
    }

    public static class BodyAborted
    extends ThreadDeath {
    }

    protected class PlanExecutionTask
    implements Runnable {
        public static final String STATE_RUNNING = "running";
        public static final String STATE_WAITING = "waiting";
        public static final String STATE_INTERRUPTED = "interrupted";
        public static final String STATE_TERMINATED = "terminated";
        protected RPlan rplan;
        protected final Object monitor;
        protected String state;
        protected String steptype;
        protected Throwable throwable;
        protected Thread thread;
        protected boolean terminate;
        static final /* synthetic */ boolean $assertionsDisabled;

        public PlanExecutionTask(RPlan rplan) {
            this.rplan = rplan;
            this.monitor = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.monitor;
            synchronized (object) {
                if (!$assertionsDisabled && !JavaStandardPlanExecutor.this.agent.getInterpreter().agent_executing) {
                    throw new AssertionError(this);
                }
                if (!$assertionsDisabled && !JavaStandardPlanExecutor.this.agent.getInterpreter().plan_executing1) {
                    throw new AssertionError(this);
                }
                if (!$assertionsDisabled && JavaStandardPlanExecutor.this.agent.getInterpreter().plan_executing2) {
                    throw new AssertionError(this);
                }
                JavaStandardPlanExecutor.this.agent.getInterpreter().plan_executing2 = true;
            }
            this.thread = Thread.currentThread();
            Plan pi = null;
            boolean aborted = false;
            boolean interrupted = false;
            try {
                if (!$assertionsDisabled && !this.steptype.equals("body")) {
                    throw new AssertionError((Object)(this.steptype + ", " + this.rplan));
                }
                if (!$assertionsDisabled && !this.rplan.getState().equals("body")) {
                    throw new AssertionError((Object)(this.rplan.getState() + ", " + this.rplan));
                }
                Object tmp = this.rplan.getBody();
                if (tmp == null) {
                    tmp = this.rplan.createBody();
                }
                if (!(tmp instanceof Plan)) {
                    throw new RuntimeException("User plan has wrong baseclass. Expected jadex.runtime.Plan for standard plan.");
                }
                pi = (Plan)tmp;
                pi.body();
            }
            catch (BodyAborted e) {
                aborted = true;
            }
            catch (PlanTerminated e) {
                interrupted = true;
            }
            catch (Throwable t) {
                this.throwable = t;
            }
            if (!interrupted) {
                if (!aborted) {
                    if (!JavaStandardPlanExecutor.this.agent.getInterpreter().agent_executing) {
                        return;
                    }
                    this.giveBackControl(STATE_WAITING);
                }
                if (!($assertionsDisabled || this.steptype.equals("passed") || this.steptype.equals("failed") || this.steptype.equals("aborted"))) {
                    throw new AssertionError((Object)(this.steptype + ", " + this.rplan));
                }
                this.throwable = null;
                try {
                    if (this.steptype.equals("passed")) {
                        pi.passed();
                    } else if (this.steptype.equals("failed")) {
                        pi.failed();
                    } else if (this.steptype.equals("aborted")) {
                        pi.aborted();
                    }
                }
                catch (PlanTerminated e) {
                }
                catch (Throwable t) {
                    this.throwable = t;
                }
            }
            JavaStandardPlanExecutor.this.tasks.remove(this.rplan);
            this.state = STATE_TERMINATED;
            Object object2 = this.monitor;
            synchronized (object2) {
                if (!JavaStandardPlanExecutor.this.agent.getInterpreter().agent_executing) {
                    return;
                }
                if (!$assertionsDisabled && !JavaStandardPlanExecutor.this.agent.getInterpreter().agent_executing) {
                    throw new AssertionError(this);
                }
                if (!$assertionsDisabled && !JavaStandardPlanExecutor.this.agent.getInterpreter().plan_executing1) {
                    throw new AssertionError(this);
                }
                if (!$assertionsDisabled && !JavaStandardPlanExecutor.this.agent.getInterpreter().plan_executing2) {
                    throw new AssertionError((Object)(this + ", " + interrupted + ", " + aborted));
                }
                JavaStandardPlanExecutor.this.agent.getInterpreter().plan_executing2 = false;
                this.monitor.notify();
            }
        }

        public Object getMonitor() {
            return this.monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void giveBackControl(String state) {
            Object object = this.monitor;
            synchronized (object) {
                if (!$assertionsDisabled && !this.rplan.isAlive()) {
                    throw new AssertionError(this.rplan);
                }
                String planstate = this.steptype;
                if (!$assertionsDisabled && !JavaStandardPlanExecutor.this.agent.getInterpreter().agent_executing) {
                    throw new AssertionError(this);
                }
                if (!$assertionsDisabled && !JavaStandardPlanExecutor.this.agent.getInterpreter().plan_executing1) {
                    throw new AssertionError(this);
                }
                if (!$assertionsDisabled && !JavaStandardPlanExecutor.this.agent.getInterpreter().plan_executing2) {
                    throw new AssertionError(this);
                }
                JavaStandardPlanExecutor.this.agent.getInterpreter().plan_executing2 = false;
                this.state = state;
                this.monitor.notify();
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException e) {
                    System.err.println("Warning, plan thread was interrupted: " + this.rplan);
                    e.printStackTrace(System.err);
                }
                if (!$assertionsDisabled && !JavaStandardPlanExecutor.this.agent.getInterpreter().agent_executing) {
                    throw new AssertionError(this);
                }
                if (!$assertionsDisabled && !JavaStandardPlanExecutor.this.agent.getInterpreter().plan_executing1) {
                    throw new AssertionError(this);
                }
                if (!$assertionsDisabled && JavaStandardPlanExecutor.this.agent.getInterpreter().plan_executing2) {
                    throw new AssertionError(this);
                }
                JavaStandardPlanExecutor.this.agent.getInterpreter().plan_executing2 = true;
                if (this.terminate) {
                    throw new PlanTerminated();
                }
                if (planstate.equals("body") && this.rplan.getState().equals("aborted")) {
                    throw new BodyAborted();
                }
            }
        }

        public RPlan getPlan() {
            return this.rplan;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public void setStepType(String type) {
            this.steptype = type;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public Thread getExecutionThread() {
            return this.thread;
        }

        public void setTerminate(boolean terminate) {
            this.terminate = terminate;
        }

        public String toString() {
            return "PlanExecutionTask(" + this.rplan + ")";
        }

        static {
            $assertionsDisabled = !(class$jadex$runtime$JavaStandardPlanExecutor == null ? (class$jadex$runtime$JavaStandardPlanExecutor = JavaStandardPlanExecutor.class$("jadex.runtime.JavaStandardPlanExecutor")) : class$jadex$runtime$JavaStandardPlanExecutor).desiredAssertionStatus();
        }
    }
}

