/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime;

import jadex.model.IMCapability;
import jadex.model.IMPlan;
import jadex.model.IMPlanBody;
import jadex.runtime.AbstractPlan;
import jadex.runtime.BDIFailureException;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IEvent;
import jadex.runtime.IGoal;
import jadex.runtime.IPlanExecutor;
import jadex.runtime.MobilePlan;
import jadex.runtime.impl.IREvent;
import jadex.runtime.impl.IRGoalEvent;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.WaitAbstraction;
import jadex.runtime.planwrapper.EventbaseWrapper;
import jadex.runtime.planwrapper.GoalWrapper;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.Map;

public class JavaMobilePlanExecutor
implements IPlanExecutor,
Serializable {
    protected transient Thread thread;
    protected transient Map planbodies;

    public Object createPlanBody(RPlan plan) throws Exception {
        Class tmp;
        String refname = "" + Thread.currentThread() + "_" + Thread.currentThread().hashCode();
        AbstractPlan.planinit.put(refname, plan);
        IMPlanBody bodyexp = ((IMPlan)plan.getModelElement()).getBody();
        Object body = null;
        Class clazz = tmp = this.planbodies == null ? null : (Class)this.planbodies.get(plan.getModelElement());
        if (tmp != null) {
            body = tmp.newInstance();
        } else if (bodyexp.isInline()) {
            String aborted;
            String failed;
            IMCapability mscope = (IMCapability)plan.getScope().getModelElement();
            StringBuffer sb = new StringBuffer("public void action(jadex.runtime.IEvent event){");
            sb.append(bodyexp.getExpressionText());
            sb.append("}");
            String passed = bodyexp.getPassedCode();
            if (passed != null && passed.length() != 0) {
                sb.append("public void passed(){");
                sb.append(passed);
                sb.append("}");
            }
            if ((failed = bodyexp.getFailedCode()) != null && failed.length() != 0) {
                sb.append("public void failed(){");
                sb.append(failed);
                sb.append("}");
            }
            if ((aborted = bodyexp.getAbortedCode()) != null && aborted.length() != 0) {
                sb.append("public void aborted(){");
                sb.append(aborted);
                sb.append("}");
            }
            body = mscope.getParser().parseClass(sb.toString(), MobilePlan.class);
            if (this.planbodies == null) {
                this.planbodies = SCollection.createWeakHashMap();
            }
            this.planbodies.put(plan.getModelElement(), body.getClass());
        } else {
            body = plan.getScope().getExpressionbase().evaluateInternalExpression(bodyexp, plan);
        }
        if (body == null) {
            throw new RuntimeException("Plan body could not be created: " + bodyexp.getExpressionText());
        }
        AbstractPlan.planinit.remove(refname);
        return body;
    }

    protected boolean executeStep(RPlan plan, String type) throws Exception {
        IRGoalEvent ge;
        this.thread = Thread.currentThread();
        Object tmp = plan.getBody();
        if (tmp == null) {
            tmp = plan.createBody();
        }
        if (!(tmp instanceof MobilePlan)) {
            throw new RuntimeException("Mobile plan body not of type MobilePlan.");
        }
        MobilePlan pi = (MobilePlan)tmp;
        BDIFailureException exe = null;
        IREvent oevent = plan.getLatestEvent();
        if (oevent != null && "InternalEvent_timeout".equals(oevent.getType())) {
            exe = (BDIFailureException)oevent.getParameter("exception").getValue();
        } else if (oevent instanceof IRGoalEvent && (ge = (IRGoalEvent)oevent).isInfo() && ge.getGoal().isFailed() && ge.getGoal().isSubgoal()) {
            exe = new GoalFailureException((IGoal)new GoalWrapper(ge.getGoal(), plan), (Throwable)ge.getGoal().getException());
        }
        if (exe != null) {
            pi.exception(exe);
        } else {
            IEvent event;
            IEvent iEvent = event = oevent != null ? EventbaseWrapper.wrap(oevent, plan) : null;
            if (type.equals("body")) {
                pi.action(event);
            } else if (type.equals("passed")) {
                pi.passed(event);
            } else if (type.equals("failed")) {
                pi.failed(event);
            } else if (type.equals("aborted")) {
                pi.aborted(event);
            }
        }
        this.thread = null;
        return false;
    }

    public boolean executePlanStep(RPlan plan) throws Exception {
        return this.executeStep(plan, "body");
    }

    public boolean executePassedStep(RPlan plan) throws Exception {
        return this.executeStep(plan, "passed");
    }

    public boolean executeFailedStep(RPlan plan) throws Exception {
        return this.executeStep(plan, "failed");
    }

    public boolean executeAbortedStep(RPlan plan) throws Exception {
        return this.executeStep(plan, "aborted");
    }

    public void interruptPlanStep(RPlan plan) {
    }

    public void cleanup(RPlan rplan) {
    }

    public Thread getExecutionThread(RPlan rplan) {
        return this.thread;
    }

    public IREvent eventWaitFor(RPlan rplan, WaitAbstraction wa) {
        throw new UnsupportedOperationException("eventWaitFor not possible for mobile plans.");
    }
}

