/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime;

import jadex.runtime.IFilter;
import jadex.runtime.impl.IEncodable;
import jadex.util.SReflect;
import jadex.util.SUtil;
import jadex.util.collection.IndexMap;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.Map;

public class ComposedFilter
implements IFilter,
IEncodable,
Serializable {
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int NOT = 3;
    protected IFilter[] filters;
    protected int operator;

    public ComposedFilter(IFilter[] filters, int operator) {
        this.filters = filters;
        this.operator = operator;
    }

    public boolean filter(Object object) throws Exception {
        boolean ret = false;
        if (this.operator == 1) {
            ret = true;
            for (int i = 0; i < this.filters.length && ret; ++i) {
                ret = ret && this.filters[i].filter(object);
            }
        } else if (this.operator == 2) {
            Exception exception = null;
            for (int i = 0; i < this.filters.length && !ret; ++i) {
                try {
                    ret = ret || this.filters[i].filter(object);
                    continue;
                }
                catch (Exception e) {
                    exception = exception != null ? exception : e;
                }
            }
            if (!ret && exception != null) {
                throw exception;
            }
        } else if (this.operator == 3) {
            ret = !this.filters[0].filter(object);
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(operator=");
        sb.append(ComposedFilter.operatorToString(this.operator));
        sb.append(", filters=");
        sb.append(SUtil.arrayToString(this.filters));
        sb.append(")");
        return sb.toString();
    }

    public static String operatorToString(int operator) {
        switch (operator) {
            case 1: {
                return "AND";
            }
            case 2: {
                return "OR";
            }
            case 3: {
                return "NOT";
            }
        }
        throw new RuntimeException("Unknown operator: " + operator);
    }

    public Map getEncodableRepresentation() {
        IndexMap representation = SCollection.createIndexMap();
        representation.add("isencodeablepresentation", (Object)"true");
        representation.add("class", (Object)"ComposedFilter");
        representation.add("operator", (Object)ComposedFilter.operatorToString(this.operator));
        representation.add("filters", (Object)SUtil.arrayToString(this.filters));
        return representation.getAsMap();
    }
}

