/*
 * Decompiled with CFR 0.152.
 */
package jadex.runtime;

import jadex.runtime.BasicAgentIdentifier;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IBeliefbase;
import jadex.runtime.ICapability;
import jadex.runtime.ICondition;
import jadex.runtime.IEventbase;
import jadex.runtime.IExpression;
import jadex.runtime.IExpressionbase;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IFilter;
import jadex.runtime.IGoal;
import jadex.runtime.IGoalbase;
import jadex.runtime.IInternalEvent;
import jadex.runtime.IMessageEvent;
import jadex.runtime.IParameter;
import jadex.runtime.IParameterSet;
import jadex.runtime.IPlanListener;
import jadex.runtime.IPlanbase;
import jadex.runtime.IProcessGoal;
import jadex.runtime.IPropertybase;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.IWaitqueue;
import jadex.runtime.PlanFailureException;
import jadex.runtime.impl.AsynchronousSystemEventListener;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.SystemEventFilter;
import jadex.runtime.planwrapper.CapabilityWrapper;
import jadex.runtime.planwrapper.GoalWrapper;
import jadex.runtime.planwrapper.PlanWrapper;
import jadex.runtime.planwrapper.ProcessGoalWrapper;
import jadex.runtime.planwrapper.WaitqueueWrapper;
import jadex.util.SReflect;
import jadex.util.Tuple;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;

public abstract class AbstractPlan
implements Serializable {
    private RPlan rplan;
    private PlanWrapper plan;
    private CapabilityWrapper capability;
    private ProcessGoalWrapper rootgoal;
    private WaitqueueWrapper waitqueue;
    private Exception exception;
    static Map planinit = SCollection.createHashtable();

    public AbstractPlan() {
        String myadr = "" + Thread.currentThread() + "_" + Thread.currentThread().hashCode();
        this.rplan = (RPlan)planinit.get(myadr);
        if (this.rplan == null) {
            throw new RuntimeException("Plan could not be inited: " + myadr + " - " + this.rplan);
        }
        this.plan = new PlanWrapper(this.rplan, this.rplan);
        this.capability = new CapabilityWrapper(this.rplan.getScope(), this.rplan);
    }

    public void fail() {
        this.capability.checkThreadAccess();
        throw new PlanFailureException();
    }

    public void fail(Throwable cause) {
        this.capability.checkThreadAccess();
        throw new PlanFailureException(null, cause);
    }

    public void fail(String message, Throwable cause) {
        this.capability.checkThreadAccess();
        throw new PlanFailureException(message, cause);
    }

    public ICapability getScope() {
        this.capability.checkThreadAccess();
        return this.capability;
    }

    public Logger getLogger() {
        this.capability.checkThreadAccess();
        return this.rplan.getScope().getLogger();
    }

    public void startAtomic() {
        this.capability.checkThreadAccess();
        this.rplan.startMonitorConsequences();
        this.rplan.getScope().getAgent().startAtomic();
    }

    public void endAtomic() {
        this.capability.checkThreadAccess();
        this.rplan.getScope().getAgent().endAtomic();
        this.rplan.endMonitorConsequences();
    }

    public IFilter dispatchSubgoal(IGoal subgoal) {
        this.capability.checkThreadAccess();
        this.rplan.startMonitorConsequences();
        try {
            IRGoal original = (IRGoal)((GoalWrapper)subgoal).unwrap();
            IFilter iFilter = this.rplan.getScope().getGoalbase().dispatchSubgoal(this.rplan.getRootGoal(), original);
            return iFilter;
        }
        catch (GoalFailureException gfe) {
            gfe.setGoal(subgoal);
            throw gfe;
        }
        finally {
            this.rplan.endMonitorConsequences();
        }
    }

    public String getName() {
        return this.rplan.getName();
    }

    public IProcessGoal getRootGoal() {
        this.capability.checkThreadAccess();
        if (this.rootgoal == null) {
            this.rootgoal = new ProcessGoalWrapper(this.rplan.getRootGoal(), this.rplan);
        }
        return this.rootgoal;
    }

    public IWaitqueue getWaitqueue() {
        if (this.waitqueue == null) {
            this.waitqueue = new WaitqueueWrapper(this.rplan.getWaitqueue(), this.rplan);
        }
        return this.waitqueue;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(SReflect.getInnerClassName(this.getClass()));
        buf.append("(name=");
        buf.append(this.getName());
        buf.append(")");
        return buf.toString();
    }

    public String getAgentName() {
        return this.capability.getAgentName();
    }

    public BasicAgentIdentifier getAgentIdentifier() {
        return this.capability.getAgentIdentifier();
    }

    public boolean isAbortedOnSuccess() {
        return this.getRootGoal().isAbortedOnSuccess();
    }

    public Exception getException() {
        return this.rplan.getException();
    }

    public void killAgent() {
        this.capability.killAgent();
    }

    public IBeliefbase getBeliefbase() {
        return this.capability.getBeliefbase();
    }

    public IGoalbase getGoalbase() {
        return this.capability.getGoalbase();
    }

    public IPlanbase getPlanbase() {
        return this.capability.getPlanbase();
    }

    public IEventbase getEventbase() {
        return this.capability.getEventbase();
    }

    public IExpressionbase getExpressionbase() {
        return this.capability.getExpressionbase();
    }

    public IPropertybase getPropertybase() {
        return this.capability.getPropertybase();
    }

    public void dispatchTopLevelGoal(IGoal goal) {
        this.capability.getGoalbase().dispatchTopLevelGoal(goal);
    }

    public IGoal createGoal(String type) {
        return this.capability.getGoalbase().createGoal(type);
    }

    public IFilter sendMessage(IMessageEvent me) {
        return this.capability.getEventbase().sendMessage(me);
    }

    public void dispatchInternalEvent(IInternalEvent event) {
        this.capability.getEventbase().dispatchInternalEvent(event);
    }

    public IMessageEvent createMessageEvent(String type) {
        return this.capability.getEventbase().createMessageEvent(type);
    }

    public IInternalEvent createInternalEvent(String type) {
        return this.capability.getEventbase().createInternalEvent(type);
    }

    public IInternalEvent createInternalEvent(String type, Object content) {
        return this.capability.getEventbase().createInternalEvent(type, content);
    }

    public IExternalAccess getExternalAccess() {
        return this.capability.getExternalAccess();
    }

    public IExpression getQuery(String name) {
        return this.getExpression(name);
    }

    public IExpression getExpression(String name) {
        return this.capability.getExpressionbase().getExpression(name);
    }

    public ICondition getCondition(String name) {
        return this.capability.getExpressionbase().getCondition(name);
    }

    public IExpression createQuery(String query) {
        return this.createExpression(query);
    }

    public IExpression createExpression(String expression) {
        return this.capability.getExpressionbase().createExpression(expression);
    }

    public IExpression createExpression(String expression, String[] paramnames, Class[] paramtypes) {
        return this.capability.getExpressionbase().createExpression(expression, paramnames, paramtypes);
    }

    public ICondition createCondition(String expression) {
        return this.createCondition(expression, "changes_to_true", null, null);
    }

    public ICondition createCondition(String expression, String trigger, String[] paramnames, Class[] paramtypes) {
        return this.capability.getExpressionbase().createCondition(expression, trigger, paramnames, paramtypes);
    }

    public IParameter[] getParameters() {
        return this.plan.getParameters();
    }

    public IParameterSet[] getParameterSets() {
        return this.plan.getParameterSets();
    }

    public IParameter getParameter(String name) {
        return this.plan.getParameter(name);
    }

    public IParameterSet getParameterSet(String name) {
        return this.plan.getParameterSet(name);
    }

    public boolean hasParameter(String name) {
        return this.plan.hasParameter(name);
    }

    public boolean hasParameterSet(String name) {
        return this.plan.hasParameterSet(name);
    }

    public RPlan getRPlan() {
        return this.rplan;
    }

    protected RCapability getRCapability() {
        return this.rplan.getScope();
    }

    protected CapabilityWrapper getCapability() {
        return this.capability;
    }

    public void addPlanListener(IPlanListener userlistener, boolean async) {
        SystemEventFilter filter = new SystemEventFilter(new String[]{"BDI_planAdded", "BDI_planRemoved"}, this.getRPlan());
        AsynchronousSystemEventListener listener = new AsynchronousSystemEventListener(userlistener, new Tuple(userlistener, this));
        this.getRCapability().getAgent().addSystemEventListener(listener, filter, true, async);
    }

    public void removePlanListener(IPlanListener userlistener) {
        Tuple identifier = new Tuple(userlistener, this);
        ISystemEventListener[] listeners = this.getRCapability().getAgent().getSystemEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof AsynchronousSystemEventListener) || !((AsynchronousSystemEventListener)listeners[i]).getIdentifier().equals(identifier)) continue;
            this.getRCapability().getAgent().removeSystemEventListener(listeners[i]);
            break;
        }
    }
}

