/*
 * Decompiled with CFR 0.152.
 */
package jadex.planlib;

import jadex.planlib.ISelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class Selector
implements ISelector {
    public static final int ALL = -1;
    public static final int ONE = 1;
    protected Comparator comp;
    protected int max_winners;

    public Selector() {
        this(null, 1);
    }

    public Selector(Comparator comp) {
        this(comp, 1);
    }

    public Selector(int max_winners) {
        this(null, max_winners);
    }

    public Selector(Comparator comp, int max_winners) {
        this.comp = comp;
        this.max_winners = max_winners;
    }

    public Object[] select(Object[] proposals) {
        Object[] acc_proposals = this.determineAcceptableProposals(proposals);
        this.sortProposals(acc_proposals);
        Object[] win_proposals = this.determineWinners(acc_proposals);
        return new Object[]{acc_proposals, win_proposals};
    }

    protected Object[] determineAcceptableProposals(Object[] proposals) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < proposals.length; ++i) {
            if (!this.isAcceptable(proposals[i])) continue;
            ret.add(proposals[i]);
        }
        return ret.toArray();
    }

    protected void sortProposals(Object[] proposals) {
        if (proposals.length > 1) {
            if (this.comp != null) {
                Arrays.sort(proposals, this.comp);
            } else if (proposals[0] instanceof Comparable) {
                Arrays.sort(proposals);
            }
        }
    }

    protected Object[] determineWinners(Object[] proposals) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < proposals.length; ++i) {
            if (this.max_winners != -1 && this.max_winners <= i) continue;
            ret.add(proposals[i]);
        }
        return ret.toArray();
    }

    public boolean isAcceptable(Object proposal) {
        return true;
    }
}

