/*
 * Decompiled with CFR 0.152.
 */
package jadex.planlib;

import jadex.runtime.IMessageEvent;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import jadex.util.SUtil;

public class RPInitiatorPlan
extends Plan {
    protected static final String STATUS_TIMEOUT = "timeout";
    protected long timeout = this.hasParameter("timeout") && this.getParameter("timeout").getValue() != null ? (Long)this.getParameter("timeout").getValue() : (this.getBeliefbase().containsBelief("timeout") && this.getBeliefbase().getBelief("timeout").getFact() != null ? (Long)this.getBeliefbase().getBelief("timeout").getFact() : -1L);
    protected IMessageEvent request;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void body() {
        this.getLogger().info("Request initiator action called: " + this + " " + this.getAgentName());
        this.request = this.createMessageEvent("rp_request");
        this.request.setContent(this.getParameter("content").getValue());
        this.request.getParameterSet("receivers").addValue(this.getParameter("receiver").getValue());
        if (this.getParameter("language").getValue() != null) {
            this.request.getParameter("language").setValue(this.getParameter("language").getValue());
        }
        if (this.getParameter("ontology").getValue() != null) {
            this.request.getParameter("ontology").setValue(this.getParameter("ontology").getValue());
        }
        try {
            this.getWaitqueue().addReply(this.request);
            IMessageEvent event = this.sendMessageAndWait(this.request, this.timeout);
            event = this.handleFirstAnswer(event);
            this.handleSecondAnswer(event);
        }
        catch (TimeoutException e) {
            this.requestFinished(false, STATUS_TIMEOUT);
        }
    }

    protected IMessageEvent handleFirstAnswer(IMessageEvent answer) {
        IMessageEvent ret = null;
        this.getLogger().info("First answer: " + answer + " " + this);
        if (answer.getType().equals("rp_not_understood") || answer.getType().equals("rp_refuse") || answer.getType().equals("rp_failure")) {
            Object content = answer.getContent();
            this.getLogger().info(this.getScope().getName() + ": Received" + answer.getType() + content);
            this.requestFinished(false, new Object[]{answer.getType(), content});
        } else if (answer.getType().equals("rp_agree")) {
            this.getLogger().info(this.getScope().getName() + ": Received agree.");
            try {
                ret = this.waitForReply(this.request, this.timeout);
            }
            catch (TimeoutException e) {
                this.requestFinished(false, STATUS_TIMEOUT);
            }
        } else if (answer.getType().equals("rp_inform_done")) {
            ret = answer;
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"State should not be reached");
        }
        return ret;
    }

    protected void handleSecondAnswer(IMessageEvent answer) {
        this.getLogger().info("Second answer: " + answer + " " + this);
        if (answer.getType().equals("rp_failure")) {
            Object content = answer.getContent();
            this.getLogger().info(this.getScope().getName() + ": Received failure: " + content);
            this.requestFinished(false, new Object[]{answer.getType(), content});
        } else if (answer.getType().equals("rp_inform_done")) {
            Object content = answer.getContent();
            this.getLogger().info(this.getScope().getName() + ": Request succeeded.");
            this.requestFinished(true, content);
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)"State should not be reached");
        }
    }

    protected void requestFinished(boolean success, Object result) {
        this.getLogger().info("Request finished with: " + success + " " + SUtil.arrayToString(result) + " " + this + " " + this.getAgentName());
        this.getParameter("result").setValue(result);
        if (!success) {
            this.fail();
        }
    }

    static {
        $assertionsDisabled = !RPInitiatorPlan.class.desiredAssertionStatus();
    }
}

