/*
 * Decompiled with CFR 0.152.
 */
package jadex.planlib;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.runtime.ComposedFilter;
import jadex.runtime.IEvent;
import jadex.runtime.IFilter;
import jadex.runtime.IGoalEvent;
import jadex.runtime.IMessageEvent;
import jadex.runtime.MessageEventFilter;
import jadex.runtime.MobilePlan;

public class RPInitiatorMobilePlan
extends MobilePlan {
    protected long timeout = this.hasParameter("timeout") && this.getParameter("timeout").getValue() != null ? (Long)this.getParameter("timeout").getValue() : (this.getBeliefbase().containsBelief("timeout") && this.getBeliefbase().getBelief("timeout").getFact() != null ? (Long)this.getBeliefbase().getBelief("timeout").getFact() : -1L);
    protected AgentIdentifier receiver = (AgentIdentifier)this.getParameter("receiver").getValue();
    protected Object content = this.getParameter("content").getValue();
    protected String language = (String)this.getParameter("language").getValue();
    protected String ontology = (String)this.getParameter("ontology").getValue();
    protected boolean firstanswer;

    public void action(IEvent event) {
        if (event instanceof IGoalEvent && !((IGoalEvent)event).isInfo()) {
            this.getLogger().info(this.getScope().getName() + ": Request initiator action called: " + this);
            IMessageEvent request = this.createMessageEvent("rp_request");
            request.setContent(this.content);
            request.getParameterSet("receivers").addValue(this.receiver);
            if (this.language != null) {
                request.getParameter("language").setValue(this.language);
            }
            if (this.ontology != null) {
                request.getParameter("ontology").setValue(this.ontology);
            }
            this.sendMessageAndWait(request, this.timeout);
        } else if (event instanceof IMessageEvent && !this.firstanswer) {
            this.handleFirstAnswer((IMessageEvent)event);
            this.firstanswer = true;
        } else if (event instanceof IMessageEvent) {
            this.handleSecondAnswer((IMessageEvent)event);
        }
    }

    protected void handleFirstAnswer(IMessageEvent answer) {
        this.getLogger().info("First answer: " + answer);
        if (answer.getType().equals("rp_not_understood")) {
            this.handleNotUnderstood(answer);
        } else if (answer.getType().equals("rp_refuse")) {
            this.handleRefuse(answer);
        } else if (answer.getType().equals("rp_failure")) {
            this.handleFailure(answer);
        } else if (answer.getType().equals("rp_agree")) {
            this.handleAgree(answer);
            MessageEventFilter inform = new MessageEventFilter("rp_inform");
            inform.addValue("conversation-id", answer.getParameter("conversation-id").getValue());
            MessageEventFilter failure = new MessageEventFilter("rp_failure");
            failure.addValue("conversation-id", answer.getParameter("conversation-id").getValue());
            ComposedFilter response = new ComposedFilter(new IFilter[]{inform, failure}, 2);
            this.waitFor(response, this.timeout);
        } else if (answer.getType().equals("rp_inform_done")) {
            this.handleInform(answer);
        }
    }

    protected void handleSecondAnswer(IMessageEvent answer) {
        this.getLogger().info("Second answer: " + answer.getMessage());
        if (answer.getType().equals("rp_failure")) {
            this.handleFailure(answer);
        } else if (answer.getType().equals("rp_inform")) {
            this.handleInform(answer);
        }
    }

    protected void handleAgree(IMessageEvent message) {
        this.getLogger().info(this.getScope().getName() + ": Received agree.");
    }

    protected void handleNotUnderstood(IMessageEvent message) {
        this.getLogger().info(this.getScope().getName() + ": Received not understood: " + message.getContent());
        this.requestFinished(false, message.getContent());
    }

    protected void handleRefuse(IMessageEvent message) {
        this.getLogger().info(this.getScope().getName() + ": Received refuse: " + message.getContent());
        this.requestFinished(false, message.getContent());
    }

    protected void handleFailure(IMessageEvent message) {
        this.getLogger().info(this.getScope().getName() + ": Received failure: " + message.getContent());
        this.requestFinished(false, message.getContent());
    }

    protected void handleInform(IMessageEvent message) {
        this.getLogger().info(this.getScope().getName() + ": Request succeeded.");
        this.requestFinished(true, message.getContent());
    }

    protected void requestFinished(boolean success, Object result) {
        this.getParameter("result").setValue(result);
        if (!success) {
            this.fail();
        }
    }
}

