/*
 * Decompiled with CFR 0.152.
 */
package jadex.planlib;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.planlib.TestReport;
import jadex.planlib.Testcase;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.IMessageEvent;
import jadex.runtime.MessageEventFilter;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import java.io.Serializable;
import java.util.HashMap;

public class PerformTestPlan
extends Plan {
    protected AgentIdentifier testagent;

    public void body() {
        Testcase testcase = (Testcase)this.getParameter("testcase").getValue();
        Long timeout = (Long)this.getBeliefbase().getBelief("timeout").getFact();
        this.getLogger().info("Performing testcase: " + testcase.getType());
        try {
            IGoal create = this.createGoal("ams_create_agent");
            create.getParameter("type").setValue(testcase.getType());
            HashMap<String, Serializable> args = new HashMap<String, Serializable>();
            args.put("timeout", timeout);
            args.put("testcenter", this.getAgentIdentifier());
            create.getParameter("arguments").setValue(args);
            create.getParameter("start").setValue(Boolean.FALSE);
            this.dispatchSubgoalAndWait(create);
            this.testagent = (AgentIdentifier)create.getParameter("agentidentifier").getValue();
            MessageEventFilter fil = new MessageEventFilter("inform_reports");
            fil.addValue("sender", this.testagent);
            this.getWaitqueue().addFilter(fil);
            IGoal start = this.createGoal("ams_start_agent");
            start.getParameter("agentidentifier").setValue(this.testagent);
            this.dispatchSubgoalAndWait(start);
            try {
                IMessageEvent ans = (IMessageEvent)this.waitFor(fil, timeout);
                Testcase result = (Testcase)ans.getContent();
                testcase.setTestCount(result.getTestCount());
                testcase.setReports(result.getReports());
            }
            catch (TimeoutException te) {
                IGoal destroy = this.createGoal("ams_destroy_agent");
                destroy.getParameter("agentidentifier").setValue(this.testagent);
                try {
                    this.dispatchSubgoalAndWait(destroy);
                }
                catch (GoalFailureException ge) {
                    this.getLogger().info("Test agent could not be deleted.");
                }
                this.testagent = null;
                testcase.setReports(new TestReport[]{new TestReport("answer", "Test center report", false, "Test agent did not answer.")});
            }
        }
        catch (GoalFailureException ge) {
            Throwable cause;
            for (cause = ge; cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
            }
            testcase.setReports(new TestReport[]{new TestReport("creation", "Test center report", false, "Test agent could not be created: " + cause)});
        }
    }

    public void aborted() {
        if (this.testagent != null) {
            IGoal destroy = this.createGoal("ams_destroy_agent");
            destroy.getParameter("agentidentifier").setValue(this.testagent);
            try {
                this.dispatchSubgoalAndWait(destroy);
            }
            catch (GoalFailureException ge) {
                this.getLogger().info("Test agent could not be deleted.");
            }
        }
    }
}

