/*
 * Decompiled with CFR 0.152.
 */
package jadex.planlib;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.planlib.ProposalInfo;
import jadex.runtime.IMessageEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class NegotiationRecord {
    public static final String OPEN = "Open";
    public static final String SUCCEEDED = "succeeded";
    public static final String FAILED = "failed";
    protected Object cfp;
    protected Map proposals;
    protected List acceptables;
    protected List winners;
    protected List tasks;
    protected String state;
    protected long starttime;
    protected long endtime;

    public NegotiationRecord(Object cfp) {
        this.cfp = cfp;
        this.proposals = new HashMap();
        this.acceptables = new ArrayList();
        this.winners = new ArrayList();
        this.tasks = new ArrayList();
        this.state = OPEN;
    }

    public void addProposal(IMessageEvent msg) {
        this.proposals.put(msg.getContent(), new ProposalInfo(msg));
    }

    public void setAcceptableProposals(Object[] proposals) {
        for (int i = 0; i < proposals.length; ++i) {
            this.acceptables.add(proposals[i]);
        }
    }

    public void setWinnerProposals(Object[] proposals) {
        for (int i = 0; i < proposals.length; ++i) {
            this.winners.add(proposals[i]);
        }
    }

    public void addExecutedTask(Object task) {
        this.tasks.add(task);
    }

    public Object[] getProposals() {
        return this.proposals.keySet().toArray();
    }

    public Object[] getAcceptableProposals() {
        return this.acceptables.toArray();
    }

    public Object[] getWinnerProposals() {
        return this.winners.toArray();
    }

    public Object[] getTasks() {
        return this.tasks.toArray();
    }

    public AgentIdentifier[] getWinnerParticipants() {
        ArrayList<AgentIdentifier> ret = new ArrayList<AgentIdentifier>();
        for (int i = 0; i < this.winners.size(); ++i) {
            ProposalInfo pi = (ProposalInfo)this.proposals.get(this.winners.get(i));
            ret.add(pi.getAgentIdentifier());
        }
        return ret.toArray(new AgentIdentifier[ret.size()]);
    }

    public Object[] getNonAcceptableProposals() {
        HashSet ret = new HashSet(this.proposals.keySet());
        ret.removeAll(this.acceptables);
        return ret.toArray();
    }

    public Object[] getNonWinnerProposals() {
        HashSet ret = new HashSet(this.proposals.keySet());
        ret.removeAll(this.winners);
        return ret.toArray();
    }

    public AgentIdentifier getAgentIdentifier(Object proposal) {
        ProposalInfo pi = (ProposalInfo)this.proposals.get(proposal);
        return pi.getAgentIdentifier();
    }

    public IMessageEvent getMessageEvent(Object proposal) {
        ProposalInfo pi = (ProposalInfo)this.proposals.get(proposal);
        return pi.getMessageEvent();
    }

    public Object getProposal(AgentIdentifier sender) {
        Object ret = null;
        Object[] ps = this.proposals.keySet().toArray();
        for (int i = 0; ret == null && i < ps.length; ++i) {
            ProposalInfo pi = (ProposalInfo)this.proposals.get(ps[i]);
            if (!pi.getAgentIdentifier().equals(sender)) continue;
            ret = ps[i];
        }
        return ret;
    }

    public Object getCFP() {
        return this.cfp;
    }

    public int size() {
        return this.proposals.size();
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public long getStarttime() {
        return this.starttime;
    }

    public void setStarttime(long starttime) {
        this.starttime = starttime;
    }

    public long getEndtime() {
        return this.endtime;
    }

    public void setEndtime(long endtime) {
        this.endtime = endtime;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy.'-'HH:mm:ss ': '");
        StringBuffer ret = new StringBuffer();
        ret.append("NegotiationRecord(");
        ret.append("starttime: " + sdf.format(new Date(this.starttime)) + ", ");
        ret.append("endtime: " + sdf.format(new Date(this.endtime)) + ", ");
        ret.append("cfp: " + this.cfp + ", ");
        ret.append("proposals: " + this.proposals + ", ");
        ret.append("winners: " + this.winners + ", ");
        ret.append("state: " + this.state);
        ret.append(")");
        return ret.toString();
    }
}

