/*
 * Decompiled with CFR 0.152.
 */
package jadex.planlib;

import jadex.planlib.AuctionInfo;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.IMessageEvent;
import jadex.runtime.MessageEventFilter;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import jadex.util.collection.SCollection;
import java.util.ArrayList;

public class EAReceiverPlan
extends Plan {
    public void body() {
        IMessageEvent me = (IMessageEvent)this.getInitialEvent();
        AuctionInfo auctioninfo = (AuctionInfo)me.getParameter("content").getValue();
        this.getLogger().info(this.getAgentName() + ": Received inform_start_auction message with AuctionInfo " + "start time: " + auctioninfo.getStarttime() + " Round time " + auctioninfo.getRoundTimeout() + " topic: " + auctioninfo.getTopic());
        if (auctioninfo.getRoundTimeout() <= 0L) {
            this.getLogger().warning(this.getAgentName() + "No round timeout specified");
            this.fail();
        }
        boolean participate = true;
        try {
            IGoal dp = this.getScope().getGoalbase().createGoal("ea_decide_participation");
            dp.getParameter("auction_info").setValue(auctioninfo);
            this.dispatchSubgoalAndWait(dp);
            Boolean part = (Boolean)dp.getParameter("participate").getValue();
            participate = part == null ? true : part;
        }
        catch (GoalFailureException e) {
            this.getLogger().info("Optional goal ea_decide_request has not been handled.");
        }
        String convid = (String)me.getParameter("conversation-id").getValue();
        MessageEventFilter mef = new MessageEventFilter(null);
        mef.addValue("conversation-id", convid);
        this.getWaitqueue().addFilter(mef);
        boolean running = true;
        Object winning_offer = null;
        long buftimeout = (long)((double)auctioninfo.getRoundTimeout() * 1.1);
        ArrayList offers = SCollection.createArrayList();
        long firsttimeout = auctioninfo.getStarttime() == 0L || auctioninfo.getStarttime() - System.currentTimeMillis() <= 0L ? -1L : auctioninfo.getStarttime() - System.currentTimeMillis() + buftimeout;
        int missing_cnt = 0;
        boolean sitting_out = false;
        while (participate && running) {
            IMessageEvent cfp = null;
            try {
                this.getLogger().info(this.getAgentName() + " waiting for: " + firsttimeout + " " + buftimeout);
                cfp = (IMessageEvent)this.waitFor(mef, firsttimeout == -1L ? buftimeout : firsttimeout);
                this.getLogger().info(this.getAgentName() + " received cfp: " + cfp.getType());
                firsttimeout = -1L;
                if (cfp.getType().equals("ea_cfp")) {
                    if (sitting_out) {
                        sitting_out = false;
                        winning_offer = null;
                    }
                    if (winning_offer == null) {
                        IGoal mp = this.createGoal("ea_make_proposal");
                        Object offer = cfp.getContent();
                        offers.add(offer);
                        mp.getParameter("offer").setValue(offer);
                        mp.getParameter("auction_info").setValue(auctioninfo);
                        mp.getParameterSet("history").addValues(offers.toArray());
                        try {
                            this.dispatchSubgoalAndWait(mp, auctioninfo.getRoundTimeout());
                        }
                        catch (TimeoutException e) {
                            this.getLogger().info(this.getAgentName() + e.getMessage());
                        }
                        Boolean leave = (Boolean)mp.getParameter("leave").getValue();
                        Boolean accept = (Boolean)mp.getParameter("accept").getValue();
                        if (leave != null && leave.booleanValue()) {
                            this.getLogger().info(this.getAgentName() + " informs the initiator of the auction " + auctioninfo.getTopic() + " that it doesn't want to participate.");
                            IMessageEvent leavemsg = this.getEventbase().createMessageEvent("ea_not_understood");
                            leavemsg.getParameterSet("receivers").addValue(me.getParameter("sender").getValue());
                            leavemsg.getParameter("conversation-id").setValue(convid);
                            this.sendMessage(leavemsg);
                            participate = false;
                            continue;
                        }
                        if (accept == null || !accept.booleanValue()) continue;
                        IMessageEvent acceptmsg = this.getEventbase().createMessageEvent("ea_propose");
                        acceptmsg.getParameterSet("receivers").addValue(me.getParameter("sender").getValue());
                        acceptmsg.getParameter("conversation-id").setValue(convid);
                        this.sendMessage(acceptmsg);
                        continue;
                    }
                    sitting_out = true;
                    continue;
                }
                if (cfp.getType().equals("ea_accept_proposal")) {
                    winning_offer = cfp.getContent();
                    continue;
                }
                if (cfp.getType().equals("ea_reject_proposal")) {
                    winning_offer = null;
                    continue;
                }
                if (cfp.getType().equals("ea_inform_end_auction")) {
                    if (winning_offer != null && !winning_offer.equals(cfp.getContent())) {
                        winning_offer = null;
                    }
                    running = false;
                    continue;
                }
                this.getLogger().warning("Could not understand: " + cfp + " " + cfp.getType());
            }
            catch (TimeoutException e) {
                this.getLogger().info(this.getAgentName() + " " + e.getMessage());
                if (++missing_cnt != 3) continue;
                running = false;
            }
        }
        if (!running) {
            IGoal af = this.createGoal("ea_auction_finished");
            af.getParameter("offer").setValue(winning_offer);
            af.getParameter("auction_info").setValue(auctioninfo);
            af.getParameter("won").setValue(new Boolean(winning_offer != null));
            af.getParameterSet("history").addValues(offers.toArray());
            try {
                this.dispatchSubgoalAndWait(af);
            }
            catch (GoalFailureException e) {
                this.getLogger().info(this.getAgentName() + ": No reaction on finished auction: " + offers);
            }
        }
        this.getWaitqueue().removeFilter(mef);
    }
}

