/*
 * Decompiled with CFR 0.152.
 */
package jadex.planlib;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.planlib.AuctionInfo;
import jadex.planlib.IOfferGenerator;
import jadex.runtime.IMessageEvent;
import jadex.runtime.IParameterElement;
import jadex.runtime.MessageEventFilter;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import jadex.util.SUtil;
import java.util.List;

public class EAInitiatorPlan
extends Plan {
    public void body() {
        AuctionInfo auctioninfo = (AuctionInfo)this.getParameter("auction_info").getValue();
        if (auctioninfo.getRoundTimeout() <= 0L) {
            this.getLogger().warning(this.getAgentName() + "No round timeout specified");
            this.fail();
        }
        long timetowait = auctioninfo.getStarttime() == 0L ? 0L : auctioninfo.getStarttime() - System.currentTimeMillis();
        long roundtimeout = auctioninfo.getRoundTimeout();
        IOfferGenerator offercalc = (IOfferGenerator)this.getParameter("offer_generator").getValue();
        List receivers = SUtil.arrayToList(this.getParameterSet("receivers").getValues());
        IMessageEvent start = this.getEventbase().createMessageEvent("ea_inform_start_auction");
        start.getParameterSet("receivers").addValues(receivers.toArray());
        String convid = (String)start.getParameter("conversation-id").getValue();
        start.getParameter("content").setValue(auctioninfo);
        this.getLogger().info(this.getAgentName() + ":\tinform_start_auction");
        MessageEventFilter mef = new MessageEventFilter(null);
        mef.addValue("conversation-id", convid);
        this.getWaitqueue().addFilter(mef);
        this.sendMessage(start);
        while (timetowait > 0L) {
            IMessageEvent removebidder;
            try {
                removebidder = (IMessageEvent)this.waitFor(mef, timetowait);
            }
            catch (TimeoutException e) {
                break;
            }
            if (removebidder.getType().equals("ea_not_understood")) {
                receivers.remove(removebidder.getParameter("sender").getValue());
                this.getLogger().info("Removed " + ((AgentIdentifier)removebidder.getParameter("sender").getValue()).getName() + ".");
            } else {
                this.getLogger().warning("Could not handle message of type " + removebidder.getType() + " from " + ((AgentIdentifier)removebidder.getParameter("sender").getValue()).getName() + ".");
            }
            timetowait = -System.currentTimeMillis();
        }
        boolean running = true;
        Comparable winning_offer = null;
        IParameterElement winner = null;
        while (running && receivers.size() > 0 && offercalc.getCurrentOffer().compareTo(offercalc.getLimitOffer()) < 0) {
            Comparable offer = offercalc.getCurrentOffer();
            IMessageEvent cfp = this.getEventbase().createMessageEvent("ea_cfp");
            cfp.getParameterSet("receivers").addValues(receivers.toArray());
            cfp.setContent(offer);
            cfp.getParameter("conversation-id").setValue(convid);
            this.getLogger().info(this.getAgentName() + ": cfp(" + offer + ")");
            this.sendMessage(cfp);
            IMessageEvent first_proposal = null;
            long roundstart = System.currentTimeMillis();
            while (System.currentTimeMillis() - roundstart < roundtimeout) {
                try {
                    IMessageEvent tmp = (IMessageEvent)this.waitFor(mef, roundtimeout);
                    if (tmp.getType().equals("ea_propose")) {
                        if (first_proposal == null) {
                            this.getLogger().info(this.getAgentName() + " got first accept for: " + offer + " from: " + tmp.getParameter("sender").getValue());
                            IMessageEvent accept = tmp.createReply("ea_accept_proposal");
                            accept.getParameter("conversation-id").setValue(convid);
                            accept.getParameter("content").setValue(offer);
                            this.sendMessage(accept);
                            first_proposal = tmp;
                            continue;
                        }
                        this.getLogger().info(this.getAgentName() + " got too late accept for: " + offer + " from: " + tmp.getParameter("sender").getValue());
                        IMessageEvent reject = tmp.createReply("ea_reject_proposal");
                        reject.getParameter("conversation-id").setValue(convid);
                        this.sendMessage(reject);
                        continue;
                    }
                    this.getLogger().info(this.getAgentName() + " removing agent " + tmp.getParameter("sender").getValue());
                    receivers.remove(tmp.getParameter("sender").getValue());
                }
                catch (TimeoutException e) {
                    this.getLogger().info("No further bids in this round");
                }
            }
            if (first_proposal != null) {
                winner = first_proposal;
                winning_offer = offer;
                offercalc.setNextRound();
                continue;
            }
            running = false;
        }
        if (winner != null) {
            AgentIdentifier wina = (AgentIdentifier)winner.getParameter("sender").getValue();
            this.getLogger().info(this.getAgentName() + ": AUCTION TERMINATED (winner: " + wina.getName() + " - price: " + winning_offer + ")");
            this.getParameter("winner").setValue(wina);
            this.getParameter("winning_offer").setValue(winning_offer);
        } else {
            this.getLogger().info(this.getAgentName() + ": AUCTION TERMINATED " + "(no winner - initiator didn't receive any proposals)");
        }
        IMessageEvent end = this.getEventbase().createMessageEvent("ea_inform_end_auction");
        end.getParameter("content").setValue(winning_offer);
        end.getParameterSet("receivers").addValues(receivers.toArray());
        end.getParameter("conversation-id").setValue(convid);
        this.sendMessage(end);
        this.getWaitqueue().removeFilter(mef);
    }
}

