/*
 * Decompiled with CFR 0.152.
 */
package jadex.planlib;

import jadex.planlib.AuctionInfo;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.runtime.IMessageEvent;
import jadex.runtime.MessageEventFilter;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import jadex.util.collection.SCollection;
import java.util.ArrayList;

public class DAReceiverPlan
extends Plan {
    public void body() {
        IMessageEvent me = (IMessageEvent)this.getInitialEvent();
        AuctionInfo auctioninfo = (AuctionInfo)me.getParameter("content").getValue();
        this.getLogger().info(this.getAgentName() + ": Received inform_start_auction message with AuctionInfo " + "start time: " + auctioninfo.getStarttime() + " Round time " + auctioninfo.getRoundTimeout() + " topic: " + auctioninfo.getTopic());
        if (auctioninfo.getRoundTimeout() <= 0L) {
            this.getLogger().warning(this.getAgentName() + "No round timeout specified");
            this.fail();
        }
        boolean participate = true;
        try {
            IGoal dp = this.getScope().getGoalbase().createGoal("da_decide_participation");
            dp.getParameter("auction_info").setValue(auctioninfo);
            this.dispatchSubgoalAndWait(dp);
            Boolean part = (Boolean)dp.getParameter("participate").getValue();
            participate = part == null ? true : part;
        }
        catch (GoalFailureException e) {
            this.getLogger().info("Optional goal da_decide_request has not been handled.");
        }
        String convid = (String)me.getParameter("conversation-id").getValue();
        MessageEventFilter mef = new MessageEventFilter(null);
        mef.addValue("conversation-id", convid);
        this.getWaitqueue().addFilter(mef);
        boolean running = true;
        boolean won = false;
        long buftimeout = (long)((double)auctioninfo.getRoundTimeout() * 1.1);
        ArrayList offers = SCollection.createArrayList();
        long firsttimeout = auctioninfo.getStarttime() == 0L || auctioninfo.getStarttime() - System.currentTimeMillis() <= 0L ? -1L : auctioninfo.getStarttime() - System.currentTimeMillis() + buftimeout;
        int missing_cnt = 0;
        while (participate && running) {
            IMessageEvent cfp = null;
            try {
                this.getLogger().info(this.getAgentName() + " waiting for: " + firsttimeout + " " + buftimeout);
                cfp = (IMessageEvent)this.waitFor(mef, firsttimeout == -1L ? buftimeout : firsttimeout);
                this.getLogger().info(this.getAgentName() + " received cfp: " + cfp.getContent());
                firsttimeout = -1L;
                if (cfp.getType().equals("da_cfp")) {
                    IGoal mp = this.createGoal("da_make_proposal");
                    Object offer = cfp.getContent();
                    offers.add(offer);
                    mp.getParameter("offer").setValue(offer);
                    mp.getParameter("auction_info").setValue(auctioninfo);
                    mp.getParameterSet("history").addValues(offers.toArray());
                    Boolean leave = null;
                    try {
                        this.dispatchSubgoalAndWait(mp, auctioninfo.getRoundTimeout());
                        leave = (Boolean)mp.getParameter("leave").getValue();
                    }
                    catch (TimeoutException e) {
                        this.getLogger().info(this.getAgentName() + e.getMessage());
                    }
                    if (leave != null && leave.booleanValue()) {
                        this.getLogger().info(this.getAgentName() + " informs the initiator of the auction " + auctioninfo.getTopic() + " that it doesn't want to participate.");
                        IMessageEvent leavemsg = this.getEventbase().createMessageEvent("da_not_understood");
                        leavemsg.getParameterSet("receivers").addValue(me.getParameter("sender").getValue());
                        leavemsg.getParameter("conversation-id").setValue(convid);
                        this.sendMessage(leavemsg);
                        participate = false;
                        continue;
                    }
                    if (!((Boolean)mp.getParameter("accept").getValue()).booleanValue()) continue;
                    this.getLogger().info(this.getAgentName() + " sending proposal: " + offer);
                    IMessageEvent accept = this.getEventbase().createMessageEvent("da_propose");
                    accept.getParameterSet("receivers").addValue(me.getParameter("sender").getValue());
                    accept.getParameter("conversation-id").setValue(convid);
                    this.sendMessage(accept);
                    continue;
                }
                if (cfp.getType().equals("da_accept_proposal")) {
                    won = true;
                    running = false;
                    continue;
                }
                if (cfp.getType().equals("da_reject_proposal") || cfp.getType().equals("da_inform_end_auction")) {
                    running = false;
                    continue;
                }
                System.out.println("Could not understand: " + cfp + " " + cfp.getType());
            }
            catch (TimeoutException e) {
                this.getLogger().info(this.getAgentName() + " " + e.getMessage());
                if (++missing_cnt != 3) continue;
                running = false;
            }
        }
        if (!running) {
            IGoal af = this.createGoal("da_auction_finished");
            if (offers.size() > 0) {
                af.getParameter("offer").setValue(offers.get(offers.size() - 1));
            }
            af.getParameter("auction_info").setValue(auctioninfo);
            af.getParameter("won").setValue(new Boolean(won));
            af.getParameterSet("history").addValues(offers.toArray());
            try {
                this.dispatchSubgoalAndWait(af);
            }
            catch (GoalFailureException e) {
                this.getLogger().info(this.getAgentName() + ": No reaction on finished auction: " + offers);
            }
        }
        this.getWaitqueue().removeFilter(mef);
    }
}

