/*
 * Decompiled with CFR 0.152.
 */
package jadex.planlib;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.planlib.AuctionInfo;
import jadex.planlib.IOfferGenerator;
import jadex.runtime.BasicAgentIdentifier;
import jadex.runtime.IMessageEvent;
import jadex.runtime.MessageEventFilter;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import jadex.util.SUtil;
import java.util.List;

public class DAInitiatorPlan
extends Plan {
    public void body() {
        BasicAgentIdentifier winner = null;
        AuctionInfo auctioninfo = (AuctionInfo)this.getParameter("auction_info").getValue();
        if (auctioninfo.getRoundTimeout() <= 0L) {
            this.getLogger().warning(this.getAgentName() + "No round timeout specified");
            this.fail();
        }
        long timetowait = auctioninfo.getStarttime() == 0L ? 0L : auctioninfo.getStarttime() - System.currentTimeMillis();
        long roundtimeout = auctioninfo.getRoundTimeout();
        IOfferGenerator offercalc = (IOfferGenerator)this.getParameter("offer_generator").getValue();
        List receivers = SUtil.arrayToList(this.getParameterSet("receivers").getValues());
        IMessageEvent start = this.getEventbase().createMessageEvent("da_inform_start_auction");
        start.getParameterSet("receivers").addValues(receivers.toArray());
        String convid = (String)start.getParameter("conversation-id").getValue();
        start.getParameter("content").setValue(auctioninfo);
        this.getLogger().info(this.getAgentName() + ":\tinform_start_auction");
        MessageEventFilter mef = new MessageEventFilter(null);
        mef.addValue("conversation-id", convid);
        this.getWaitqueue().addFilter(mef);
        this.sendMessage(start);
        while (timetowait > 0L) {
            IMessageEvent removebidder;
            try {
                removebidder = (IMessageEvent)this.waitFor(mef, timetowait);
            }
            catch (TimeoutException e) {
                break;
            }
            if (removebidder.getType().equals("da_not_understood")) {
                receivers.remove(removebidder.getParameter("sender").getValue());
                this.getLogger().info("Removed " + ((AgentIdentifier)removebidder.getParameter("sender").getValue()).getName() + ".");
            } else {
                this.getLogger().warning("Could not handle message of type " + removebidder.getType() + " from " + ((AgentIdentifier)removebidder.getParameter("sender").getValue()).getName() + ".");
            }
            timetowait = -System.currentTimeMillis();
        }
        while (winner == null && receivers.size() > 0 && offercalc.getCurrentOffer().compareTo(offercalc.getLimitOffer()) > 0) {
            IMessageEvent cfp = this.getEventbase().createMessageEvent("da_cfp");
            cfp.getParameterSet("receivers").addValues(receivers.toArray());
            cfp.setContent(offercalc.getCurrentOffer());
            cfp.getParameter("conversation-id").setValue(convid);
            this.getLogger().info(this.getAgentName() + ": cfp(price: " + offercalc.getCurrentOffer() + ") " + receivers);
            this.sendMessage(cfp);
            long roundstart = System.currentTimeMillis();
            while (System.currentTimeMillis() - roundstart < roundtimeout) {
                IMessageEvent reply = null;
                try {
                    reply = (IMessageEvent)this.waitFor(mef, roundtimeout);
                    if (reply.getType().equals("da_propose")) {
                        if (winner == null) {
                            IMessageEvent accept = this.getEventbase().createMessageEvent("da_accept_proposal");
                            accept.getParameterSet("receivers").addValue(reply.getParameter("sender").getValue());
                            accept.getParameter("conversation-id").setValue(convid);
                            this.sendMessage(accept);
                            this.getLogger().info(this.getAgentName() + " found winner: " + reply.getParameter("sender").getValue());
                            IMessageEvent end = this.getEventbase().createMessageEvent("da_inform_end_auction");
                            end.getParameterSet("receivers").addValues(receivers.toArray());
                            end.getParameter("conversation-id").setValue(convid);
                            this.sendMessage(end);
                            this.getLogger().info(this.getAgentName() + ": inform_end_auction");
                            winner = (AgentIdentifier)reply.getParameter("sender").getValue();
                            this.getParameter("winner").setValue(winner);
                            this.getParameter("winning_offer").setValue(offercalc.getCurrentOffer());
                            continue;
                        }
                        IMessageEvent tmp = reply.createReply("da_reject_proposal");
                        tmp.getParameter("conversation-id").setValue(convid);
                        this.sendMessage(tmp);
                        continue;
                    }
                    receivers.remove(reply.getParameter("sender").getValue());
                }
                catch (TimeoutException e) {}
            }
            if (winner != null) continue;
            offercalc.setNextRound();
        }
        if (winner == null) {
            this.getLogger().info(this.getAgentName() + ": AUCTION TERMINATED (no winner)");
        } else {
            this.getLogger().info(this.getAgentName() + ": AUCTION TERMINATED (winner: " + winner.getName() + " - price: " + offercalc.getCurrentOffer() + ")");
        }
        this.getWaitqueue().removeFilter(mef);
    }
}

