/*
 * Decompiled with CFR 0.152.
 */
package jadex.planlib;

import jadex.runtime.IGoal;
import jadex.runtime.IMessageEvent;
import jadex.runtime.Plan;
import jadex.util.collection.SCollection;
import java.util.ArrayList;

public class CNPReceiverPlan
extends Plan {
    public void body() {
        IMessageEvent reply;
        long timeout = this.getBeliefbase().containsBelief("timeout") && this.getBeliefbase().getBelief("timeout").getFact() != null ? (Long)this.getBeliefbase().getBelief("timeout").getFact() : -1L;
        IMessageEvent me = (IMessageEvent)this.getInitialEvent();
        ArrayList records = SCollection.createArrayList();
        Object[] proposal = null;
        int i = 0;
        while (me.getType().equals("cnp_cfp")) {
            this.getLogger().info("Negotiation round: " + i + " receiver got cfp: " + me);
            records.add(me);
            Object task = me.getContent();
            Exception ex = null;
            try {
                proposal = this.makeProposal(task);
            }
            catch (Exception e) {
                ex = e;
                e.printStackTrace();
            }
            if (ex != null || proposal == null || proposal[0] == null) {
                reply = me.createReply("cnp_refuse");
                this.getLogger().info("No proposal made. Finished.");
                this.sendMessage(reply);
                return;
            }
            reply = me.createReply("cnp_propose");
            reply.setContent(proposal[0]);
            this.getLogger().info("Receiver sent proposal: " + reply);
            me = this.sendMessageAndWait(reply, timeout);
            ++i;
        }
        if (me.getType().equals("cnp_accept")) {
            this.getLogger().info("Doing the work.");
            try {
                Object result = this.executeTask(proposal[0], proposal[1]);
                reply = me.createReply("cnp_inform_done");
                reply.setContent(result);
                this.getLogger().info("Receiver sent done: " + reply);
                this.sendMessage(reply);
            }
            catch (Exception e) {
                reply = me.createReply("cnp_failure");
                this.getLogger().info("Receiver sent failure: " + reply);
                this.sendMessage(reply);
            }
        } else {
            this.getLogger().info("Proposal rejected. Finished.");
        }
    }

    public Object[] makeProposal(Object task) {
        IGoal make_proposal = this.createGoal("cnp_make_proposal");
        make_proposal.getParameter("task").setValue(task);
        this.dispatchSubgoalAndWait(make_proposal);
        return new Object[]{make_proposal.getParameter("proposal").getValue(), make_proposal.getParameter("proposal_info").getValue()};
    }

    public Object executeTask(Object proposal, Object proposal_info) {
        IGoal execute_task = this.createGoal("cnp_execute_task");
        execute_task.getParameter("proposal").setValue(proposal);
        execute_task.getParameter("proposal_info").setValue(proposal_info);
        this.dispatchSubgoalAndWait(execute_task);
        return execute_task.getParameter("result").getValue();
    }
}

