/*
 * Decompiled with CFR 0.152.
 */
package jadex.planlib;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.SFipa;
import jadex.planlib.IIterationDecider;
import jadex.planlib.ISelector;
import jadex.planlib.NegotiationRecord;
import jadex.runtime.IMessageEvent;
import jadex.runtime.MessageEventFilter;
import jadex.runtime.Plan;
import jadex.runtime.TimeoutException;
import jadex.util.SUtil;
import java.util.List;
import java.util.Set;

public class CNPInitiatorPlan
extends Plan {
    protected MessageEventFilter mf;
    protected long timeout;
    protected ISelector selector;
    protected IMessageEvent me;

    public void body() {
        this.timeout = this.hasParameter("timeout") && this.getParameter("timeout").getValue() != null ? (Long)this.getParameter("timeout").getValue() : (this.getBeliefbase().containsBelief("timeout") && this.getBeliefbase().getBelief("timeout").getFact() != null ? (Long)this.getBeliefbase().getBelief("timeout").getFact() : -1L);
        String convid = SFipa.createUniqueId(this.getAgentName());
        this.mf = new MessageEventFilter(null);
        this.mf.addValue("conversation-id", convid);
        this.getWaitqueue().addFilter(this.mf);
        this.selector = (ISelector)this.getParameter("selector").getValue();
        IIterationDecider decider = (IIterationDecider)this.getParameter("iteration_decider").getValue();
        Object[] participants = (AgentIdentifier[])this.getParameterSet("receivers").getValues();
        NegotiationRecord nr = new NegotiationRecord(this.getParameter("content").getValue());
        nr.setStarttime(System.currentTimeMillis());
        this.getParameterSet("history").addValue(nr);
        while (participants.length > 0) {
            this.sendProposals((AgentIdentifier[])participants, nr.getCFP(), convid);
            this.collectProposals(nr, (AgentIdentifier[])participants);
            this.determineWinners(nr);
            if (decider == null) break;
            NegotiationRecord[] nrs = (NegotiationRecord[])this.getParameterSet("history").getValues();
            Object[] newparticipants = decider.decideIteration(nrs);
            if (newparticipants.length > 0) {
                this.rejectExcludedProposals(nr, participants, newparticipants);
                nr.setEndtime(System.currentTimeMillis());
                Object cfp = decider.refineCFP(nrs);
                nr = new NegotiationRecord(cfp);
                nr.setStarttime(System.currentTimeMillis());
                this.getParameterSet("history").addValue(nr);
            }
            participants = newparticipants;
        }
        this.answerProposals(nr);
        this.waitForTasksDone(nr);
        nr.setEndtime(System.currentTimeMillis());
        this.determineFailure(nr);
        this.getParameterSet("result").addValues(nr.getTasks());
        this.getLogger().info(this.getAgentName() + "CNPPlan finished: " + convid);
    }

    protected void sendProposals(AgentIdentifier[] participants, Object cfp, String convid) {
        this.me = this.getEventbase().createMessageEvent("cnp_cfp");
        this.me.getParameterSet("receivers").addValues(participants);
        this.me.getParameter("conversation-id").setValue(convid);
        this.me.setContent(cfp);
        this.getLogger().info(this.getAgentName() + " CNPPlan initiated: " + convid);
        this.sendMessage(this.me);
    }

    protected void collectProposals(NegotiationRecord pr, AgentIdentifier[] participants) {
        List rec = SUtil.arrayToList(participants);
        long time = System.currentTimeMillis();
        try {
            long wait_time;
            while (rec.size() > 0 && (wait_time = this.timeout + time - System.currentTimeMillis()) > 0L) {
                this.getLogger().info(this.getAgentName() + " CNPPlan: waiting: " + wait_time);
                IMessageEvent reply = (IMessageEvent)this.waitFor(this.mf, wait_time);
                AgentIdentifier sender = (AgentIdentifier)reply.getParameter("sender").getValue();
                rec.remove(sender);
                if (!reply.getType().equals("cnp_propose")) continue;
                this.getLogger().info(this.getAgentName() + " CNPPlan received a proposal reply: " + reply.getContent());
                pr.addProposal(reply);
            }
        }
        catch (TimeoutException e) {
            // empty catch block
        }
    }

    protected void determineWinners(NegotiationRecord nr) {
        Object[] tmp = this.selector.select(nr.getProposals());
        nr.setAcceptableProposals((Object[])tmp[0]);
        nr.setWinnerProposals((Object[])tmp[1]);
        this.getLogger().info(this.getAgentName() + " CNPPlan determined acceptables: " + SUtil.arrayToString(tmp[0]) + " winners: " + SUtil.arrayToString(tmp[1]));
    }

    protected void rejectExcludedProposals(NegotiationRecord nr, Object[] participants, Object[] newparticipants) {
        Set excluded = SUtil.arrayToSet(participants);
        excluded.removeAll(SUtil.arrayToSet(newparticipants));
        Object[] excluded_proposals = excluded.toArray();
        for (int i = 0; i < excluded_proposals.length; ++i) {
            IMessageEvent rej = nr.getMessageEvent(excluded_proposals[i]).createReply("cnp_reject");
            this.sendMessage(rej);
        }
    }

    protected void answerProposals(NegotiationRecord nr) {
        Object[] win_proposals = nr.getWinnerProposals();
        for (int i = 0; i < win_proposals.length; ++i) {
            IMessageEvent acc = nr.getMessageEvent(win_proposals[i]).createReply("cnp_accept");
            this.sendMessage(acc);
        }
        Object[] other_proposals = nr.getNonWinnerProposals();
        for (int i = 0; i < other_proposals.length; ++i) {
            IMessageEvent rej = nr.getMessageEvent(other_proposals[i]).createReply("cnp_reject");
            this.sendMessage(rej);
        }
    }

    protected void waitForTasksDone(NegotiationRecord nr) {
        List participants = SUtil.arrayToList(nr.getWinnerParticipants());
        long time = System.currentTimeMillis();
        try {
            long wait_time;
            while (participants.size() > 0 && (wait_time = this.timeout + time - System.currentTimeMillis()) > 0L) {
                IMessageEvent reply = (IMessageEvent)this.waitFor(this.mf, wait_time);
                AgentIdentifier sender = (AgentIdentifier)reply.getParameter("sender").getValue();
                participants.remove(sender);
                if (reply.getType().equals("cnp_inform_done")) {
                    nr.addExecutedTask(nr.getProposal(sender));
                    continue;
                }
                this.getLogger().info("One task was possibly not executed: " + this + " " + this.getAgentName() + " " + sender);
            }
        }
        catch (TimeoutException e) {
            // empty catch block
        }
    }

    protected void determineFailure(NegotiationRecord nr) {
        boolean needall = (Boolean)this.getParameter("needall").getValue();
        int done_cnt = nr.getTasks().length;
        if (!needall && done_cnt == 0 || needall && done_cnt != nr.getWinnerProposals().length) {
            this.getLogger().info(this.getAgentName() + " CNPPlan failed: ");
            nr.setState("failed");
            this.fail();
        }
        nr.setState("succeeded");
    }
}

