/*
 * Decompiled with CFR 0.152.
 */
package jadex.parser.javaccimpl;

import jadex.parser.javaccimpl.ExpressionNode;
import jadex.parser.javaccimpl.ParseException;
import jadex.parser.javaccimpl.ParserImpl;
import jadex.util.SReflect;
import java.lang.reflect.Array;
import java.util.Map;

public class SelectionNode
extends ExpressionNode {
    public SelectionNode(ParserImpl p, int id) {
        super(p, id);
    }

    public void precompile() {
        ExpressionNode arraynode = (ExpressionNode)this.jjtGetChild(0);
        ExpressionNode indexnode = (ExpressionNode)this.jjtGetChild(1);
        if (arraynode.getStaticType() != null) {
            if (arraynode.getStaticType().getComponentType() == null) {
                throw new ParseException("Type is not array: " + this);
            }
            this.setStaticType(arraynode.getStaticType().getComponentType());
        }
        if (indexnode.getStaticType() != null && !SReflect.isSupertype(Integer.class, indexnode.getStaticType())) {
            throw new ParseException("Index type not int: " + this);
        }
        if (arraynode.isConstant() && indexnode.isConstant()) {
            try {
                this.setConstantValue(this.getValue(null));
                this.setConstant(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object getValue(Map params) throws Exception {
        if (this.isConstant()) {
            return this.getConstantValue();
        }
        Object array = ((ExpressionNode)this.jjtGetChild(0)).getValue(params);
        Object index = ((ExpressionNode)this.jjtGetChild(1)).getValue(params);
        return Array.get(array, ((Number)index).intValue());
    }

    public String toPlainString() {
        return this.jjtGetChild(0).toPlainString() + "[" + this.jjtGetChild(1).toPlainString() + "]";
    }
}

