/*
 * Decompiled with CFR 0.152.
 */
package jadex.parser.javaccimpl;

import jadex.parser.javaccimpl.ExpressionNode;
import jadex.parser.javaccimpl.ParameterNode;
import jadex.parser.javaccimpl.ParseException;
import jadex.parser.javaccimpl.ParserImpl;
import jadex.parser.javaccimpl.TypeNode;
import jadex.util.SReflect;
import jadex.util.collection.NestedMap;
import jadex.util.collection.SCollection;
import jadex.util.collection.SortedList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class SelectNode
extends ExpressionNode {
    public static final int ALL = 1;
    public static final int ANY = 2;
    public static final int IOTA = 3;
    public static final int ASC = 1;
    public static final int DESC = 2;
    protected int mode = 1;
    protected String[] vars;
    protected boolean where;
    protected boolean orderby;
    protected int order = 1;

    public SelectNode(ParserImpl p, int id) {
        super(p, id);
    }

    public void setText(String text) {
        super.setText(text);
        this.mode = SelectNode.fromString(text);
    }

    public void setVariables(String[] vars) {
        this.vars = vars;
    }

    public void setWhere(boolean where) {
        this.where = where;
    }

    public void setOrderBy(boolean orderby) {
        this.orderby = orderby;
    }

    public void setOrder(String order) {
        this.order = SelectNode.orderFromString(order);
    }

    public void precompile() {
    }

    public Object getValue(Map params) throws Exception {
        ExpressionNode orderexp;
        AbstractList results;
        SortedList orders;
        if (this.orderby) {
            orders = new SortedList(this.order == 1);
            results = new LinkedList();
        } else {
            results = new ArrayList();
            orders = null;
        }
        int subnode = 0;
        if (this.jjtGetChild(subnode) instanceof TypeNode) {
            // empty if block
        }
        int n = ++subnode;
        ++subnode;
        ExpressionNode element = (ExpressionNode)this.jjtGetChild(n);
        String select = element.toPlainString();
        boolean contained = false;
        for (int i = 0; !contained && i < this.vars.length; ++i) {
            contained = select.indexOf(this.vars[i]) != -1;
        }
        if (!contained) {
            System.out.println("Warning: Selection expression does not refer to any variables: " + this.toPlainString());
        }
        Object[] collections = new Object[this.vars.length];
        Iterator[] iterators = new Iterator[this.vars.length];
        NestedMap params2 = SCollection.createNestedMap(params);
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.jjtGetChild(subnode) instanceof TypeNode) {
                // empty if block
            }
            int n2 = ++subnode;
            ++subnode;
            collections[i] = ((ExpressionNode)this.jjtGetChild(n2)).getValue(params);
            iterators[i] = SReflect.getIterator(collections[i]);
            if (!iterators[i].hasNext()) {
                if (this.mode == 1) {
                    return results;
                }
                return null;
            }
            params2.put(this.vars[i], iterators[i].next());
        }
        ExpressionNode condition = this.where ? (ExpressionNode)this.jjtGetChild(subnode++) : null;
        ExpressionNode expressionNode = orderexp = this.orderby ? (ExpressionNode)this.jjtGetChild(subnode++) : null;
        while (true) {
            int i;
            if (!this.where || ((Boolean)condition.getValue(params2)).booleanValue()) {
                if (this.mode == 3 && results.size() > 0) {
                    throw new RuntimeException("No unique element for iota selection: " + this);
                }
                Object result = element.getValue(params2);
                if (this.orderby) {
                    int index = orders.insertElement(this.order == 1 ? orders.size() : 0, orderexp.getValue(params2));
                    results.add(index, result);
                } else {
                    results.add(result);
                }
                if (this.mode == 2 && !this.orderby) break;
            }
            for (i = 0; i < iterators.length && !iterators[i].hasNext(); ++i) {
                iterators[i] = SReflect.getIterator(collections[i]);
                params2.put(this.vars[i], iterators[i].next());
            }
            if (i >= iterators.length) break;
            params2.put(this.vars[i], iterators[i].next());
        }
        if (this.mode == 1) {
            return results;
        }
        if (results.size() > 0) {
            return results.iterator().next();
        }
        return null;
    }

    public String toPlainString() {
        int subnode = 0;
        String ret = "SELECT " + SelectNode.toString(this.mode) + " " + this.subnodeToString(subnode++) + " FROM ";
        for (int i = 0; i < this.vars.length; ++i) {
            if (i != 0) {
                ret = ret + ", ";
            }
            ret = ret + this.vars[i] + " IN " + this.subnodeToString(subnode++);
        }
        if (this.where) {
            ret = ret + " WHERE " + this.subnodeToString(subnode++);
        }
        if (this.orderby) {
            ret = ret + " ORDER BY " + this.subnodeToString(subnode++);
            if (this.order == 2) {
                ret = ret + " DESC";
            }
        }
        return ret;
    }

    public ParameterNode[] getUnboundParameterNodes() {
        ParameterNode[] param = super.getUnboundParameterNodes();
        ArrayList<ParameterNode> ret = new ArrayList<ParameterNode>();
        for (int i = 0; i < param.length; ++i) {
            boolean found = false;
            for (int j = 0; !found && j < this.vars.length; ++j) {
                found = param[i].getText().equals(this.vars[j]);
            }
            if (found) continue;
            ret.add(param[i]);
        }
        return ret.toArray(new ParameterNode[ret.size()]);
    }

    public static String toString(int mode) {
        switch (mode) {
            case 1: {
                return "ALL";
            }
            case 2: {
                return "ANY";
            }
            case 3: {
                return "IOTA";
            }
        }
        return "" + mode;
    }

    public static String orderToString(int order) {
        switch (order) {
            case 1: {
                return "ASC";
            }
            case 2: {
                return "DESC";
            }
        }
        return "" + order;
    }

    public static int fromString(String mode) {
        if ("ALL".equalsIgnoreCase(mode)) {
            return 1;
        }
        if ("ANY".equalsIgnoreCase(mode)) {
            return 2;
        }
        if ("IOTA".equalsIgnoreCase(mode)) {
            return 3;
        }
        throw new ParseException("Unknown selection mode: " + mode);
    }

    public static int orderFromString(String order) {
        if ("ASC".equalsIgnoreCase(order)) {
            return 1;
        }
        if ("DESC".equalsIgnoreCase(order)) {
            return 2;
        }
        throw new ParseException("Unknown ordering direction: " + order);
    }
}

