/*
 * Decompiled with CFR 0.152.
 */
package jadex.parser.javaccimpl;

import jadex.config.Configuration;
import jadex.parser.javaccimpl.ExpressionNode;
import jadex.parser.javaccimpl.ParseException;
import jadex.parser.javaccimpl.ParserImpl;
import jadex.runtime.AbstractPlan;
import jadex.runtime.impl.IRParameterElement;
import jadex.runtime.impl.RBeliefbase;
import jadex.util.DynamicURLClassLoader;
import jadex.util.SReflect;
import jadex.util.SUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class ReflectNode
extends ExpressionNode {
    public static final int CONSTRUCTOR = 1;
    public static final int STATIC_METHOD = 2;
    public static final int STATIC_FIELD = 3;
    public static final int METHOD = 4;
    public static final int FIELD = 5;
    protected int type;
    protected Class clazz;
    protected transient Class[] argtypes;
    protected transient Object[] args;
    protected transient Constructor[] constructors;
    protected transient Class reloadedclass;
    protected transient Method[] methods;
    protected transient Field field;
    protected boolean reloadable;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReflectNode(ParserImpl p, int id) {
        super(p, id);
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void precompile() {
        block41: {
            ExpressionNode argsnode;
            if ((this.type == 1 || this.type == 2 || this.type == 4) && this.jjtGetNumChildren() != 2 || (this.type == 3 || this.type == 5) && this.jjtGetNumChildren() != 1) {
                throw new ParseException("Wrong number of child nodes: " + this);
            }
            if (this.type != 1 && this.type != 2 && this.type != 4 && this.type != 3 && this.type != 5) {
                throw new ParseException("Unknown node type " + this.type + ": " + this);
            }
            int child = 0;
            ExpressionNode type_or_value = (ExpressionNode)this.jjtGetChild(child++);
            ExpressionNode expressionNode = argsnode = this.jjtGetNumChildren() == child ? null : (ExpressionNode)this.jjtGetChild(child);
            if (this.type == 4 || this.type == 5) {
                this.clazz = type_or_value.getStaticType();
            } else if (type_or_value != null && type_or_value.isConstant()) {
                try {
                    this.clazz = (Class)type_or_value.getValue(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.clazz != null && (this.clazz.getModifiers() & 1) == 0) {
                throw new ParseException("Cannot access member of nonpublic class: " + this.clazz);
            }
            if (this.type == 1 || this.type == 2 || this.type == 4) {
                this.argtypes = new Class[argsnode.jjtGetNumChildren()];
                this.args = new Object[this.argtypes.length];
                for (int i = 0; i < this.argtypes.length; ++i) {
                    ExpressionNode node = (ExpressionNode)argsnode.jjtGetChild(i);
                    this.argtypes[i] = node.getStaticType();
                    if (!node.isConstant()) continue;
                    try {
                        this.args[i] = node.getValue(null);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (this.type == 1 && this.clazz != null) {
                    this.setStaticType(this.clazz);
                    this.constructors = this.findConstructors(this.clazz, this.argtypes);
                    if (this.constructors.length == 0) {
                        throw new ParseException("No constructor found for: " + this.clazz + SUtil.arrayToString(this.argtypes));
                    }
                    if (SReflect.isSupertype(AbstractPlan.class, this.clazz)) {
                        this.reloadable = true;
                    }
                } else if ((this.type == 2 || this.type == 4) && this.clazz != null) {
                    this.methods = this.findMethods(this.clazz, this.argtypes);
                    if (this.methods.length == 0) {
                        throw new ParseException("No " + this.getText() + " method found for: " + this.clazz + SUtil.arrayToString(this.argtypes));
                    }
                    Class<?> retype = null;
                    for (int i = 0; i < this.methods.length; ++i) {
                        if (i == 0) {
                            retype = this.methods[i].getReturnType();
                            continue;
                        }
                        if (retype == this.methods[i].getReturnType()) continue;
                        retype = null;
                    }
                    if (retype != null) {
                        this.setStaticType(SReflect.getWrappedType(retype));
                    }
                }
            } else if ((this.type == 3 || this.type == 5) && this.clazz != null) {
                if (this.type == 3 && this.getText().equals("class")) {
                    this.setStaticType(Class.class);
                    this.setConstantValue(this.clazz);
                    this.setConstant(true);
                } else if (this.type == 5 && this.clazz.isArray() && this.getText().equals("length")) {
                    this.setStaticType(Integer.TYPE);
                    if (type_or_value.isConstant()) {
                        try {
                            Object array = type_or_value.getValue(null);
                            this.setConstantValue(new Integer(Array.getLength(array)));
                            this.setConstant(true);
                        }
                        catch (Exception e) {}
                    }
                } else if (!SReflect.isSupertype(RBeliefbase.class, this.clazz) && !SReflect.isSupertype(IRParameterElement.class, this.clazz)) {
                    try {
                        this.field = SReflect.getCachedField(this.clazz, this.getText());
                        this.setStaticType(SReflect.getWrappedType(this.field.getType()));
                        if (this.type == 3 && !Modifier.isStatic(this.field.getModifiers())) {
                            throw new ParseException("Static reference to nonstatic field :" + this);
                        }
                        if (!Modifier.isFinal(this.field.getModifiers())) break block41;
                        try {
                            if (Modifier.isStatic(this.field.getModifiers())) {
                                this.setConstantValue(this.field.get(null));
                                this.setConstant(true);
                                break block41;
                            }
                            if (!type_or_value.isConstant()) break block41;
                            try {
                                Object value = type_or_value.getValue(null);
                                if (value == null) {
                                    throw new ParseException("Cannot reference nonstatic field of null value: " + this);
                                }
                                this.setConstantValue(this.field.get(value));
                                this.setConstant(true);
                            }
                            catch (ParseException e) {
                                throw e;
                            }
                            catch (Exception e) {
                            }
                        }
                        catch (IllegalAccessException e) {
                            throw new ParseException("Nonpublic field cannot be accessed: " + this);
                        }
                    }
                    catch (NoSuchFieldException e) {
                        this.throwParseException(e);
                    }
                }
            }
        }
    }

    public Object getValue(Map params) throws Exception {
        if (this.isConstant()) {
            return this.getConstantValue();
        }
        int child = 0;
        ExpressionNode type_or_value = (ExpressionNode)this.jjtGetChild(child++);
        ExpressionNode argsnode = this.jjtGetNumChildren() == child ? null : (ExpressionNode)this.jjtGetChild(child);
        Object value = null;
        if (this.type == 1 || this.type == 2 || this.type == 4) {
            Object[] args = new Object[argsnode.jjtGetNumChildren()];
            if (this.args != null) {
                System.arraycopy(this.args, 0, args, 0, args.length);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                args[i] = ((ExpressionNode)argsnode.jjtGetChild(i)).getValue(params);
            }
            Class[] argtypes = new Class[argsnode.jjtGetNumChildren()];
            if (this.argtypes != null) {
                System.arraycopy(this.argtypes, 0, argtypes, 0, argtypes.length);
            }
            for (int i = 0; i < argtypes.length; ++i) {
                if (argtypes[i] != null || args[i] == null) continue;
                argtypes[i] = args[i].getClass();
            }
            if (this.type == 1) {
                value = this.invokeConstructor((Class)type_or_value.getValue(params), argtypes, args);
            } else if (this.type == 4 || this.type == 2) {
                Object ref = null;
                if (this.type == 2 && this.clazz == null) {
                    this.clazz = (Class)type_or_value.getValue(params);
                } else {
                    ref = type_or_value.getValue(params);
                    if (ref == null) {
                        throw new RuntimeException("Cannot invoke nonstatic method on null value: " + this);
                    }
                    if (this.clazz == null) {
                        this.clazz = ref.getClass();
                    }
                }
                value = this.invokeMethod(ref, this.clazz, argtypes, args);
            }
        } else if (this.type == 5 || this.type == 3) {
            Object ref;
            Object object = ref = this.type == 3 ? null : type_or_value.getValue(params);
            if (this.type == 3 && this.getText().equals("class")) {
                value = type_or_value.getValue(params);
            } else if (this.type == 5 && ref != null && ref.getClass().isArray() && this.getText().equals("length")) {
                value = new Integer(Array.getLength(ref));
            } else {
                if (this.type != 3 && ref == null) {
                    throw new RuntimeException("Cannot reference nonstatic field of null value: " + this + ", " + type_or_value.getValue(params));
                }
                if (this.clazz == null) {
                    this.clazz = this.type == 3 ? (Class)type_or_value.getValue(params) : ref.getClass();
                }
                value = this.accessField(ref, this.clazz);
            }
        }
        return value;
    }

    public String toPlainString() {
        if (this.type == 1) {
            return "new " + this.jjtGetChild(0).toPlainString() + this.jjtGetChild(1).toPlainString();
        }
        if (this.type == 4 || this.type == 2) {
            return this.jjtGetChild(0).toPlainString() + "." + this.getText() + this.jjtGetChild(1).toPlainString();
        }
        return this.jjtGetChild(0).toPlainString() + "." + this.getText();
    }

    protected Constructor[] findConstructors(Class clazz, Class[] argtypes) {
        Constructor<?>[] cs = clazz.getConstructors();
        Class[][] paramtypes = new Class[cs.length][];
        for (int i = 0; i < cs.length; ++i) {
            paramtypes[i] = cs[i].getParameterTypes();
        }
        int[] matches = SReflect.matchArgumentTypes(argtypes, paramtypes);
        Constructor[] constructors = new Constructor[matches.length];
        for (int i = 0; i < matches.length; ++i) {
            constructors[i] = cs[matches[i]];
        }
        return constructors;
    }

    protected Method[] findMethods(Class clazz, Class[] argtypes) {
        Method[] ms = SReflect.getMethods(clazz, this.getText());
        ArrayList<Method> ames = new ArrayList<Method>();
        for (int i = 0; i < ms.length; ++i) {
            if (this.type == 2 && !Modifier.isStatic(ms[i].getModifiers())) continue;
            ames.add(ms[i]);
        }
        ms = ames.toArray(new Method[ames.size()]);
        Class[][] paramtypes = new Class[ms.length][];
        for (int i = 0; i < ms.length; ++i) {
            paramtypes[i] = ms[i].getParameterTypes();
        }
        int[] matches = SReflect.matchArgumentTypes(argtypes, paramtypes);
        Method[] methods = new Method[matches.length];
        for (int i = 0; i < matches.length; ++i) {
            methods[i] = ms[matches[i]];
        }
        return methods;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object invokeConstructor(Class clazz, Class[] argtypes, Object[] args) throws Exception {
        if (this.reloadable && Configuration.getConfiguration().isJavaCCPlanReloading()) {
            this.reloadedclass = DynamicURLClassLoader.loadModifiedClassWithInstance(this.reloadedclass != null ? this.reloadedclass : clazz);
            if (this.reloadedclass != clazz) {
                clazz = this.reloadedclass;
                this.constructors = null;
            }
        }
        Constructor con = null;
        if (this.constructors == null) {
            Constructor[] constructors = this.findConstructors(clazz, argtypes);
            if (constructors.length <= 0) throw new ParseException("No constructor found for: " + clazz + SUtil.arrayToString(argtypes));
            con = constructors[0];
        } else {
            Class[][] paramtypes = new Class[this.constructors.length][];
            for (int i = 0; i < this.constructors.length; ++i) {
                paramtypes[i] = this.constructors[i].getParameterTypes();
            }
            int[] matches = SReflect.matchArgumentTypes(argtypes, paramtypes);
            if (matches.length <= 0) throw new RuntimeException("No constructor found for " + clazz + SUtil.arrayToString(argtypes));
            con = this.constructors[matches[0]];
        }
        Object ret = null;
        try {
            return con.newInstance(args);
        }
        catch (InvocationTargetException e) {
            if (!(e.getTargetException() instanceof Exception)) throw e;
            throw (Exception)e.getTargetException();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object invokeMethod(Object ref, Class clazz, Class[] argtypes, Object[] args) throws Exception {
        Method method = null;
        if (this.methods == null) {
            Method[] methods = this.findMethods(clazz, argtypes);
            if (methods.length <= 0) throw new ParseException("No method found for term " + this + ": " + clazz + " " + this.getText() + SUtil.arrayToString(argtypes));
            method = methods[0];
        } else {
            Class[][] paramtypes = new Class[this.methods.length][];
            for (int i = 0; i < this.methods.length; ++i) {
                paramtypes[i] = this.methods[i].getParameterTypes();
            }
            int[] matches = SReflect.matchArgumentTypes(argtypes, paramtypes);
            if (matches.length <= 0) throw new ParseException("No method found for: " + clazz + " " + this.getText() + SUtil.arrayToString(argtypes));
            method = this.methods[matches[0]];
        }
        Method invmeth = this.getMethodForMethod(method);
        if (invmeth == null) {
            throw new ParseException("Method '" + method.getName() + "' declared on nonpublic class.");
        }
        Object ret = null;
        try {
            return invmeth.invoke(ref, args);
        }
        catch (InvocationTargetException e) {
            if (!(e.getTargetException() instanceof Exception)) throw e;
            throw (Exception)e.getTargetException();
        }
    }

    protected Object accessField(Object ref, Class clazz) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        boolean found = false;
        Object[] val = null;
        if (ref instanceof RBeliefbase) {
            RBeliefbase bb = (RBeliefbase)ref;
            if (bb.containsBelief(this.getText())) {
                val = bb.getBelief(this.getText()).getFact();
                found = true;
            } else if (bb.containsBeliefSet(this.getText())) {
                val = bb.getBeliefSet(this.getText()).getFacts();
                found = true;
            }
        } else if (ref instanceof IRParameterElement) {
            IRParameterElement pe = (IRParameterElement)ref;
            if (pe.hasParameter(this.getText())) {
                val = pe.getParameter(this.getText()).getValue();
                found = true;
            } else if (pe.hasParameterSet(this.getText())) {
                val = pe.getParameterSet(this.getText()).getValues();
                found = true;
            }
        }
        Field field0 = this.field;
        if (!found && field0 == null) {
            field0 = SReflect.getCachedField(clazz, this.getText());
            if (this.type == 3 && !Modifier.isStatic(field0.getModifiers())) {
                throw new RuntimeException("Static reference to nonstatic field :" + this);
            }
        }
        if (!found && field0 != null) {
            val = field0.get(ref);
            found = true;
        }
        if (!$assertionsDisabled && !found) {
            throw new AssertionError();
        }
        return val;
    }

    protected Method getMethodForMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if ((clazz.getModifiers() & 1) == 0) {
            ArrayList classes = new ArrayList();
            if (clazz.getSuperclass() != null) {
                classes.add(clazz.getSuperclass());
            }
            classes.addAll(Arrays.asList(clazz.getInterfaces()));
            Method meth = null;
            while (meth == null && classes.size() > 0) {
                Class testclass = (Class)classes.remove(0);
                try {
                    if ((testclass.getModifiers() & 1) != 0) {
                        meth = testclass.getMethod(method.getName(), method.getParameterTypes());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (meth != null) continue;
                if (testclass.getSuperclass() != null) {
                    classes.add(testclass.getSuperclass());
                }
                classes.addAll(Arrays.asList(testclass.getInterfaces()));
            }
            method = meth;
        }
        return method;
    }

    static {
        $assertionsDisabled = !ReflectNode.class.desiredAssertionStatus();
    }
}

