/*
 * Decompiled with CFR 0.152.
 */
package jadex.parser.javaccimpl;

import jadex.parser.IParser;
import jadex.parser.IParserFactory;
import jadex.parser.ITerm;
import jadex.parser.ParserException;
import jadex.parser.javaccimpl.ExpressionNode;
import jadex.parser.javaccimpl.ParseException;
import jadex.parser.javaccimpl.ParserImpl;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;

public class Parser
implements IParser,
IParserFactory,
Serializable {
    protected String[] imports;

    public Parser() {
        this(null);
    }

    public Parser(String[] imports) {
        this.imports = imports;
    }

    public ITerm parseExpression(String expression, List parameters) {
        ExpressionNode node;
        if (expression == null) {
            throw new ParserException("String required for parsing: " + expression);
        }
        ParserImpl parser = new ParserImpl(new StringReader(expression));
        parser.setImports(this.imports);
        try {
            node = parser.parseExpression();
            node.precompileTree();
        }
        catch (ParseException e) {
            throw new ParserException("Error parsing: " + expression + "\n" + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ParserException("Error parsing: " + expression + "\n" + e);
        }
        return node;
    }

    public Object parseClass(String code, Class base) {
        throw new RuntimeException("ParseScript not supported by this parser impl: " + this);
    }

    public IParser createParser(String[] imports) {
        return new Parser(imports);
    }

    public IParser createParser(String[] imports, String filename, long lastmodified) {
        return new Parser(imports);
    }
}

