/*
 * Decompiled with CFR 0.152.
 */
package jadex.parser.javaccimpl;

import jadex.parser.ITerm;
import jadex.parser.javaccimpl.Node;
import jadex.parser.javaccimpl.ParameterNode;
import jadex.parser.javaccimpl.ParseException;
import jadex.parser.javaccimpl.ParserImpl;
import jadex.parser.javaccimpl.ParserImplTreeConstants;
import jadex.parser.javaccimpl.ReflectNode;
import jadex.parser.javaccimpl.SimpleNode;
import jadex.util.SUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ExpressionNode
extends SimpleNode
implements ITerm {
    protected String text;
    protected String[] imports;
    protected Class static_type;
    protected boolean constant;
    protected Object constant_value;

    public ExpressionNode(ParserImpl p, int id) {
        super(p, id);
        this.imports = p.getImports();
    }

    public void setText(String text) {
        this.text = text;
    }

    public void appendText(String text) {
        this.text = this.text == null ? text : this.text + text;
    }

    public String getText() {
        return this.text;
    }

    public void setStaticType(Class static_type) {
        this.static_type = static_type;
    }

    public Class getStaticType() {
        return this.static_type;
    }

    public void setConstantValue(Object constant_value) {
        this.constant_value = constant_value;
    }

    public Object getConstantValue() {
        return this.constant_value;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public String toString(String prefix) {
        return prefix + ParserImplTreeConstants.jjtNodeName[this.id] + "(" + this.text + ")";
    }

    public String toPlainString() {
        return super.toString();
    }

    public String toString() {
        return "<" + this.toPlainString() + ">";
    }

    protected String subnodeToString(int subnode) {
        Node node = this.jjtGetChild(subnode);
        if (node.jjtGetNumChildren() == 0) {
            return node.toPlainString();
        }
        return "(" + node.toPlainString() + ")";
    }

    public abstract Object getValue(Map var1) throws Exception;

    public List getRelevantEventtypes() {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        ParameterNode[] params = this.getUnboundParameterNodes();
        for (int i = 0; i < params.length; ++i) {
            ExpressionNode arg;
            if (!(params[i].jjtGetParent() instanceof ReflectNode)) continue;
            ReflectNode ref = (ReflectNode)params[i].jjtGetParent();
            if (params[i].getText().equals("$beliefbase")) {
                if (ref.getType() == 5) {
                    ret.add(new String[]{"$beliefbase", ref.getText()});
                    continue;
                }
                if (ref.getType() == 4 && ref.getText().equals("getBelief")) {
                    arg = (ExpressionNode)ref.jjtGetChild(1).jjtGetChild(0);
                    if (!arg.isConstant()) {
                        System.out.println("Warning: Reference to dynamic belief - affecting events cannot be determined: " + this);
                        System.out.println(arg);
                        continue;
                    }
                    ret.add(new String[]{"$beliefbase", (String)arg.getConstantValue()});
                    continue;
                }
                if (ref.getType() != 4 || !ref.getText().equals("getBeliefSet")) continue;
                arg = (ExpressionNode)ref.jjtGetChild(1).jjtGetChild(0);
                if (!arg.isConstant()) {
                    System.out.println("Warning: Reference to dynamic belief set - affecting events cannot be determined: " + this);
                    System.out.println(arg);
                    continue;
                }
                ret.add(new String[]{"$beliefbase", (String)arg.getConstantValue()});
                continue;
            }
            if (params[i].getText().equals("$goalbase")) {
                if (ref.getType() == 4 && ref.getText().equals("getGoals") && ref.jjtGetChild(1).jjtGetNumChildren() > 0) {
                    arg = (ExpressionNode)ref.jjtGetChild(1).jjtGetChild(0);
                    if (!arg.isConstant()) {
                        System.out.println("Warning: Reference to dynamic \u00b4goal - affecting events cannot be determined: " + this);
                        System.out.println(arg);
                        continue;
                    }
                    ret.add(new String[]{"$goalbase", (String)arg.getConstantValue()});
                    continue;
                }
                if (ref.getType() != 4 || !ref.getText().equals("getGoals")) continue;
                ret.add(new String[]{"$goalbase", null});
                continue;
            }
            if (params[i].getText().equals("$goal")) {
                if (ref.getType() == 5) {
                    ret.add(new String[]{"$goal", ref.getText()});
                    continue;
                }
                if (ref.getType() == 4 && ref.getText().equals("getParameter")) {
                    arg = (ExpressionNode)ref.jjtGetChild(1).jjtGetChild(0);
                    if (!arg.isConstant()) {
                        System.out.println("Warning: Reference to dynamic parameter - affecting events cannot be determined: " + this);
                        System.out.println(arg);
                        continue;
                    }
                    ret.add(new String[]{"$goal", (String)arg.getConstantValue()});
                    continue;
                }
                if (ref.getType() != 4 || !ref.getText().equals("getParameterSet")) continue;
                arg = (ExpressionNode)ref.jjtGetChild(1).jjtGetChild(0);
                if (!arg.isConstant()) {
                    System.out.println("Warning: Reference to dynamic parameter set - affecting events cannot be determined: " + this);
                    System.out.println(arg);
                    continue;
                }
                ret.add(new String[]{"$goal", (String)arg.getConstantValue()});
                continue;
            }
            if (!params[i].getText().equals("$plan")) continue;
            if (ref.getType() == 5) {
                ret.add(new String[]{"$plan", ref.getText()});
                continue;
            }
            if (ref.getType() == 4 && ref.getText().equals("getParameter")) {
                arg = (ExpressionNode)ref.jjtGetChild(1).jjtGetChild(0);
                if (!arg.isConstant()) {
                    System.out.println("Warning: Reference to dynamic parameter - affecting events cannot be determined: " + this);
                    System.out.println(arg);
                    continue;
                }
                ret.add(new String[]{"$plan", (String)arg.getConstantValue()});
                continue;
            }
            if (ref.getType() != 4 || !ref.getText().equals("getParameterSet")) continue;
            arg = (ExpressionNode)ref.jjtGetChild(1).jjtGetChild(0);
            if (!arg.isConstant()) {
                System.out.println("Warning: Reference to dynamic parameter set - affecting events cannot be determined: " + this);
                System.out.println(arg);
                continue;
            }
            ret.add(new String[]{"$plan", (String)arg.getConstantValue()});
        }
        return ret;
    }

    protected ParameterNode[] getUnboundParameterNodes() {
        ParameterNode[] ret = new ParameterNode[]{};
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            ret = (ParameterNode[])SUtil.joinArrays(ret, ((ExpressionNode)this.jjtGetChild(i)).getUnboundParameterNodes());
        }
        return ret;
    }

    public void precompile() {
    }

    public void precompileTree() {
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            ((ExpressionNode)this.jjtGetChild(i)).precompileTree();
        }
        this.precompile();
    }

    protected void throwParseException(Throwable ex) throws ParseException {
        Node root = this;
        while (root.jjtGetParent() != null) {
            root = root.jjtGetParent();
        }
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        throw new ParseException("Exception while parsing expression: " + root.toPlainString() + "\n" + sw);
    }

    protected void throwEvaluationException(Throwable ex) throws RuntimeException {
        Node root = this;
        while (root.jjtGetParent() != null) {
            root = root.jjtGetParent();
        }
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        throw new RuntimeException("Exception while evaluating expression: " + root.toPlainString() + "\n" + sw);
    }
}

